/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.support.persistence.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.opensingular.lib.commons.base.SingularProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlUtil.class);
    private static final List<String> CRUD_OPERATIONS = Arrays.asList("SELECT", "UPDATE", "DELETE", "INSERT");

    private SqlUtil() {
    }

    @Nonnull
    public static String replaceInSQL(@Nonnull String sql, @Nonnull String current, @Nonnull String replacement) {
        return sql.replaceAll(current, replacement);
    }

    public static boolean isSingularSchema(String schemaName) {
        return SqlUtil.replaceSingularSchemaName("DBSINGULAR").equals(schemaName);
    }

    @Nonnull
    public static String replaceSingularSchemaName(@Nonnull String sql) {
        Optional customSchema = SingularProperties.getOpt((String)"singular.custom.schema.name");
        return customSchema.map(s -> SqlUtil.replaceSchemaName(sql, "DBSINGULAR", s)).orElse(sql);
    }

    @Nonnull
    public static String replaceSchemaName(@Nonnull String sql, @Nonnull String defaultSchema, @Nonnull String schemaReplacement) {
        LOGGER.trace("Running database schema replacement from  {} to {}", (Object)defaultSchema, (Object)schemaReplacement);
        return SqlUtil.replaceInSQL(sql, defaultSchema, schemaReplacement);
    }

    public static boolean hasCompleteCrud(List<String> vals) {
        if (CollectionUtils.isEmpty(vals)) {
            return false;
        }
        for (String crudOperation : CRUD_OPERATIONS) {
            if (vals.contains(crudOperation)) continue;
            return false;
        }
        return true;
    }

    public static boolean useEmbeddedDatabase() {
        if (SingularProperties.getOpt((String)"singular.database.embedded").isPresent()) {
            return SingularProperties.get().isTrue("singular.database.embedded");
        }
        return !SingularProperties.get().isFalse("singular.development");
    }

    public static boolean isDropCreateDatabase() {
        return SingularProperties.get().isTrue("singular.database.recreate");
    }
}

