/*
 * Copyright (C) 2016 Singular Studios (a.k.a Atom Tecnologia) - www.opensingular.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensingular.lib.wicket.util.behavior;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.time.Duration;
import org.opensingular.lib.wicket.util.jquery.JQuery;

public class FadeInOnceBehavior extends AttributeAppender {

    private final Duration duration;

    public FadeInOnceBehavior() {
        this(Duration.milliseconds(500));
    }
    public FadeInOnceBehavior(Duration duration) {
        super("style", "display:none !important", ";");
        this.duration = duration;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(OnDomReadyHeaderItem.forScript(
            JQuery.$(component)
                + ".fadeIn(" + duration.getMilliseconds() + ");"));
    }

    @Override
    public boolean isTemporary(Component component) {
        return true;
    }
}
