/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.config;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.tno.bim.nmd.config.NmdConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class NmdConfigImpl
implements NmdConfig {
    private String token;
    private int id;
    private String nmd2path;
    private String rootPath;
    private static final String rootNode = "nmd";

    private NmdConfigImpl(Map<String, String> nmdPropertyMap) {
        this.setToken(nmdPropertyMap.get("token"));
        this.setClientId(Integer.parseInt(nmdPropertyMap.get("id")));
        this.setNmd2DbPath(nmdPropertyMap.get("nmd2Path"));
    }

    public NmdConfigImpl() {
        this(NmdConfigImpl.loadResources((Path)Paths.get(System.getProperty("user.dir"), new String[0]), (String)"nmd"));
        String parentPath;
        this.rootPath = parentPath = new File(System.getProperty("user.dir")).getParentFile().toString();
    }

    public NmdConfigImpl(Path rootPath) {
        this(NmdConfigImpl.loadResources((Path)rootPath, (String)"nmd"));
        String parentPath;
        this.rootPath = parentPath = new File(rootPath.toAbsolutePath().toString()).getParentFile().toString();
    }

    private static Map<String, String> loadResources(Path rootPath, String rootNode) {
        HashMap<String, String> res = new HashMap<String, String>();
        Path configPath = rootPath.resolve("config.xml");
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                try (InputStream newInputStream = Files.newInputStream(configPath, new OpenOption[0]);){
                    Document doc = documentBuilder.parse(newInputStream);
                    Consumer<Node> addNodedata = node -> res.put(node.getNodeName(), node.getTextContent());
                    for (int i = 0; i < doc.getChildNodes().getLength(); ++i) {
                        Node node2 = doc.getChildNodes().item(i);
                        NmdConfigImpl.performMethodForRecursiveNode((Node)node2, addNodedata);
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        } else {
            System.err.println("config.xml not found");
        }
        return res;
    }

    private static void performMethodForRecursiveNode(Node node, Consumer<Node> method) {
        method.accept(node);
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            NmdConfigImpl.performMethodForRecursiveNode((Node)child, method);
        }
    }

    public String getToken() {
        return this.token;
    }

    public Integer getClientId() {
        return this.id;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setClientId(int id) {
        this.id = id;
    }

    public String getNmd2DbPath() {
        return this.rootPath + "//" + this.nmd2path;
    }

    public void setNmd2DbPath(String path) {
        this.nmd2path = path;
    }
}

