/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.controller;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import nl.tno.bim.nmd.controller.BaseNMDController;
import nl.tno.bim.nmd.domain.NmdProductCard;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/api"})
public class ProductCardController
extends BaseNMDController {
    private static final Logger logger = Logger.getLogger(ProductCardController.class);

    protected Logger getLogger() {
        return logger;
    }

    @ApiOperation(value="Get ProductCard By Ids ")
    @RequestMapping(method={RequestMethod.GET}, value={"/{versionId}/productcard/{ids}"})
    public ResponseEntity<List<NmdProductCard>> getProductCardByIds(@PathVariable Integer versionId, @PathVariable String ids) {
        String[] sIds;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"triggering method getProductCardByIds ");
        }
        ArrayList<Long> pcIds = new ArrayList<Long>();
        for (String id : sIds = ids.split(",")) {
            pcIds.add(Long.parseLong(id));
        }
        List pcs = this.getService(versionId).getProductCardsByIds(pcIds);
        if (pcs == null || pcs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"returning 404 no data found ");
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"returning ProductCards 200 object");
        }
        pcs.forEach(pc -> this.getService(versionId).getAdditionalProfileDataForCard(pc));
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)pcs);
    }
}

