/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.domain;

import java.util.Arrays;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class NlsfbCode {
    private Integer majorId;
    Integer mediorId;
    Integer minorId;

    public NlsfbCode(String code) {
        if (!NlsfbCode.isNlsfbCode((String)code).booleanValue()) {
            System.err.println("Invalid NlsfbCode");
            this.majorId = -1;
            this.mediorId = -1;
            this.minorId = -1;
        } else {
            String[] split = code.split("\\.");
            this.majorId = Integer.parseInt(split[0].trim());
            if (split.length > 1) {
                this.mediorId = Integer.parseInt(split[1].trim());
            }
            if (split.length > 2) {
                this.minorId = Integer.parseInt(split[2].trim());
            }
        }
    }

    public static Boolean isNlsfbCode(String code) {
        if (code == null) {
            return false;
        }
        List<String> split = Arrays.asList(code.split("\\."));
        return split.size() > 0 && split.stream().anyMatch(i -> i.matches("-?(0|[1-9]\\d*)"));
    }

    public Boolean isSubCategoryOf(NlsfbCode code) {
        return this.majorId == code.getMajorId() && this.compareSubCodes(code.getMediorId(), this.getMediorId()) != false;
    }

    private Boolean compareSubCodes(Integer codeA, Integer codeB) {
        int[] digitsB;
        if (codeA == null && codeB != null) {
            return true;
        }
        int[] digitsA = String.valueOf(codeA).chars().toArray();
        if (digitsA.length > (digitsB = String.valueOf(codeB).chars().toArray()).length) {
            return false;
        }
        for (int i = 0; i < digitsA.length; ++i) {
            if (digitsA[i] == digitsB[i]) continue;
            return false;
        }
        return true;
    }

    public String print() {
        String res = "";
        if (this.getMajorId() != null) {
            res = res + this.getMajorId().toString();
            if (this.getMediorId() != null && this.getMediorId() > 0) {
                res = res + "." + this.mediorId.toString();
                if (this.getMinorId() != null && this.getMinorId() > 0) {
                    res = res + "." + this.getMinorId().toString();
                }
            }
        }
        return res;
    }

    public Integer getMajorId() {
        return this.majorId;
    }

    public Integer getMediorId() {
        return this.mediorId;
    }

    public Integer getMinorId() {
        return this.minorId;
    }
}

