/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.tno.bim.nmd.domain.NmdCostFactor;
import nl.tno.bim.nmd.domain.NmdFaseProfiel;
import nl.tno.bim.nmd.domain.NmdMilieuCategorie;
import nl.tno.bim.nmd.domain.NmdReferenceResources;

public class NmdFaseProfielImpl
implements NmdFaseProfiel {
    private HashMap<String, Double> profielCoefficienten = new HashMap();
    private String fase;
    private NmdReferenceResources refData;

    public NmdFaseProfielImpl(String fase, NmdReferenceResources referenceData) {
        this.refData = referenceData;
        this.setAll(0.0);
        this.fase = fase;
    }

    public void setAll(double value) {
        for (Map.Entry factor : this.refData.getMilieuCategorieMapping().entrySet()) {
            this.setProfielCoefficient(((NmdMilieuCategorie)factor.getValue()).getDescription(), value);
        }
    }

    public double getProfielCoefficient(String milieuCategorie) {
        return this.profielCoefficienten.getOrDefault(milieuCategorie, 0.0);
    }

    public void setProfielCoefficient(String milieuCategorie, double value) {
        this.profielCoefficienten.put(milieuCategorie, value);
    }

    public String getFase() {
        return this.fase;
    }

    public Set<NmdCostFactor> calculateFactors(double cost) {
        HashSet<NmdCostFactor> results = new HashSet<NmdCostFactor>();
        for (Map.Entry entry : this.refData.getMilieuCategorieMapping().entrySet()) {
            String description = ((NmdMilieuCategorie)entry.getValue()).getDescription();
            Double profielValue = this.profielCoefficienten.getOrDefault(description, Double.NaN);
            if (profielValue.isNaN()) continue;
            results.add(new NmdCostFactor(this.fase, description, cost * profielValue * ((NmdMilieuCategorie)entry.getValue()).getWeight()));
        }
        return results;
    }

    public Double getCoefficientSum() {
        return this.profielCoefficienten.values().stream().filter(v -> !v.isNaN()).mapToDouble(v -> v).sum();
    }
}

