/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import nl.tno.bim.nmd.domain.NlsfbCode;
import nl.tno.bim.nmd.domain.NmdProductCard;
import nl.tno.bim.nmd.domain.NmdProfileSet;

public class NmdProductCardImpl
implements NmdProductCard {
    private String description;
    private Set<NmdProfileSet> specifications;
    private Boolean isTotaalProduct;
    private String unit;
    private Integer category;
    private Boolean isScalable;
    private Integer productLifetime;
    private Integer parentId;
    private Integer id;
    private NlsfbCode nlsfbCode;

    public NmdProductCardImpl() {
        this.specifications = new HashSet();
        this.isTotaalProduct = false;
        this.description = "";
    }

    public NmdProductCardImpl(NmdProductCard p) {
        if (p == null) {
            p = new NmdProductCardImpl();
        }
        this.id = p.getProductId();
        this.isScalable = p.getIsScalable();
        this.parentId = p.getParentProductId();
        this.specifications = new HashSet();
        this.specifications.addAll(p.getProfileSets());
        this.setLifetime(p.getLifetime());
        this.setCategory(p.getCategory());
        this.setNlsfbCode(p.getNlsfbCode());
        this.setUnit(p.getUnit());
        this.setDescription(p.getDescription());
        this.setIsTotaalProduct(p.getIsTotaalProduct().booleanValue());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public NlsfbCode getNlsfbCode() {
        return this.nlsfbCode;
    }

    public void setNlsfbCode(NlsfbCode code) {
        this.nlsfbCode = code;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Set<NmdProfileSet> getProfileSets() {
        return this.specifications;
    }

    public void addProfileSet(NmdProfileSet spec) {
        if (spec != null) {
            this.specifications.add(spec);
        }
    }

    public void addProfileSets(Collection<NmdProfileSet> specs) {
        if (specs != null && specs.size() > 0) {
            this.specifications.addAll(specs);
        }
    }

    public Boolean getIsTotaalProduct() {
        return this.isTotaalProduct;
    }

    public void setIsTotaalProduct(boolean b) {
        this.isTotaalProduct = b;
    }

    public Integer getCategory() {
        return this.category;
    }

    public void setCategory(Integer cat) {
        this.category = cat;
    }

    public Boolean getIsScalable() {
        return this.isScalable;
    }

    public void setIsScalable(Boolean scalable) {
        this.isScalable = scalable;
    }

    public Integer getLifetime() {
        return this.productLifetime;
    }

    public void setLifetime(Integer lifetime) {
        this.productLifetime = lifetime;
    }

    public Integer getParentProductId() {
        return this.parentId;
    }

    public void setParentProductId(Integer id) {
        this.parentId = id;
    }

    public Integer getProductId() {
        return this.id;
    }

    public void setProductId(Integer id) {
        this.id = id;
    }

    public Double getProfileSetsCoeficientSum() {
        return this.getProfileSets().stream().collect(Collectors.summingDouble(ps -> ps.getCoefficientSum()));
    }
}

