/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.scaling;

import java.util.Arrays;
import nl.tno.bim.nmd.scaling.NmdScaler;
import org.apache.commons.lang3.ArrayUtils;

public abstract class NmdBaseScaler
implements NmdScaler {
    protected String unit;
    protected Double[] coefficients;
    protected Double[] bounds;
    private Double[] currentValues;

    public NmdBaseScaler(String unit, Double[] coefficients, Double[] bounds, Double[] currentValues) {
        this.unit = unit;
        this.coefficients = coefficients;
        this.bounds = bounds;
        this.currentValues = currentValues;
    }

    private Double scale(double dim1Val, double dim2Val) {
        if (this.areDimsWithinBounds(Double.valueOf(dim1Val), Double.valueOf(dim2Val)).booleanValue()) {
            return this.getNumberOfDimensions() == 1 ? this.scale(dim1Val) * this.scale(dim2Val) : this.scale(dim1Val) * this.getScaleFactor(dim2Val, this.currentValues[1]);
        }
        return Double.NaN;
    }

    private Double scale(double dim1Val) {
        return this.getScaleFactor(dim1Val, this.currentValues[0]);
    }

    public Double scaleWithConversion(Double[] dims, double conversionFactor) {
        Double[] sortedDims = this.matchInputDimensionsOnCurrentDimensions(dims);
        if (sortedDims.length == 1) {
            return this.scale(sortedDims[0] * conversionFactor);
        }
        if (sortedDims.length == 2) {
            return this.scale(sortedDims[0] * conversionFactor, sortedDims[1] * conversionFactor);
        }
        return Double.NaN;
    }

    private Double[] matchInputDimensionsOnCurrentDimensions(Double[] dims) {
        if (this.currentValues.length > 1 && dims.length > 1) {
            Arrays.sort((Object[])dims);
            if (this.currentValues[1] <= this.currentValues[0]) {
                ArrayUtils.reverse((Object[])dims);
            }
        }
        return dims;
    }

    private Boolean areDimsWithinBounds(Double x, Double y) {
        if (this.getNumberOfDimensions() == 1) {
            return this.isWithinBounds(x.doubleValue(), this.bounds[0].doubleValue(), this.bounds[1].doubleValue()) != false && this.isWithinBounds(y.doubleValue(), this.bounds[0].doubleValue(), this.bounds[1].doubleValue()) != false;
        }
        return this.isWithinBounds(x.doubleValue(), this.bounds[0].doubleValue(), this.bounds[1].doubleValue()) != false && this.isWithinBounds(y.doubleValue(), this.bounds[2].doubleValue(), this.bounds[3].doubleValue()) != false;
    }

    public Boolean areDimsWithinBounds(Double[] dims, double conversionFactor) {
        if (dims.length == 1) {
            return this.areDimsWithinBounds(Double.valueOf(dims[0] * conversionFactor), Double.valueOf(dims[0] * conversionFactor));
        }
        if (dims.length == 2) {
            return this.areDimsWithinBounds(Double.valueOf(dims[0] * conversionFactor), Double.valueOf(dims[1] * conversionFactor));
        }
        return false;
    }

    private Boolean isWithinBounds(double x, double x_min, double x_max) {
        return x <= x_max && x >= x_min;
    }

    public Integer getNumberOfDimensions() {
        return this.bounds.length == 4 && !this.bounds[3].isNaN() && this.currentValues.length == 2 && !this.currentValues[1].isNaN() ? 2 : 1;
    }

    protected double getScaleFactor(double x_desired, Double x_current) {
        return this.calculate(Double.valueOf(x_desired)) / this.calculate(x_current);
    }

    public String getUnit() {
        return this.unit;
    }

    protected abstract Double calculate(Double var1);
}

