/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.scaling;

import nl.tno.bim.nmd.scaling.NmdBaseScaler;
import nl.tno.bim.nmd.scaling.NmdScaler;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class NmdLogarithmicScaler
extends NmdBaseScaler
implements NmdScaler {
    public NmdLogarithmicScaler(String scaleUnit, Double[] coefficients, Double[] bounds, Double[] currentValues) throws InvalidInputException {
        super(scaleUnit, coefficients, bounds, currentValues);
        if (currentValues[0] == 1.0 || currentValues[1] == 1.0) {
            throw new InvalidInputException("Cannot have a unit value for a logarithmic scaler as it creates a division by 0 error on scaling");
        }
    }

    protected Double calculate(Double x) {
        if (x == 0.0) {
            return Double.NaN;
        }
        return this.coefficients[0] * Math.log(x) + this.coefficients[2];
    }
}

