/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.scaling;

import nl.tno.bim.nmd.scaling.NmdExponentialScaler;
import nl.tno.bim.nmd.scaling.NmdLinearScaler;
import nl.tno.bim.nmd.scaling.NmdLogarithmicScaler;
import nl.tno.bim.nmd.scaling.NmdPowerScaler;
import nl.tno.bim.nmd.scaling.NmdScaler;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public final class NmdScalerFactory {
    public NmdScaler create(String type, String scaleUnit, Double[] coefficients, Double[] bounds, Double[] currentValues) throws InvalidInputException {
        String lcType = type.toLowerCase();
        if (lcType.contains("linear")) {
            return this.createLinScaler(scaleUnit, coefficients, bounds, currentValues);
        }
        if (lcType.contains("macht")) {
            return this.createPowScaler(scaleUnit, coefficients, bounds, currentValues);
        }
        if (lcType.contains("logaritmisch")) {
            return this.createLogScaler(scaleUnit, coefficients, bounds, currentValues);
        }
        if (lcType.contains("exponentieel")) {
            return this.createExpScaler(scaleUnit, coefficients, bounds, currentValues);
        }
        return null;
    }

    public NmdExponentialScaler createExpScaler(String scaleUnit, Double[] coefficients, Double[] bounds, Double[] currentValues) {
        return new NmdExponentialScaler(scaleUnit, coefficients, bounds, currentValues);
    }

    public NmdLogarithmicScaler createLogScaler(String scaleUnit, Double[] coefficients, Double[] bounds, Double[] currentValues) throws InvalidInputException {
        return new NmdLogarithmicScaler(scaleUnit, coefficients, bounds, currentValues);
    }

    public NmdPowerScaler createPowScaler(String scaleUnit, Double[] coefficients, Double[] bounds, Double[] currentValues) {
        return new NmdPowerScaler(scaleUnit, coefficients, bounds, currentValues);
    }

    public NmdLinearScaler createLinScaler(String scaleUnit, Double[] coefficients, Double[] bounds, Double[] currentValues) {
        return new NmdLinearScaler(scaleUnit, coefficients, bounds, currentValues);
    }
}

