/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.services;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.tno.bim.nmd.domain.NlsfbCode;
import nl.tno.bim.nmd.domain.NmdElement;
import nl.tno.bim.nmd.domain.NmdProductCard;
import nl.tno.bim.nmd.services.NmdDataService;

public interface BaseNmdDataService
extends NmdDataService {
    public List<NmdElement> getData();

    public void preLoadData();

    default public List<NmdProductCard> getProductsForNLsfbCodes(Set<NlsfbCode> codes) {
        if (this.getData().size() == 0) {
            this.preLoadData();
        }
        List<NmdProductCard> res = this.getElementsForNLsfbCodes(codes).stream().flatMap(el -> el.getProducts().stream()).collect(Collectors.toList());
        return res;
    }

    default public List<NmdElement> getElementsForNLsfbCodes(Set<NlsfbCode> codes) {
        if (this.getData().size() == 0) {
            this.preLoadData();
        }
        return this.getData().stream().filter(el -> codes.stream().anyMatch(code -> code == null ? false : el.getNlsfbCode().isSubCategoryOf(code))).collect(Collectors.toList());
    }

    default public List<NmdProductCard> getProductCardsByIds(List<Long> ids) {
        if (this.getData().size() == 0) {
            this.preLoadData();
        }
        return this.getData().stream().flatMap(el -> el.getProducts().stream()).filter(pc -> ids.contains(pc.getProductId())).collect(Collectors.toList());
    }
}

