/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.services;

import java.nio.file.Path;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import nl.tno.bim.nmd.config.NmdConfig;
import nl.tno.bim.nmd.config.NmdConfigImpl;
import nl.tno.bim.nmd.domain.NlsfbCode;
import nl.tno.bim.nmd.domain.NmdElement;
import nl.tno.bim.nmd.domain.NmdElementImpl;
import nl.tno.bim.nmd.domain.NmdFaseProfiel;
import nl.tno.bim.nmd.domain.NmdFaseProfielImpl;
import nl.tno.bim.nmd.domain.NmdMilieuCategorie;
import nl.tno.bim.nmd.domain.NmdProductCard;
import nl.tno.bim.nmd.domain.NmdProductCardImpl;
import nl.tno.bim.nmd.domain.NmdProfileSet;
import nl.tno.bim.nmd.domain.NmdProfileSetImpl;
import nl.tno.bim.nmd.domain.NmdReferenceResources;
import nl.tno.bim.nmd.services.BaseNmdDataService;
import nl.tno.bim.nmd.services.SqliteDataService;

public class Nmd2DataService
extends SqliteDataService
implements BaseNmdDataService {
    private List<NmdElement> data;
    private NmdReferenceResources resources;
    private NmdConfig config;

    public Nmd2DataService() {
        this.config = new NmdConfigImpl();
        this.data = new ArrayList();
    }

    public Nmd2DataService(Path rootPath) {
        this.config = new NmdConfigImpl(rootPath);
        this.data = new ArrayList();
    }

    public void login() {
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.config.getNmd2DbPath());
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        this.loadResources();
    }

    public void preLoadData() {
        if (!this.getIsConnected().booleanValue()) {
            this.login();
        }
        this.data = this.getAllElements();
    }

    private void loadResources() {
        if (this.resources == null) {
            this.resources = new NmdReferenceResources();
            this.resources.setMilieuCategorieMapping(this.getMilieuWaardeMapping());
        }
    }

    public Calendar getRequestDate() {
        return Calendar.getInstance();
    }

    public void setRequestDate(Calendar newDate) {
    }

    public List<NmdElement> getAllElements() {
        if (!this.getIsConnected().booleanValue()) {
            this.login();
        }
        ArrayList<NmdElement> elements = new ArrayList<NmdElement>();
        try {
            Statement statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select * from Element");
            while (rs.next()) {
                NmdElementImpl el = new NmdElementImpl();
                el.setElementId(Integer.valueOf(rs.getInt("id")));
                el.setElementName(rs.getString("elementnaam"));
                el.setIsMandatory(Boolean.valueOf(true));
                el.setParentId(Integer.valueOf(0));
                el.setNlsfbCode(new NlsfbCode(rs.getString("code").trim()));
                elements.add((NmdElement)el);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        for (NmdElement el : elements) {
            el.addProductCards(this.getProductsForElement(el));
        }
        return elements;
    }

    public List<NmdElement> getData() {
        return this.data;
    }

    public HashMap<Integer, NmdProfileSet> getProfileSetsByIds(List<Integer> ids) {
        return null;
    }

    public List<NmdProductCard> getProductsForElement(NmdElement element) {
        ArrayList<NmdProductCard> products = new ArrayList<NmdProductCard>();
        try {
            Statement statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select * from Product where element_id = " + element.getElementId().toString());
            while (rs.next()) {
                NmdProductCardImpl prod = new NmdProductCardImpl();
                prod.setProductId(Integer.valueOf(rs.getInt("id")));
                prod.setCategory(Integer.valueOf(rs.getInt("type_kaart_id")));
                prod.setDescription(rs.getString("productnaam"));
                prod.setIsScalable(Boolean.valueOf(true));
                prod.setIsTotaalProduct(false);
                prod.setLifetime(Integer.valueOf(rs.getInt("productlevensduur")));
                prod.setUnit(rs.getString("functionele_eenheid"));
                prod.setNlsfbCode(new NlsfbCode(rs.getString("productcode")));
                products.add((NmdProductCard)prod);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return products;
    }

    public Boolean getAdditionalProfileDataForCard(NmdProductCard c) {
        Statement statement;
        if (c.getProfileSets().size() > 0) {
            return true;
        }
        try {
            statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select * from Productonderdeel where product_id = " + c.getProductId().toString());
            while (rs.next()) {
                NmdProfileSetImpl pset = new NmdProfileSetImpl();
                pset.setName(rs.getString("omschrijving"));
                pset.setProfielId(Integer.valueOf(rs.getInt("basisprofiel_id")));
                pset.setProfileLifetime(Integer.valueOf(rs.getInt("levensduur")));
                pset.setQuantity(rs.getDouble("hoeveelheid"));
                pset.setUnit(rs.getString("eenheid"));
                pset.setIsScalable(Boolean.valueOf(true));
                pset.setScaler(null);
                c.addProfileSet((NmdProfileSet)pset);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            return false;
        }
        try {
            statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            for (NmdProfileSet ps : c.getProfileSets()) {
                ResultSet rsMC = statement.executeQuery("select * from Profielmilieueffect as pme inner join Milieucategorie as mc on pme.milieucategorie_id = mc.id where profiel_id = " + ps.getProfielId().toString());
                NmdFaseProfielImpl fp = new NmdFaseProfielImpl("Construction", this.resources);
                while (rsMC.next()) {
                    String name = rsMC.getString("milieueffect");
                    Double value = rsMC.getDouble("waarde");
                    fp.setProfielCoefficient(name, value.doubleValue());
                }
                ps.addFaseProfiel("Construction", (NmdFaseProfiel)fp);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    private HashMap<Integer, NmdMilieuCategorie> getMilieuWaardeMapping() {
        HashMap<Integer, NmdMilieuCategorie> map = new HashMap<Integer, NmdMilieuCategorie>();
        try {
            Statement statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            ResultSet rs = statement.executeQuery("select * from Milieucategorie");
            while (rs.next()) {
                Integer id = rs.getInt("id");
                String description = rs.getString("milieueffect");
                String unit = rs.getString("eenheid");
                Double weight = 1.0;
                map.put(id, new NmdMilieuCategorie(description, unit, weight));
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        return map;
    }
}

