/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.services;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import nl.tno.bim.nmd.config.NmdConfig;
import nl.tno.bim.nmd.domain.NlsfbCode;
import nl.tno.bim.nmd.domain.NmdElement;
import nl.tno.bim.nmd.domain.NmdElementImpl;
import nl.tno.bim.nmd.domain.NmdFaseProfiel;
import nl.tno.bim.nmd.domain.NmdFaseProfielImpl;
import nl.tno.bim.nmd.domain.NmdMilieuCategorie;
import nl.tno.bim.nmd.domain.NmdProductCard;
import nl.tno.bim.nmd.domain.NmdProductCardImpl;
import nl.tno.bim.nmd.domain.NmdProfileSet;
import nl.tno.bim.nmd.domain.NmdProfileSetImpl;
import nl.tno.bim.nmd.domain.NmdReferenceResources;
import nl.tno.bim.nmd.scaling.NmdScaler;
import nl.tno.bim.nmd.scaling.NmdScalerFactory;
import nl.tno.bim.nmd.services.AuthorizedRestDataService;
import nl.tno.bim.nmd.services.BaseNmdDataService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.bimserver.shared.reflector.KeyValuePair;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class Nmd3DataService
extends AuthorizedRestDataService
implements BaseNmdDataService {
    private static final DateFormat dbDateFormat = new SimpleDateFormat("yyyyMMdd");
    private String apiPath;
    private Calendar requestDate;
    private NmdConfig config = null;
    private boolean isConnected = false;
    private NmdReferenceResources resources;
    NmdScalerFactory scalerFactor = new NmdScalerFactory();
    private List<NmdElement> data;

    public Nmd3DataService(NmdConfig config) {
        this.setPort(Integer.valueOf(-1));
        this.setHost("www.Milieudatabase-datainvoer.nl");
        this.setScheme("https");
        this.apiPath = "/NMD_30_API_v0.2/api/NMD30_Web_API/";
        this.config = config;
        this.requestDate = Calendar.getInstance();
        this.data = new ArrayList();
    }

    public Nmd3DataService() {
        this.requestDate = Calendar.getInstance();
        this.data = new ArrayList();
    }

    public Calendar getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Calendar newDate) {
        this.requestDate = newDate;
    }

    public Boolean getIsConnected() {
        return this.isConnected;
    }

    public List<NmdElement> getData() {
        return this.data;
    }

    public void login() {
        HttpPost httppost = new HttpPost("https://www.milieudatabase-datainvoer.nl/NMD_30_AuthenticationServer/NMD_30_API_Authentication/getToken");
        httppost.addHeader("refreshToken", this.config.getToken());
        httppost.addHeader("API_ID", "1");
        httppost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        HttpResponse response = null;
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            response = this.httpClient.execute((HttpUriRequest)httppost);
            JsonNode responseNode = this.responseToJson(response);
            JsonNode tokenNode = responseNode.get("TOKEN");
            this.setToken(tokenNode.asText());
            this.isConnected = true;
            httppost.releaseConnection();
        }
        catch (IOException e1) {
            this.isConnected = false;
            System.out.println("authentication failed: " + response.getStatusLine().toString());
        }
        this.loadResources();
    }

    public void preLoadData() {
        this.data = this.getAllElements();
    }

    public void logout() {
        this.setToken("");
        this.isConnected = false;
        this.resources = null;
    }

    private void loadResources() {
        if (this.resources == null) {
            this.resources = this.loadReferenceResources();
        }
    }

    public NmdReferenceResources getResources() {
        this.loadResources();
        return this.resources;
    }

    public NmdReferenceResources loadReferenceResources() {
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        params.add(new KeyValuePair("ZoekDatum", (Object)dbDateFormat.format(this.getRequestDate().getTime())));
        this.resources = new NmdReferenceResources();
        try {
            this.loadLifeCycleFasen(params);
            this.loadMilieuCategorien(params);
            this.loadUnitDefinitions(params);
            this.loadCUASCodes(params);
            this.loadScalingTypes(params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resources;
    }

    private void loadScalingTypes(List<KeyValuePair> params) {
        HttpResponse scalingResponse = this.performGetRequestWithParams(this.apiPath + "SchalingsFormules", params);
        JsonNode scaling_node = this.responseToJson(scalingResponse).get("results");
        HashMap scalingFormula = new HashMap();
        scaling_node.forEach(scaling_formula -> scalingFormula.putIfAbsent(this.TryParseJsonNode(scaling_formula.get("SchalingsFormuleID"), Integer.valueOf(-1)), this.TryParseJsonNode(scaling_formula.get("SoortFormule"), "") + " : " + this.TryParseJsonNode(scaling_formula.get("Formule"), "")));
        this.resources.setScalingFormula(scalingFormula);
    }

    private void loadCUASCodes(List<KeyValuePair> params) {
        HttpResponse cuasResponse = this.performGetRequestWithParams(this.apiPath + "CUAScategorien", params);
        JsonNode cuas_node = this.responseToJson(cuasResponse).get("results");
        HashMap cuasCategorien = new HashMap();
        cuas_node.forEach(cuas_code -> cuasCategorien.putIfAbsent(this.TryParseJsonNode(cuas_code.get("ID"), Integer.valueOf(-1)), this.TryParseJsonNode(cuas_code.get("CUAS_code"), "")));
        this.resources.setCuasCategorieMapping(cuasCategorien);
    }

    private void loadUnitDefinitions(List<KeyValuePair> params) {
        HttpResponse eenheidResponse = this.performGetRequestWithParams(this.apiPath + "Eenheden", params);
        JsonNode eenheid_node = this.responseToJson(eenheidResponse).get("results");
        HashMap eenheden = new HashMap();
        eenheid_node.forEach(eenheid -> eenheden.putIfAbsent(this.TryParseJsonNode(eenheid.get("EenheidID"), Integer.valueOf(-1)), this.TryParseJsonNode(eenheid.get("Code"), "")));
        this.resources.setUnitMapping(eenheden);
    }

    private void loadMilieuCategorien(List<KeyValuePair> params) {
        HttpResponse categorieResponse = this.performGetRequestWithParams(this.apiPath + "MilieuCategorien", params);
        JsonNode categorie_node = this.responseToJson(categorieResponse).get("results");
        HashMap categorien = new HashMap();
        categorie_node.forEach(categorie -> {
            NmdMilieuCategorie factor = new NmdMilieuCategorie(categorie.get("Milieueffect").asText(), categorie.get("Eenheid").asText(), Double.valueOf(categorie.get("Wegingsfactor") != null ? categorie.get("Wegingsfactor").asDouble() : 0.0));
            categorien.putIfAbsent(Integer.parseInt(categorie.get("MilieuCategorieID").asText()), factor);
        });
        this.resources.setMilieuCategorieMapping(categorien);
    }

    private void loadLifeCycleFasen(List<KeyValuePair> params) {
        HttpResponse faseResponse = this.performGetRequestWithParams(this.apiPath + "Fasen", params);
        JsonNode fasen_node = this.responseToJson(faseResponse).get("results");
        HashMap fasen = new HashMap();
        fasen_node.forEach(fase -> fasen.putIfAbsent(Integer.parseInt(fase.get("FaseID").asText()), fase.get("FaseNaam").asText()));
        this.resources.setFaseMapping(fasen);
    }

    public List<NmdElement> getAllElements() {
        if (!this.isConnected) {
            this.login();
        }
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        params.add(new KeyValuePair("ZoekDatum", (Object)dbDateFormat.format(this.getRequestDate().getTime())));
        HttpResponse response = this.performGetRequestWithParams(this.apiPath + "NLsfB_RAW_Elementen", params);
        JsonNode respNode = this.responseToJson(response);
        ArrayList<NmdElement> results = new ArrayList<NmdElement>();
        respNode.get("results").forEach(f -> results.add(this.getElementDataFromJson(f)));
        List ids = results.stream().map(e -> e.getElementId()).collect(Collectors.toList());
        results.addAll(this.getChildElements(ids));
        for (NmdElement el : results) {
            el.addProductCards(this.getProductsForElement(el));
        }
        return results;
    }

    private List<NmdElement> getChildElements(List<Integer> parentIds) {
        ArrayList<NmdElement> results = new ArrayList<NmdElement>();
        parentIds.forEach(id -> {
            ArrayList<KeyValuePair> params_el = new ArrayList<KeyValuePair>();
            params_el.add(new KeyValuePair("ZoekDatum", (Object)dbDateFormat.format(this.getRequestDate().getTime())));
            params_el.add(new KeyValuePair("ElementID", id));
            HttpResponse responseEl = this.performGetRequestWithParams(this.apiPath + "ElementOnderdelen", params_el);
            JsonNode respNodeEl = this.responseToJson(responseEl);
            if (respNodeEl != null) {
                ArrayList newResults = new ArrayList();
                respNodeEl.get("results").forEach(f -> newResults.add(this.getElementDataFromJson(f)));
                results.addAll(newResults);
                List newResultIds = newResults.stream().map(r -> r.getElementId()).collect(Collectors.toList());
                results.addAll(this.getChildElements(newResultIds));
            }
        });
        return results;
    }

    public List<NmdProductCard> getProductsForElement(NmdElement element) {
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        params.add(new KeyValuePair("ZoekDatum", (Object)dbDateFormat.format(this.getRequestDate().getTime())));
        params.add(new KeyValuePair("ElementID", (Object)element.getElementId()));
        HttpResponse response = this.performGetRequestWithParams(this.apiPath + "ProductenBijElement", params);
        JsonNode resp_node = this.responseToJson(response);
        if (resp_node == null) {
            return new ArrayList<NmdProductCard>();
        }
        JsonNode producten = resp_node.get("results");
        ArrayList products = new ArrayList();
        if (producten != null) {
            producten.forEach(p -> {
                if (this.TryParseJsonNode(p.get("ProfielSetGekoppeld"), Boolean.valueOf(false)).booleanValue()) {
                    products.add(this.getProductCardDataFromJson(p));
                }
            });
        }
        products.forEach(p -> p.setNlsfbCode(element.getNlsfbCode()));
        return products.stream().map(p -> p).collect(Collectors.toList());
    }

    public HashMap<Integer, Double> getQuantitiesOfProfileSetsForProduct(Integer productId) {
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        params.add(new KeyValuePair("ZoekDatum", (Object)dbDateFormat.format(this.getRequestDate().getTime())));
        params.add(new KeyValuePair("ProductID", (Object)productId.toString()));
        params.add(new KeyValuePair("includeNULLs", (Object)true));
        HttpResponse response = this.performGetRequestWithParams(this.apiPath + "ProfielsetsEnSchalingBijProduct", params);
        HashMap<Integer, Double> res = new HashMap<Integer, Double>();
        JsonNode resp_node = this.responseToJson(response);
        JsonNode psNodes = resp_node.get("results");
        if (psNodes != null) {
            psNodes.forEach(ps -> {
                Integer id = ps.get("ProfielSetID").asInt(-1);
                Double q = ps.get("Hoeveelheid").asDouble(1.0);
                q = q > 0.0 ? q : 1.0;
                res.put(id, q);
            });
        }
        return res;
    }

    public Boolean getAdditionalProfileDataForCard(NmdProductCard c) {
        if (c.getProfileSets().size() > 0) {
            return true;
        }
        try {
            HashMap setData = this.getProfileSetsByIds(Arrays.asList(c.getProductId()));
            c.addProfileSets(setData.values());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public HashMap<Integer, NmdProfileSet> getProfileSetsByIds(List<Integer> ids) {
        String idsString = String.join((CharSequence)",", ids.stream().map(id -> id.toString()).collect(Collectors.toList()));
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        params.add(new KeyValuePair("ZoekDatum", (Object)dbDateFormat.format(this.getRequestDate().getTime())));
        params.add(new KeyValuePair("ProductIDs", (Object)idsString));
        params.add(new KeyValuePair("includeNULLs", (Object)true));
        HttpResponse response = this.performGetRequestWithParams(this.apiPath + "ProductenProfielWaarden", params);
        JsonNode resp_node = this.responseToJson(response);
        HashMap<Integer, NmdProfileSet> profileSets = new HashMap<Integer, NmdProfileSet>();
        if (resp_node.get("results") != null) {
            JsonNode profielSetNodes = resp_node.get("results").get(0).get("ProfielSet");
            profielSetNodes.forEach(profielSetNode -> {
                Integer profielSetId = this.TryParseJsonNode(profielSetNode.get("ProfielSetID"), Integer.valueOf(-1));
                NmdProfileSetImpl set = this.getDetailedProfielSetData(profielSetNode);
                profileSets.put(profielSetId, (NmdProfileSet)set);
            });
        }
        return profileSets;
    }

    private void loadFaseProfielDataForSet(JsonNode profielSetNode, NmdProfileSetImpl set) {
        JsonNode profielen = profielSetNode.get("Profiel");
        if (profielen != null) {
            profielen.forEach(p -> {
                Integer fase = this.TryParseJsonNode(p.get("FaseID"), Integer.valueOf(-1));
                String faseName = (String)this.getResources().getFaseMapping().get(fase);
                NmdFaseProfielImpl profiel = new NmdFaseProfielImpl(faseName, this.getResources());
                p.get("ProfielMilieuEffecten").forEach(val -> {
                    Integer catId = this.TryParseJsonNode(val.get("MilieuCategorieID"), Integer.valueOf(-1));
                    Double catVal = this.TryParseJsonNode(val.get("MilieuWaarde"), Double.valueOf(Double.NaN));
                    profiel.setProfielCoefficient(((NmdMilieuCategorie)this.getResources().getMilieuCategorieMapping().get(catId)).getDescription(), catVal.doubleValue());
                });
                set.addFaseProfiel(faseName, (NmdFaseProfiel)profiel);
            });
        }
    }

    private NmdProfileSetImpl getDetailedProfielSetData(JsonNode psNode) {
        NmdProfileSetImpl set = new NmdProfileSetImpl();
        set.setProfileLifetime(this.TryParseJsonNode(psNode.get("Levensduur"), Integer.valueOf(-1)));
        set.setUnit((String)this.getResources().getUnitMapping().get(this.TryParseJsonNode(psNode.get("ProfielSetEenheidID"), Integer.valueOf(-1))));
        set.setQuantity((double)this.TryParseJsonNode(psNode.get("Hoeveelheid"), Integer.valueOf(1)).intValue());
        set.setProfielId(this.TryParseJsonNode(psNode.get("ProfielSetID"), Integer.valueOf(-1)));
        set.setName(this.TryParseJsonNode(psNode.get("ProfielSetNaam"), ""));
        int scalerType = this.TryParseJsonNode(psNode.get("SchalingsFormuleID"), Integer.valueOf(-1));
        if (scalerType > 0) {
            set.setIsScalable(Boolean.valueOf(true));
            double scalerDim1 = this.TryParseJsonNode(psNode.get("SchalingsMaatX1"), Double.valueOf(Double.NaN));
            double scalerDim2 = this.TryParseJsonNode(psNode.get("SchalingsMaatX2"), Double.valueOf(Double.NaN));
            int scalerUnit = this.TryParseJsonNode(psNode.get("EenheidID_SchalingsMaat"), Integer.valueOf(-1));
            double scalerCoeffA = this.TryParseJsonNode(psNode.get("SchalingA"), Double.valueOf(Double.NaN));
            double scalerCoeffB = this.TryParseJsonNode(psNode.get("SchalingB"), Double.valueOf(Double.NaN));
            double scalerCoeffC = this.TryParseJsonNode(psNode.get("SchalingC"), Double.valueOf(Double.NaN));
            double scalerMinDim1 = this.TryParseJsonNode(psNode.get("MinX1"), Double.valueOf(Double.NaN));
            double scalerMinDim2 = this.TryParseJsonNode(psNode.get("MinX2"), Double.valueOf(Double.NaN));
            double scalerMaxDim1 = this.TryParseJsonNode(psNode.get("MaxX1"), Double.valueOf(Double.NaN));
            double scalerMaxDim2 = this.TryParseJsonNode(psNode.get("MaxX2"), Double.valueOf(Double.NaN));
            String scalerTypeName = (String)this.getResources().getScalingFormula().get(scalerType);
            String scalerUnitName = (String)this.getResources().getUnitMapping().get(scalerUnit);
            try {
                NmdScaler scaler = this.scalerFactor.create(scalerTypeName, scalerUnitName, new Double[]{scalerCoeffA, scalerCoeffB, scalerCoeffC}, new Double[]{scalerMinDim1, scalerMaxDim1, scalerMinDim2, scalerMaxDim2}, new Double[]{scalerDim1, scalerDim2});
                set.setScaler(scaler);
            }
            catch (InvalidInputException e) {
                System.out.println("encountered invalid input combinations in scaler creation");
            }
        } else {
            set.setIsScalable(Boolean.valueOf(false));
        }
        this.loadFaseProfielDataForSet(psNode, set);
        return set;
    }

    private NmdProductCardImpl getProductCardDataFromJson(JsonNode prodNode) {
        NmdProductCardImpl prod = new NmdProductCardImpl();
        prod.setLifetime(this.TryParseJsonNode(prodNode.get("Levensduur"), Integer.valueOf(-1)));
        prod.setUnit((String)this.getResources().getUnitMapping().get(this.TryParseJsonNode(prodNode.get("FunctioneleEenheidID"), Integer.valueOf(-1))));
        prod.setProductId(this.TryParseJsonNode(prodNode.get("ProductID"), Integer.valueOf(-1)));
        prod.setParentProductId(this.TryParseJsonNode(prodNode.get("OuderProductID"), Integer.valueOf(-1)));
        prod.setIsTotaalProduct(this.TryParseJsonNode(prodNode.get("IsElementDekkend"), Boolean.valueOf(false)).booleanValue());
        prod.setDescription(this.TryParseJsonNode(prodNode.get("ProductNaam"), ""));
        prod.setCategory(this.TryParseJsonNode(prodNode.get("CategorieID"), Integer.valueOf(3)));
        prod.setIsScalable(this.TryParseJsonNode(prodNode.get("IsSchaalbaar"), Boolean.valueOf(false)));
        return prod;
    }

    private NmdElement getElementDataFromJson(JsonNode elementInfo) {
        NmdElementImpl newElement = new NmdElementImpl();
        newElement.setElementId(this.TryParseJsonNode(elementInfo.get("ElementID"), Integer.valueOf(-1)));
        newElement.setNlsfbCode(new NlsfbCode(this.TryParseJsonNode(elementInfo.get("ElementCode"), "")));
        newElement.setElementName(this.TryParseJsonNode(elementInfo.get("ElementNaam"), ""));
        newElement.setParentId(this.TryParseJsonNode(elementInfo.get("OuderID"), Integer.valueOf(-1)));
        newElement.setIsMandatory(this.TryParseJsonNode(elementInfo.get("Verplicht"), Boolean.valueOf(false)));
        return newElement;
    }
}

