/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.bim.nmd.services;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class SqliteDataService {
    protected Connection connection;

    public abstract void login();

    public void logout() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            System.err.println("Error occured in disconnecting from mapping service: " + e.getMessage());
        }
    }

    public Boolean getIsConnected() {
        try {
            return this.connection == null ? false : !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    protected String createSqlInsertStatement(String table, String[] headers, List<String[]> values) {
        String valueString = StringUtils.join((Iterable)values.stream().map(ar -> "('" + StringUtils.join((Object[])ar, (String)"','") + "')").collect(Collectors.toList()), (String)",");
        return "INSERT INTO " + table + " (" + StringUtils.join((Object[])headers, (String)",") + ") VALUES " + valueString;
    }

    protected void deleteTable(String tableName) throws SQLException {
        this.executeAndCommitCommand("DROP TABLE IF EXISTS " + tableName);
    }

    protected void executeAndCommitCommand(String sqlCommand) throws SQLException {
        Statement statement = this.connection.createStatement();
        statement.setQueryTimeout(30);
        statement.executeUpdate(sqlCommand);
        statement.close();
    }
}

