package org.bimserver.database.actions;

/******************************************************************************
 * Copyright (C) 2009-2018  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.PluginBundleVersion;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class GetInstalledPluginBundle extends BimDatabaseAction<SPluginBundleVersion> {

	private Long oid;
	private BimServer bimServer;

	public GetInstalledPluginBundle(DatabaseSession databaseSession, AccessMethod accessMethod, BimServer bimServer, Long oid) {
		super(databaseSession, accessMethod);
		this.bimServer = bimServer;
		this.oid = oid;
	}

	@Override
	public SPluginBundleVersion execute() throws UserException, BimserverLockConflictException, BimserverDatabaseException, ServerException {
		return bimServer.getSConverter().convertToSObject((PluginBundleVersion)getDatabaseSession().get(oid, OldQuery.getDefault()));
	}
}