package org.bimserver.renderengine;

/******************************************************************************
 * Copyright (C) 2009-2018  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/

import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;

public class NoPoolingRenderEnginePool implements RenderEnginePool {

	private RenderEngineFactory renderEngineFactory;

	public NoPoolingRenderEnginePool(RenderEngineFactory renderEngineFactory) {
		this.renderEngineFactory = renderEngineFactory;
	}
	
	@Override
	public RenderEngine borrowObject() throws RenderEngineException {
		RenderEngine createRenderEngine = renderEngineFactory.createRenderEngine();
		createRenderEngine.init();
		return createRenderEngine;
	}

	@Override
	public void returnObject(RenderEngine renderEngine) throws RenderEngineException {
		renderEngine.close();
	}
}