/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.CommandLine;
import org.bimserver.EmbeddedWebServer;
import org.bimserver.JobScheduler;
import org.bimserver.JsonHandler;
import org.bimserver.MergerFactory;
import org.bimserver.MetricsRegistry;
import org.bimserver.ServerInfoManager;
import org.bimserver.ServerSettingsCache;
import org.bimserver.StateChangeListener;
import org.bimserver.WebModuleManager;
import org.bimserver.cache.CompareCache;
import org.bimserver.cache.DiskCacheManager;
import org.bimserver.cache.NewDiskCacheManager;
import org.bimserver.client.DirectBimServerClientFactory;
import org.bimserver.client.json.JsonSocketReflectorFactory;
import org.bimserver.client.protocolbuffers.ProtocolBuffersBimServerClientFactory;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.berkeley.BerkeleyKeyValueStore;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.database.migrations.InconsistentModelsException;
import org.bimserver.database.query.conditions.AttributeCondition;
import org.bimserver.database.query.literals.StringLiteral;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.endpoints.EndPointManager;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.interfaces.objects.SVersion;
import org.bimserver.longaction.LongActionManager;
import org.bimserver.mail.MailSystem;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.ServerStarted;
import org.bimserver.models.store.BooleanType;
import org.bimserver.models.store.DoubleType;
import org.bimserver.models.store.LongType;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.ObjectType;
import org.bimserver.models.store.Parameter;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PluginConfiguration;
import org.bimserver.models.store.PluginDescriptor;
import org.bimserver.models.store.ServerInfo;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.ServerState;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.models.store.WebModulePluginConfiguration;
import org.bimserver.notifications.InternalServicesManager;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.pb.server.ProtocolBuffersServer;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.NotificationsManagerInterface;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginChangeListener;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.renderengine.RenderEnginePools;
import org.bimserver.schemaconverter.Ifc2x3tc1ToIfc4SchemaConverterFactory;
import org.bimserver.schemaconverter.Ifc4ToIfc2x3tc1SchemaConverterFactory;
import org.bimserver.schemaconverter.SchemaConverterManager;
import org.bimserver.serializers.SerializerFactory;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.InterfaceList;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.reflector.FileBasedReflectorFactoryBuilder;
import org.bimserver.shared.reflector.ReflectorFactory;
import org.bimserver.templating.TemplateEngine;
import org.bimserver.utils.PathUtils;
import org.bimserver.utils.StringUtils;
import org.bimserver.version.VersionChecker;
import org.bimserver.webservices.LongTransactionManager;
import org.bimserver.webservices.PublicInterfaceFactory;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.LoggerFactory;

public class BimServer {
    private static final String ENCRYPTIONKEY = "encryptionkey";
    private org.slf4j.Logger LOGGER;
    private GregorianCalendar serverStartTime;
    private BimDatabase bimDatabase;
    private JobScheduler bimScheduler;
    private LongActionManager longActionManager;
    private SerializerFactory serializerFactory;
    private MergerFactory mergerFactory;
    private PluginManager pluginManager;
    private MailSystem mailSystem;
    private DiskCacheManager diskCacheManager;
    private NewDiskCacheManager newDiskCacheManager;
    private ServerInfoManager serverInfoManager;
    private PublicInterfaceFactory serviceFactory;
    private VersionChecker versionChecker;
    private TemplateEngine templateEngine;
    private NotificationsManager notificationsManager;
    private CompareCache compareCache;
    private ProtocolBuffersMetaData protocolBuffersMetaData;
    private SServicesMap servicesMap;
    private EmbeddedWebServer embeddedWebServer;
    private final BimServerConfig config;
    private ProtocolBuffersServer protocolBuffersServer;
    private JsonHandler jsonHandler;
    private CommandLine commandLine;
    private ServerSettingsCache serverSettingsCache;
    private ReflectorFactory reflectorFactory;
    private final EndPointManager endPointManager = new EndPointManager();
    private final SConverter sConverter = new SConverter();
    private final LongTransactionManager longTransactionManager = new LongTransactionManager();
    private JsonSocketReflectorFactory jsonSocketReflectorFactory;
    private SecretKeySpec encryptionkey;
    private BimServerClientFactory bimServerClientFactory;
    private Map<String, WebModulePlugin> webModules;
    private WebModulePlugin defaultWebModule;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private InternalServicesManager internalServicesManager;
    private MetaDataManager metaDataManager;
    private SchemaConverterManager schemaConverterManager = new SchemaConverterManager();
    private WebModuleManager webModuleManager;
    private MetricsRegistry metricsRegistry;
    private RenderEnginePools renderEnginePools;
    private MavenPluginRepository mavenPluginRepository;

    public BimServer(BimServerConfig config) {
        this.config = config;
        try {
            if (config.getHomeDir() != null) {
                this.initHomeDir();
            }
            this.fixLogging();
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (e instanceof OutOfMemoryError) {
                        BimServer.this.serverInfoManager.setOutOfMemory();
                        BimServer.this.LOGGER.error("", e);
                    } else if (e instanceof Error) {
                        BimServer.this.serverInfoManager.setErrorMessage(e.getMessage());
                        BimServer.this.LOGGER.error("", e);
                    } else {
                        BimServer.this.LOGGER.error("", e);
                    }
                }
            };
            Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.LOGGER = LoggerFactory.getLogger(BimServer.class);
            this.LOGGER.info("Starting BIMserver");
            if (config.getHomeDir() != null) {
                this.LOGGER.info("Using \"" + config.getHomeDir().toString() + "\" as homedir");
            } else {
                this.LOGGER.info("Not using a homedir");
            }
            this.servicesMap = InterfaceList.createSServicesMap();
            this.LOGGER.debug("SServiceMap Created");
            this.jsonSocketReflectorFactory = new JsonSocketReflectorFactory(this.servicesMap);
            this.LOGGER.debug("JsonSocketReflectorFactory created");
            this.serverInfoManager = new ServerInfoManager();
            this.LOGGER.debug("ServerInfoManager created");
            this.notificationsManager = new NotificationsManager(this, this.jsonSocketReflectorFactory);
            this.LOGGER.debug("NotificationsManager created");
            this.internalServicesManager = new InternalServicesManager(this, this.notificationsManager.getSiteAddress());
            this.LOGGER.debug("InternalServicesManager created");
            this.serviceFactory = new PublicInterfaceFactory(this);
            this.LOGGER.debug("PublicInterfaceFactory created");
            Path tmp = config.getHomeDir().resolve("tmp");
            if (!Files.exists(tmp, new LinkOption[0])) {
                Files.createDirectories(tmp, new FileAttribute[0]);
            }
            this.pluginManager = new PluginManager(tmp, config.getHomeDir().resolve("plugins"), config.getClassPath(), (ServiceFactory)this.serviceFactory, (NotificationsManagerInterface)this.internalServicesManager, this.servicesMap);
            this.metaDataManager = new MetaDataManager(tmp);
            this.pluginManager.setMetaDataManager(this.metaDataManager);
            this.LOGGER.debug("PluginManager created");
            this.versionChecker = new VersionChecker(config.getResourceFetcher());
            this.LOGGER.debug("Version Checker created");
            this.compareCache = new CompareCache();
            this.LOGGER.debug("Compare cache created");
            if (config.isStartEmbeddedWebServer()) {
                this.embeddedWebServer = new EmbeddedWebServer(this, config.isLocalDev());
                this.LOGGER.debug("Embedded webserver created");
            }
            this.LOGGER.debug("Done with initial setup");
        }
        catch (Throwable e) {
            if (this.LOGGER == null) {
                e.printStackTrace();
            } else {
                this.LOGGER.error("", e);
            }
            this.serverInfoManager.setErrorMessage(e.getMessage());
        }
    }

    public Map<String, WebModulePlugin> getWebModules() {
        return this.webModules;
    }

    public WebModulePlugin getDefaultWebModule() {
        return this.defaultWebModule;
    }

    public JsonSocketReflectorFactory getJsonSocketReflectorFactory() {
        return this.jsonSocketReflectorFactory;
    }

    public ReflectorFactory getReflectorFactory() {
        return this.reflectorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws DatabaseInitException, BimserverDatabaseException, PluginException, DatabaseRestartRequiredException, ServerException {
        try {
            this.LOGGER.debug("Starting BIMserver");
            SVersion localVersion = this.versionChecker.getLocalVersion();
            if (localVersion != null) {
                this.LOGGER.info("Version: " + localVersion.getFullString());
            } else {
                this.LOGGER.info("Unknown version");
            }
            try {
                this.pluginManager.addPluginChangeListener(new PluginChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pluginStateChanged(PluginContext pluginContext, boolean enabled) {
                        AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_PluginClassName(), new StringLiteral(pluginContext.getPlugin().getClass().getName()));
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Map<Long, PluginDescriptor> pluginsFound = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
                            if (pluginsFound.size() == 0) {
                                BimServer.this.LOGGER.error("Error changing plugin-state in database, plugin " + pluginContext.getPlugin().getClass().getName() + " not found");
                            } else if (pluginsFound.size() == 1) {
                                PluginDescriptor pluginConfiguration = pluginsFound.values().iterator().next();
                                pluginConfiguration.setEnabled(Boolean.valueOf(pluginContext.isEnabled()));
                                session.store((IdEObject)pluginConfiguration);
                            } else {
                                BimServer.this.LOGGER.error("Error, too many plugin-objects found in database for name " + pluginContext.getPlugin().getClass().getName());
                            }
                            session.commit();
                        }
                    }

                    public void pluginInstalled(PluginContext pluginContext, SPluginInformation sPluginInformation) throws BimserverDatabaseException {
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Plugin plugin = pluginContext.getPlugin();
                            PluginDescriptor pluginDescriptor = session.create(PluginDescriptor.class);
                            pluginDescriptor.setIdentifier(pluginContext.getIdentifier());
                            pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                            pluginDescriptor.setSimpleName(plugin.getClass().getSimpleName());
                            pluginDescriptor.setDescription(pluginContext.getDescription());
                            pluginDescriptor.setLocation(pluginContext.getLocation().toString());
                            pluginDescriptor.setPluginInterfaceClassName(BimServer.this.getPluginInterface(plugin.getClass()).getName());
                            pluginDescriptor.setEnabled(Boolean.valueOf(sPluginInformation.isEnabled()));
                            pluginDescriptor.setInstallForNewUsers(sPluginInformation.isInstallForNewUsers());
                            if (sPluginInformation.isInstallForAllUsers()) {
                                IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getUser(), OldQuery.getDefault());
                                for (User user : allOfType.getAll(User.class)) {
                                    if (user.getState() != ObjectState.ACTIVE) continue;
                                    BimServer.this.updateUserPlugin(session, user, pluginDescriptor, pluginContext);
                                }
                            }
                            try {
                                session.commit();
                            }
                            catch (ServiceException e) {
                                BimServer.this.LOGGER.error("", (Throwable)e);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pluginUninstalled(PluginContext pluginContext) {
                        AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), new StringLiteral(pluginContext.getIdentifier()));
                        try (DatabaseSession session = BimServer.this.bimDatabase.createSession();){
                            Map<Long, PluginDescriptor> pluginsFound = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
                            if (pluginsFound.size() == 0) {
                                BimServer.this.LOGGER.error("Error removing plugin-state in database, plugin " + pluginContext.getPlugin().getClass().getName() + " not found");
                            } else if (pluginsFound.size() == 1) {
                                PluginDescriptor pluginDescriptor = pluginsFound.values().iterator().next();
                                for (PluginConfiguration pluginConfiguration : pluginDescriptor.getConfigurations()) {
                                    pluginConfiguration.remove();
                                }
                                pluginDescriptor.remove();
                                session.store((IdEObject)pluginDescriptor);
                            } else {
                                BimServer.this.LOGGER.error("Error, too many plugin-objects found in database for name " + pluginContext.getPlugin().getClass().getName());
                            }
                            session.commit();
                        }
                    }
                });
            }
            catch (Exception e) {
                this.LOGGER.error("", (Throwable)e);
            }
            try {
                this.metaDataManager.init();
                this.pluginManager.initAllLoadedPlugins();
            }
            catch (PluginException e) {
                this.LOGGER.error("", (Throwable)e);
            }
            this.serverStartTime = new GregorianCalendar();
            this.longActionManager = new LongActionManager();
            LinkedHashSet<Object> packages = new LinkedHashSet<Object>();
            packages.add(Ifc2x3tc1Package.eINSTANCE);
            packages.add(Ifc4Package.eINSTANCE);
            this.templateEngine = new TemplateEngine();
            this.templateEngine.init(this.config.getResourceFetcher().getResource("emailtemplates/"));
            Path databaseDir = this.config.getHomeDir().resolve("database");
            BerkeleyKeyValueStore keyValueStore = new BerkeleyKeyValueStore(databaseDir);
            this.schemaConverterManager.registerConverter(new Ifc2x3tc1ToIfc4SchemaConverterFactory());
            this.schemaConverterManager.registerConverter(new Ifc4ToIfc2x3tc1SchemaConverterFactory());
            this.metricsRegistry = new MetricsRegistry();
            Path mavenPath = this.config.getHomeDir().resolve("maven");
            if (!Files.exists(mavenPath, new LinkOption[0])) {
                Files.createDirectories(mavenPath, new FileAttribute[0]);
            }
            this.mavenPluginRepository = new MavenPluginRepository(mavenPath, "https://repo1.maven.org/maven2");
            OldQuery.setPackageMetaDataForDefaultQuery(this.metaDataManager.getPackageMetaData("store"));
            this.bimDatabase = new Database(this, packages, keyValueStore, this.metaDataManager);
            try {
                this.bimDatabase.init();
            }
            catch (DatabaseRestartRequiredException e) {
                this.bimDatabase.close();
                keyValueStore = new BerkeleyKeyValueStore(databaseDir);
                this.bimDatabase = new Database(this, packages, keyValueStore, this.metaDataManager);
                try {
                    this.bimDatabase.init();
                }
                catch (InconsistentModelsException e1) {
                    this.LOGGER.error("", (Throwable)e);
                    this.serverInfoManager.setServerState(ServerState.FATAL_ERROR);
                    this.serverInfoManager.setErrorMessage("Inconsistent models");
                }
            }
            catch (InconsistentModelsException e) {
                this.LOGGER.error("", (Throwable)e);
                this.serverInfoManager.setServerState(ServerState.FATAL_ERROR);
                this.serverInfoManager.setErrorMessage("Inconsistent models");
            }
            try (DatabaseSession encsession = this.bimDatabase.createSession();){
                byte[] encryptionkeyBytes = null;
                if (!this.bimDatabase.getRegistry().has(ENCRYPTIONKEY, encsession)) {
                    encryptionkeyBytes = new byte[16];
                    new SecureRandom().nextBytes(encryptionkeyBytes);
                    this.bimDatabase.getRegistry().save(ENCRYPTIONKEY, encryptionkeyBytes, encsession);
                    encsession.commit();
                } else {
                    encryptionkeyBytes = this.bimDatabase.getRegistry().readByteArray(ENCRYPTIONKEY, encsession);
                }
                this.encryptionkey = new SecretKeySpec(encryptionkeyBytes, "AES");
            }
            this.protocolBuffersMetaData = new ProtocolBuffersMetaData();
            this.protocolBuffersMetaData.load(this.servicesMap, ProtocolBuffersBimServerClientFactory.class);
            this.serverInfoManager.init(this);
            this.webModuleManager = new WebModuleManager(this);
            this.jsonHandler = new JsonHandler(this);
            this.serializerFactory = new SerializerFactory();
            this.serverSettingsCache = new ServerSettingsCache(this.bimDatabase);
            this.serverInfoManager.update();
            this.renderEnginePools = new RenderEnginePools(this);
            if (this.serverInfoManager.getServerState() == ServerState.MIGRATION_REQUIRED) {
                this.serverInfoManager.registerStateChangeListener(new StateChangeListener(){

                    @Override
                    public void stateChanged(ServerState oldState, ServerState newState) {
                        if (oldState == ServerState.MIGRATION_REQUIRED && newState == ServerState.RUNNING) {
                            try {
                                BimServer.this.initDatabaseDependantItems();
                            }
                            catch (BimserverDatabaseException e) {
                                BimServer.this.LOGGER.error("", (Throwable)e);
                            }
                        }
                    }
                });
            } else {
                this.initDatabaseDependantItems();
            }
            this.mailSystem = new MailSystem(this);
            this.diskCacheManager = new DiskCacheManager(this, this.config.getHomeDir().resolve("cache"));
            this.newDiskCacheManager = new NewDiskCacheManager(this, this.config.getHomeDir().resolve("cache"));
            this.mergerFactory = new MergerFactory(this);
            FileBasedReflectorFactoryBuilder factoryBuilder = new FileBasedReflectorFactoryBuilder();
            this.reflectorFactory = factoryBuilder.newReflectorFactory();
            if (this.reflectorFactory == null) {
                throw new RuntimeException("No reflector factory!");
            }
            this.servicesMap.setReflectorFactory(this.reflectorFactory);
            this.bimScheduler = new JobScheduler(this);
            this.bimScheduler.start();
            if (this.config.isStartEmbeddedWebServer()) {
                this.embeddedWebServer.start();
            }
            if (this.config.isStartCommandLine()) {
                this.commandLine = new CommandLine(this);
                this.commandLine.start();
            }
        }
        catch (Throwable e) {
            this.LOGGER.error("", e);
            this.serverInfoManager.setErrorMessage(e.getMessage());
        }
    }

    public MavenPluginRepository getMavenPluginRepository() {
        return this.mavenPluginRepository;
    }

    public SecretKeySpec getEncryptionKey() {
        return this.encryptionkey;
    }

    private void createDatabaseObjects(DatabaseSession session) throws BimserverLockConflictException, BimserverDatabaseException, PluginException, BimserverConcurrentModificationDatabaseException {
        IfcModelInterface allOfType = session.getAllOfType(StorePackage.eINSTANCE.getUser(), OldQuery.getDefault());
        for (User user : allOfType.getAll(User.class)) {
            this.updateUserSettings(session, user);
        }
    }

    public NewDiskCacheManager getNewDiskCacheManager() {
        return this.newDiskCacheManager;
    }

    private <T extends PluginConfiguration> T find(List<T> list, String identifier) {
        for (PluginConfiguration t : list) {
            if (t.getPluginDescriptor() == null || !t.getPluginDescriptor().getIdentifier().equals(identifier)) continue;
            return (T)t;
        }
        return null;
    }

    private void genericPluginConversion(PluginContext pluginContext, DatabaseSession session, PluginConfiguration pluginConfiguration, PluginDescriptor pluginDescriptor) throws BimserverDatabaseException {
        try {
            Plugin plugin = pluginContext.getPlugin();
            pluginConfiguration.setName(plugin.getDefaultName());
            pluginConfiguration.setPluginDescriptor(pluginDescriptor);
            pluginConfiguration.setDescription(pluginContext.getDescription());
            pluginConfiguration.setEnabled(Boolean.valueOf(true));
            pluginConfiguration.setSettings(this.convertSettings(session, plugin));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private PluginDescriptor getPluginDescriptor(DatabaseSession session, String identifier) throws BimserverDatabaseException {
        return (PluginDescriptor)session.querySingle(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), identifier);
    }

    public Class<?> getPluginInterface(Class<?> plugin) {
        for (Class<?> inter : plugin.getInterfaces()) {
            if (inter == Plugin.class) {
                return plugin;
            }
            for (Class<?> inter2 : inter.getInterfaces()) {
                if (inter2 != Plugin.class) continue;
                return inter;
            }
        }
        if (plugin.getSuperclass() != null) {
            return this.getPluginInterface(plugin.getSuperclass());
        }
        return null;
    }

    public void updateUserPlugin(DatabaseSession session, User user, PluginDescriptor pluginDescriptor, PluginContext pluginContext) throws BimserverDatabaseException {
        if (pluginDescriptor.isInstallForNewUsers()) {
            String listRefName;
            Class<?> pluginInterface;
            String pluginInterfaceName;
            UserSettings userSettings = user.getUserSettings();
            if (userSettings == null) {
                userSettings = session.create(UserSettings.class);
                user.setUserSettings(userSettings);
                session.store((IdEObject)user);
            }
            if ((pluginInterfaceName = (pluginInterface = this.getPluginInterface(pluginContext.getPlugin().getClass())).getSimpleName()).endsWith("Plugin")) {
                pluginInterfaceName = pluginInterfaceName.substring(0, pluginInterfaceName.length() - 6);
            }
            if (pluginInterfaceName.equals("MessagingStreamingSerializer") || pluginInterfaceName.equals("MessagingSerializer") || pluginInterfaceName.equals("StreamingSerializer")) {
                pluginInterfaceName = "Serializer";
            }
            if (pluginInterfaceName.equals("StreamingDeserializer")) {
                pluginInterfaceName = "Deserializer";
            }
            if (pluginInterfaceName.equals("ModelChecker") || pluginInterfaceName.equals("WebModule")) {
                return;
            }
            EClass userSettingsClass = StorePackage.eINSTANCE.getUserSettings();
            EReference listReference = (EReference)userSettingsClass.getEStructuralFeature(listRefName = StringUtils.firstLowerCase((String)pluginInterfaceName) + "s");
            if (listReference == null) {
                this.LOGGER.warn(listRefName + " not found");
                return;
            }
            EReference defaultReference = (EReference)userSettingsClass.getEStructuralFeature("default" + pluginInterfaceName);
            EClass pluginConfigurationClass = (EClass)listReference.getEType();
            List list = (List)userSettings.eGet((EStructuralFeature)listReference);
            Object pluginConfiguration = this.find(list, pluginContext.getIdentifier());
            if (pluginConfiguration == null) {
                pluginConfiguration = (PluginConfiguration)session.create(pluginConfigurationClass);
                list.add(pluginConfiguration);
                this.genericPluginConversion(pluginContext, session, (PluginConfiguration)pluginConfiguration, pluginDescriptor);
            }
            if (defaultReference != null && userSettings.eGet((EStructuralFeature)defaultReference) == null && !list.isEmpty()) {
                userSettings.eSet((EStructuralFeature)defaultReference, list.get(0));
            }
            session.store((IdEObject)userSettings);
        }
    }

    public void updateUserSettings(DatabaseSession session, User user) throws BimserverLockConflictException, BimserverDatabaseException {
        UserSettings userSettings = user.getUserSettings();
        if (userSettings == null) {
            userSettings = session.create(UserSettings.class);
            user.setUserSettings(userSettings);
            session.store((IdEObject)user);
        }
        for (Map.Entry pluginEntry : this.pluginManager.getAllPlugins(true).entrySet()) {
            if (pluginEntry.getValue() instanceof WebModulePlugin || pluginEntry.getValue() instanceof ModelCheckerPlugin) continue;
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(session, ((PluginContext)pluginEntry.getKey()).getIdentifier());
            if (pluginDescriptor == null) {
                throw new BimserverDatabaseException("No plugin descriptor found: " + ((PluginContext)pluginEntry.getKey()).getIdentifier());
            }
            this.updateUserPlugin(session, user, pluginDescriptor, (PluginContext)pluginEntry.getKey());
        }
        session.store((IdEObject)userSettings);
    }

    public RenderEnginePools getRenderEnginePools() {
        return this.renderEnginePools;
    }

    private ObjectType convertSettings(DatabaseSession session, Plugin plugin) throws BimserverDatabaseException {
        ObjectType settings = session.create(ObjectType.class);
        ObjectDefinition settingsDefinition = plugin.getSettingsDefinition();
        if (plugin.getSettingsDefinition() != null) {
            for (ParameterDefinition parameterDefinition : settingsDefinition.getParameters()) {
                Parameter parameter = session.create(Parameter.class);
                parameter.setName(parameterDefinition.getName());
                if (parameterDefinition.getDefaultValue() != null) {
                    Type value = this.cloneAndAdd(session, parameterDefinition.getDefaultValue());
                    parameter.setValue(value);
                }
                settings.getParameters().add((Object)parameter);
            }
        }
        return settings;
    }

    private Type cloneAndAdd(DatabaseSession session, Type input) throws BimserverDatabaseException {
        if (input instanceof BooleanType) {
            BooleanType booleanType = session.create(BooleanType.class);
            booleanType.setValue(((BooleanType)input).isValue());
            session.store((IdEObject)booleanType);
            return booleanType;
        }
        if (input instanceof StringType) {
            StringType stringType = session.create(StringType.class);
            stringType.setValue(((StringType)input).getValue());
            session.store((IdEObject)stringType);
            return stringType;
        }
        if (input instanceof DoubleType) {
            DoubleType doubleType = session.create(DoubleType.class);
            doubleType.setValue(((DoubleType)input).getValue());
            session.store((IdEObject)doubleType);
            return doubleType;
        }
        if (input instanceof LongType) {
            LongType longType = session.create(LongType.class);
            longType.setValue(((LongType)input).getValue());
            session.store((IdEObject)longType);
            return longType;
        }
        return null;
    }

    private WebModulePluginConfiguration findWebModule(ServerSettings serverSettings, String identifier) {
        for (Map.Entry entry : this.pluginManager.getAllWebPlugins(true).entrySet()) {
            WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)this.find((List)serverSettings.getWebModules(), identifier);
            if (!((PluginContext)entry.getKey()).getIdentifier().equals(identifier)) continue;
            return webPluginConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabaseDependantItems() throws BimserverDatabaseException {
        this.serverSettingsCache.init();
        this.notificationsManager.init();
        this.getSerializerFactory().init(this.pluginManager, this.bimDatabase, this);
        try {
            try (DatabaseSession session = this.bimDatabase.createSession();){
                this.updatePlugins(session);
                session.commit();
            }
            session = this.bimDatabase.createSession();
            this.createDatabaseObjects(session);
            ServerSettings serverSettings = this.serverSettingsCache.getServerSettings();
            for (Map.Entry entry : this.pluginManager.getAllWebPlugins(true).entrySet()) {
                WebModulePluginConfiguration webPluginConfiguration = (WebModulePluginConfiguration)this.find((List)serverSettings.getWebModules(), ((PluginContext)entry.getKey()).getIdentifier());
                if (webPluginConfiguration == null) {
                    webPluginConfiguration = session.create(WebModulePluginConfiguration.class);
                    serverSettings.getWebModules().add((Object)webPluginConfiguration);
                    PluginDescriptor pluginDescriptor = this.getPluginDescriptor(session, ((PluginContext)entry.getKey()).getIdentifier());
                    if (pluginDescriptor == null) {
                        throw new BimserverDatabaseException("No plugin descriptor found: " + ((PluginContext)entry.getKey()).getIdentifier());
                    }
                    this.genericPluginConversion((PluginContext)entry.getKey(), session, (PluginConfiguration)webPluginConfiguration, pluginDescriptor);
                    continue;
                }
                if (webPluginConfiguration != serverSettings.getWebModule()) continue;
                this.setDefaultWebModule((WebModulePlugin)entry.getValue());
            }
            session.store((IdEObject)serverSettings);
            AttributeCondition condition = new AttributeCondition(StorePackage.eINSTANCE.getUser_Username(), new StringLiteral("system"));
            User systemUser = session.querySingle(condition, User.class, OldQuery.getDefault());
            ServerStarted serverStarted = session.create(ServerStarted.class);
            serverStarted.setDate(new Date());
            serverStarted.setAccessMethod(AccessMethod.INTERNAL);
            serverStarted.setExecutor(systemUser);
            try {
                session.store((IdEObject)serverStarted);
                session.commit();
            }
            catch (BimserverLockConflictException e) {
                throw new BimserverDatabaseException((Throwable)((Object)e));
            }
            catch (ServiceException e) {
                throw new BimserverDatabaseException((Throwable)e);
            }
            finally {
                session.close();
            }
            this.webModules = new HashMap<String, WebModulePlugin>();
            try (DatabaseSession ses = this.bimDatabase.createSession();){
                EList webModuleConfigurations = this.serverSettingsCache.getServerSettings().getWebModules();
                for (WebModulePluginConfiguration webModulePluginConfiguration : webModuleConfigurations) {
                    String contextPath = "";
                    for (Parameter parameter : webModulePluginConfiguration.getSettings().getParameters()) {
                        if (!parameter.getName().equals("contextPath")) continue;
                        contextPath = ((StringType)parameter.getValue()).getValue();
                    }
                    String identifier = webModulePluginConfiguration.getPluginDescriptor().getIdentifier();
                    this.webModules.put(contextPath, (WebModulePlugin)this.pluginManager.getPlugin(identifier, true));
                }
            }
            Integer protocolBuffersPort = this.getServerSettingsCache().getServerSettings().getProtocolBuffersPort();
            if (protocolBuffersPort >= 1 && protocolBuffersPort <= 65535) {
                try {
                    this.protocolBuffersServer = new ProtocolBuffersServer(this.protocolBuffersMetaData, this.serviceFactory, this.servicesMap, protocolBuffersPort);
                    this.protocolBuffersServer.start();
                }
                catch (Exception e) {
                    this.LOGGER.error("", (Throwable)e);
                }
            }
            this.bimServerClientFactory = new DirectBimServerClientFactory(this.serverSettingsCache.getServerSettings().getSiteAddress(), (ServiceFactory)this.serviceFactory, this.servicesMap, this.pluginManager, this.metaDataManager);
            this.pluginManager.setBimServerClientFactory(this.bimServerClientFactory);
        }
        catch (BimserverLockConflictException e) {
            throw new BimserverDatabaseException((Throwable)((Object)e));
        }
        catch (PluginException e) {
            throw new BimserverDatabaseException((Throwable)e);
        }
    }

    public WebModuleManager getWebModuleManager() {
        return this.webModuleManager;
    }

    private void updatePlugins(DatabaseSession session) throws BimserverDatabaseException {
        Map allPlugins = this.pluginManager.getAllPlugins(false);
        for (PluginContext pluginContext : allPlugins.keySet()) {
            PluginDescriptor pluginDescriptor;
            Plugin plugin = pluginContext.getPlugin();
            System.out.println(pluginContext.getIdentifier());
            AttributeCondition pluginCondition = new AttributeCondition(StorePackage.eINSTANCE.getPluginDescriptor_Identifier(), new StringLiteral(pluginContext.getIdentifier()));
            Map<Long, PluginDescriptor> results = session.query(pluginCondition, PluginDescriptor.class, OldQuery.getDefault());
            if (results.size() == 0) {
                pluginDescriptor = session.create(PluginDescriptor.class);
                pluginDescriptor.setIdentifier(pluginContext.getIdentifier());
                pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                pluginDescriptor.setSimpleName(plugin.getClass().getSimpleName());
                pluginDescriptor.setDescription(pluginContext.getDescription() + " " + pluginContext.getVersion());
                pluginDescriptor.setLocation(pluginContext.getLocation().toString());
                pluginDescriptor.setPluginInterfaceClassName(this.getPluginInterface(plugin.getClass()).getName());
                pluginDescriptor.setEnabled(Boolean.valueOf(true));
                continue;
            }
            if (results.size() == 1) {
                pluginDescriptor = results.values().iterator().next();
                pluginDescriptor.setIdentifier(pluginContext.getIdentifier());
                pluginDescriptor.setPluginClassName(plugin.getClass().getName());
                pluginDescriptor.setSimpleName(plugin.getClass().getSimpleName());
                pluginDescriptor.setDescription(pluginContext.getDescription() + " " + pluginContext.getVersion());
                pluginDescriptor.setLocation(pluginContext.getLocation().toString());
                pluginDescriptor.setPluginInterfaceClassName(this.getPluginInterface(plugin.getClass()).getName());
                session.store((IdEObject)pluginDescriptor);
                this.pluginManager.getPluginContext(plugin).setEnabled(pluginDescriptor.getEnabled().booleanValue(), false);
                continue;
            }
            this.LOGGER.error("Multiple plugin descriptor objects found with the same name: " + plugin.getClass().getName());
        }
    }

    public Path getHomeDir() {
        return this.config.getHomeDir();
    }

    public LongActionManager getLongActionManager() {
        return this.longActionManager;
    }

    public void setDefaultWebModule(WebModulePlugin defaultWebModule) {
        this.defaultWebModule = defaultWebModule;
    }

    private void fixLogging() throws IOException {
        Path logFolder = this.config.getHomeDir().resolve("logs");
        if (!Files.isDirectory(logFolder, new LinkOption[0])) {
            Files.createDirectories(logFolder, new FileAttribute[0]);
        }
        Path file = logFolder.resolve("bimserver.log");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        String filename = file.toAbsolutePath().toString();
        System.out.println("Logging to " + filename);
        fileAppender.setFile(filename);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        for (Logger log : lc.getLoggerList()) {
            if (log.getLevel() == null) continue;
            log.addAppender((Appender)fileAppender);
        }
    }

    private void initHomeDir() throws IOException {
        String[] filesToCheck = new String[]{"logs", "tmp", "logback.xml", "emailtemplates"};
        if (!Files.exists(this.config.getHomeDir(), new LinkOption[0])) {
            Files.createDirectories(this.config.getHomeDir(), new FileAttribute[0]);
        }
        if (Files.exists(this.config.getHomeDir(), new LinkOption[0]) && Files.isDirectory(this.config.getHomeDir(), new LinkOption[0])) {
            for (String fileToCheck : filesToCheck) {
                Path destFile;
                Path sourceFile = this.config.getResourceFetcher().getFile(fileToCheck);
                if (sourceFile == null || !Files.exists(sourceFile, new LinkOption[0]) || Files.exists(destFile = this.config.getHomeDir().resolve(fileToCheck), new LinkOption[0])) continue;
                if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                    Files.createDirectories(destFile, new FileAttribute[0]);
                    for (Path f : PathUtils.list((Path)sourceFile)) {
                        if (Files.isDirectory(f, new LinkOption[0])) {
                            Path destDir2 = destFile.resolve(f.getFileName().toString());
                            for (Path x : PathUtils.list((Path)f)) {
                                FileUtils.copyFile((File)x.toFile(), (File)destDir2.resolve(x.getFileName().toString()).toFile());
                            }
                            continue;
                        }
                        FileUtils.copyFile((File)f.toFile(), (File)destFile.resolve(f.getFileName().toString()).toFile());
                    }
                    continue;
                }
                FileUtils.copyFile((File)sourceFile.toFile(), (File)destFile.toFile());
            }
        }
    }

    public BimDatabase getDatabase() {
        return this.bimDatabase;
    }

    public ResourceFetcher getResourceFetcher() {
        return this.config.getResourceFetcher();
    }

    public GregorianCalendar getServerStartTime() {
        return this.serverStartTime;
    }

    public MergerFactory getMergerFactory() {
        return this.mergerFactory;
    }

    public void stop() {
        this.LOGGER.info("Stopping BIMserver");
        this.executorService.shutdown();
        if (this.bimDatabase != null) {
            this.bimDatabase.close();
        }
        if (this.bimScheduler != null) {
            this.bimScheduler.close();
        }
        if (this.longActionManager != null) {
            this.longActionManager.shutdown();
        }
        if (this.notificationsManager != null) {
            this.notificationsManager.shutdown();
        }
        if (this.embeddedWebServer != null) {
            this.embeddedWebServer.shutdown();
        }
        if (this.protocolBuffersServer != null) {
            this.protocolBuffersServer.shutdown();
        }
        if (this.commandLine != null) {
            this.commandLine.shutdown();
        }
        this.LOGGER.info("BIMserver stopped");
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public MailSystem getMailSystem() {
        return this.mailSystem;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public DiskCacheManager getDiskCacheManager() {
        return this.diskCacheManager;
    }

    public String getClassPath() {
        return this.config.getClassPath();
    }

    public ServerInfo getServerInfo() {
        return this.serverInfoManager.getServerInfo();
    }

    public BimServerClientFactory getBimServerClientFactory() {
        return this.bimServerClientFactory;
    }

    public PublicInterfaceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public CompareCache getCompareCache() {
        return this.compareCache;
    }

    public NotificationsManager getNotificationsManager() {
        return this.notificationsManager;
    }

    public InternalServicesManager getInternalServicesManager() {
        return this.internalServicesManager;
    }

    public ServerInfoManager getServerInfoManager() {
        return this.serverInfoManager;
    }

    public ProtocolBuffersMetaData getProtocolBuffersMetaData() {
        return this.protocolBuffersMetaData;
    }

    public BimServerConfig getConfig() {
        return this.config;
    }

    public EmbeddedWebServer getEmbeddedWebServer() {
        return this.embeddedWebServer;
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public SConverter getSConverter() {
        return this.sConverter;
    }

    public EndPointManager getEndPointManager() {
        return this.endPointManager;
    }

    public ServerSettingsCache getServerSettingsCache() {
        return this.serverSettingsCache;
    }

    public <T extends PublicInterface> T getService(Class<T> clazz) {
        return this.getServiceFactory().get(new SystemAuthorization(this.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS), AccessMethod.INTERNAL).get(clazz);
    }

    public LongTransactionManager getLongTransactionManager() {
        return this.longTransactionManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public SchemaConverterManager getSchemaConverterManager() {
        return this.schemaConverterManager;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }
}

