/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.client.json.JsonBimServerClientFactory;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SRevision;
import org.bimserver.interfaces.objects.SUser;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.GeoTag;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.User;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.UsernamePasswordAuthenticationInfo;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.Formatters;
import org.bimserver.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BimServerImporter {
    private String address;
    private String username;
    private String password;
    private BimServer bimServer;
    private BimServerClientInterface remoteClient;
    Map<Long, User> users = new HashMap<Long, User>();
    Map<Long, Project> projects = new HashMap<Long, Project>();
    private static final Logger LOGGER = LoggerFactory.getLogger(BimServerImporter.class);
    private String path;

    public BimServerImporter(BimServer bimServer, String address, String username, String password, String path) {
        this.bimServer = bimServer;
        this.address = address;
        this.username = username;
        this.password = password;
        this.path = path;
    }

    public User createUser(DatabaseSession databaseSession, long remoteUoid) throws BimserverDatabaseException, ServerException, UserException, PublicInterfaceNotFoundException {
        if (this.users.containsKey(remoteUoid)) {
            return this.users.get(remoteUoid);
        }
        SUser remoteUser = this.remoteClient.getServiceInterface().getUserByUoid(Long.valueOf(remoteUoid));
        User newUser = databaseSession.create(User.class);
        this.users.put(remoteUoid, newUser);
        long createdById = remoteUser.getCreatedById();
        if (createdById != -1L) {
            newUser.setCreatedBy(this.createUser(databaseSession, createdById));
        }
        newUser.setCreatedOn(remoteUser.getCreatedOn());
        newUser.setLastSeen(remoteUser.getLastSeen());
        newUser.setName(remoteUser.getName());
        newUser.setPasswordHash(remoteUser.getPasswordHash());
        newUser.setPasswordSalt(remoteUser.getPasswordSalt());
        newUser.setState(this.bimServer.getSConverter().convertFromSObject(remoteUser.getState()));
        newUser.setToken(remoteUser.getToken());
        newUser.setUsername(remoteUser.getUsername());
        newUser.setUserType(this.bimServer.getSConverter().convertFromSObject(remoteUser.getUserType()));
        this.bimServer.updateUserSettings(databaseSession, newUser);
        databaseSession.store((IdEObject)newUser);
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            LOGGER.info("Importing...");
            JsonBimServerClientFactory factory = new JsonBimServerClientFactory(this.bimServer.getMetaDataManager(), this.address);
            this.remoteClient = factory.create((AuthenticationInfo)new UsernamePasswordAuthenticationInfo(this.username, this.password));
            final BimDatabase database = this.bimServer.getDatabase();
            try (DatabaseSession databaseSession = database.createSession();){
                LOGGER.info("Users...");
                for (SUser user : this.remoteClient.getServiceInterface().getAllUsers()) {
                    this.createUser(databaseSession, user.getOid());
                }
                LOGGER.info("Projects...");
                for (SProject project : this.remoteClient.getBimsie1ServiceInterface().getAllProjects(Boolean.valueOf(false), Boolean.valueOf(false))) {
                    this.createProject(databaseSession, project.getOid());
                }
                LOGGER.info("Done");
                databaseSession.commit();
            }
            final BimServerClientInterface client = this.bimServer.getBimServerClientFactory().create((AuthenticationInfo)new UsernamePasswordAuthenticationInfo(this.username, this.password));
            Path incoming = Paths.get(this.path, new String[0]);
            final TreeMap<GregorianCalendar, Key> comments = new TreeMap<GregorianCalendar, Key>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
            for (SProject project : this.remoteClient.getBimsie1ServiceInterface().getAllProjects(Boolean.valueOf(false), Boolean.valueOf(false))) {
                for (SRevision revision : this.remoteClient.getBimsie1ServiceInterface().getAllRevisionsOfProject(Long.valueOf(project.getOid()))) {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(revision.getDate());
                    if (revision.getComment().startsWith("generated for")) continue;
                    User user = this.users.get(revision.getUserId());
                    Path userFolder = incoming.resolve(user.getUsername());
                    boolean found = false;
                    for (Path file : PathUtils.list((Path)userFolder)) {
                        if (!file.getFileName().toString().endsWith(revision.getComment())) continue;
                        String dateStr = file.getFileName().toString().substring(0, 19);
                        Date parse = dateFormat.parse(dateStr);
                        GregorianCalendar fileDate = new GregorianCalendar();
                        fileDate.setTime(parse);
                        long millisDiff = Math.abs(fileDate.getTimeInMillis() - revision.getDate().getTime());
                        if (millisDiff > 0x6DDD00L) continue;
                        if (revision.getOid() == project.getLastRevisionId()) {
                            comments.put(gregorianCalendar, new Key(file, project.getOid(), revision.getComment(), revision.getDate(), revision.getUserId()));
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LOGGER.info("Not found: " + revision.getComment());
                }
            }
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(1000));
            for (final GregorianCalendar gregorianCalendar : comments.keySet()) {
                executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Key key = (Key)comments.get(gregorianCalendar);
                        LOGGER.info("Checking in: " + key.file.getFileName().toString() + " " + Formatters.bytesToString((long)key.file.toFile().length()));
                        Project sProject = BimServerImporter.this.projects.get(key.poid);
                        try {
                            SDeserializerPluginConfiguration desserializer = client.getBimsie1ServiceInterface().getSuggestedDeserializerForExtension("ifc", Long.valueOf(sProject.getOid()));
                            client.checkin(sProject.getOid(), key.comment, desserializer.getOid(), false, true, key.file);
                            SProject updatedProject = client.getBimsie1ServiceInterface().getProjectByPoid(Long.valueOf(sProject.getOid()));
                            try (DatabaseSession databaseSession = database.createSession();){
                                LOGGER.info("Done");
                                Project project = (Project)databaseSession.get(updatedProject.getOid(), OldQuery.getDefault());
                                Revision revision = project.getLastRevision();
                                User user = (User)databaseSession.get(BimServerImporter.this.users.get(key.userId).getOid(), OldQuery.getDefault());
                                for (Revision otherRevision : ((ConcreteRevision)revision.getConcreteRevisions().get(0)).getRevisions()) {
                                    otherRevision.load();
                                    otherRevision.setDate(key.date);
                                    otherRevision.setComment(otherRevision.getComment().replace("Administrator", user.getName()));
                                    databaseSession.store((IdEObject)otherRevision);
                                }
                                SimpleDateFormat m = new SimpleDateFormat("dd-MM-yyyy");
                                LOGGER.info("Setting date to " + m.format(key.date));
                                revision.setUser(user);
                                revision.setDate(key.date);
                                databaseSession.store((IdEObject)revision);
                                databaseSession.commit();
                            }
                        }
                        catch (IOException | PublicInterfaceNotFoundException | ServerException | UserException e) {
                            LOGGER.error("", e);
                        }
                    }
                });
            }
            executorService.shutdown();
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ChannelConnectionException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private Project createProject(DatabaseSession databaseSession, long poid) throws BimserverDatabaseException, ServerException, UserException, PublicInterfaceNotFoundException {
        SProject project = this.remoteClient.getBimsie1ServiceInterface().getProjectByPoid(Long.valueOf(poid));
        if (this.projects.containsKey(project.getOid())) {
            return this.projects.get(project.getOid());
        }
        Project newProject = databaseSession.create(Project.class);
        this.projects.put(project.getOid(), newProject);
        newProject.setId(Integer.valueOf(databaseSession.newPid()));
        GeoTag geoTag = databaseSession.create(GeoTag.class);
        geoTag.setEnabled(Boolean.valueOf(false));
        newProject.setGeoTag(geoTag);
        databaseSession.store((IdEObject)geoTag);
        newProject.setCreatedBy(this.createUser(databaseSession, project.getCreatedById()));
        newProject.setCreatedDate(project.getCreatedDate());
        newProject.setDescription(project.getDescription());
        newProject.setExportLengthMeasurePrefix(this.bimServer.getSConverter().convertFromSObject(project.getExportLengthMeasurePrefix()));
        newProject.setName(project.getName());
        if (project.getParentId() != -1L) {
            Project createProject = this.createProject(databaseSession, project.getParentId());
            createProject.getSubProjects().add((Object)newProject);
            newProject.setParent(createProject);
        }
        Iterator iterator = project.getHasAuthorizedUsers().iterator();
        while (iterator.hasNext()) {
            long uoid = (Long)iterator.next();
            newProject.getHasAuthorizedUsers().add((Object)this.createUser(databaseSession, uoid));
        }
        newProject.setSchema("ifc2x3tc1");
        newProject.setState(this.bimServer.getSConverter().convertFromSObject(project.getState()));
        databaseSession.store((IdEObject)newProject);
        return newProject;
    }

    class Key {
        public String comment;
        public long userId;
        public Date date;
        public Path file;
        public long poid;

        public Key(Path file, long oid, String comment, Date date, long userId) {
            this.file = file;
            this.poid = oid;
            this.comment = comment;
            this.date = date;
            this.userId = userId;
        }
    }
}

