/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.actions.DownloadDatabaseAction;
import org.bimserver.database.migrations.InconsistentModelsException;
import org.bimserver.database.migrations.MigrationException;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcSlab;
import org.bimserver.models.ifc2x3tc1.IfcWall;
import org.bimserver.models.ifc2x3tc1.IfcWindow;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLine
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLine.class);
    private final BimServer bimServer;
    private volatile boolean running;
    private BufferedReader reader;

    public CommandLine(BimServer bimServer) {
        this.bimServer = bimServer;
        this.setName("CommandLine");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.reader = new BufferedReader(new InputStreamReader(System.in));
        this.running = true;
        while (true) {
            Iterator<Thread> iterator;
            Map<Thread, StackTraceElement[]> allStackTraces;
            block30: {
                try {
                    while (this.running) {
                        try {
                            String line = this.reader.readLine();
                            if (line == null) {
                                Thread.sleep(50L);
                                continue;
                            }
                            if (line.equalsIgnoreCase("exit")) {
                                this.bimServer.stop();
                                return;
                            }
                            if (line.startsWith("dumpmodel")) {
                                try {
                                    long roid = Long.parseLong(line.substring(9).trim());
                                    try (DatabaseSession databaseSession = this.bimServer.getDatabase().createSession();){
                                        DownloadDatabaseAction downloadDatabaseAction = new DownloadDatabaseAction(this.bimServer, databaseSession, AccessMethod.INTERNAL, roid, -1L, -1L, new SystemAuthorization(1, TimeUnit.HOURS), null);
                                        IfcModelInterface model = downloadDatabaseAction.execute();
                                        LOGGER.info("Model size: " + model.size());
                                        List walls = model.getAll(IfcWall.class);
                                        List projects = model.getAll(IfcProject.class);
                                        List slabs = model.getAll(IfcSlab.class);
                                        List windows = model.getAll(IfcWindow.class);
                                        LOGGER.info("Walls: " + walls.size());
                                        LOGGER.info("Windows: " + windows.size());
                                        LOGGER.info("Projects: " + projects.size());
                                        LOGGER.info("Slabs: " + slabs.size());
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("", (Throwable)e);
                                }
                                continue;
                            }
                            if (line.equalsIgnoreCase("dump")) {
                                LOGGER.info("Dumping all thread's track traces...");
                                LOGGER.info("");
                                allStackTraces = Thread.getAllStackTraces();
                                iterator = allStackTraces.keySet().iterator();
                                break block30;
                            }
                            if (line.equals("migrate")) {
                                try {
                                    this.bimServer.getDatabase().getMigrator().migrate();
                                    this.bimServer.getServerInfoManager().update();
                                }
                                catch (MigrationException e) {
                                    LOGGER.error("", (Throwable)e);
                                }
                                catch (InconsistentModelsException e) {
                                    LOGGER.error("", (Throwable)e);
                                }
                                continue;
                            }
                            if (line.equals("clearendpoints")) {
                                this.bimServer.getEndPointManager().clear();
                                continue;
                            }
                            if (line.startsWith("showall")) {
                                KeyValueStore keyValueStore = ((Database)this.bimServer.getDatabase()).getKeyValueStore();
                                Set<String> allTableNames = keyValueStore.getAllTableNames();
                                long total = 0L;
                                for (String tableName : allTableNames) {
                                    long size = keyValueStore.count(tableName);
                                    total += size;
                                    if (size == 0L) continue;
                                    LOGGER.info(tableName + " " + size);
                                }
                                LOGGER.info("total: " + total);
                                continue;
                            }
                            LOGGER.info("Unknown command");
                        }
                        catch (IOException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            while (iterator.hasNext()) {
                StackTraceElement[] stackTraceElements;
                Thread t = iterator.next();
                LOGGER.info(t.getName());
                for (StackTraceElement stackTraceElement : stackTraceElements = allStackTraces.get(t)) {
                    LOGGER.info("\t" + stackTraceElement.getClassName() + ":" + stackTraceElement.getLineNumber() + "." + stackTraceElement.getMethodName());
                }
                LOGGER.info("");
            }
            LOGGER.info("Done printing stack traces");
            LOGGER.info("");
            Thread.sleep(10000L);
        }
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

