/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import org.bimserver.BimServer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedWebServer.class);
    private WebAppContext context;
    private Server server = new Server();

    public EmbeddedWebServer(BimServer bimServer, boolean localDev) {
        ServerConnector socketConnector = new ServerConnector(this.server);
        socketConnector.setPort(bimServer.getConfig().getPort());
        this.server.addConnector((Connector)socketConnector);
        this.context = new WebAppContext((HandlerContainer)this.server, "", "/");
        this.context.setTempDirectory(bimServer.getHomeDir().resolve("jettytmp").toFile());
        if (localDev) {
            this.context.setDefaultsDescriptor("www/WEB-INF/webdefault.xml");
        }
        this.context.getServletContext().setAttribute("bimserver", (Object)bimServer);
        if (this.context.getResourceBase() == null) {
            this.context.setResourceBase("../BimServer/www");
        }
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public WebAppContext getContext() {
        return this.context;
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

