/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GeometryCache;
import org.bimserver.GeometryCacheEntry;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.Schema;
import org.bimserver.geometry.Matrix;
import org.bimserver.geometry.Vector;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryFactory;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.models.ifc2x3tc1.IfcShapeRepresentation;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.plugins.ModelHelper;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.objectidms.HideAllInversesObjectIDM;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.plugins.renderengine.EntityNotFoundException;
import org.bimserver.plugins.renderengine.IndexFormat;
import org.bimserver.plugins.renderengine.Precision;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineGeometry;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.bimserver.plugins.serializers.Serializer;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CollectionUtils;
import org.bimserver.utils.Formatters;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryGenerator.class);
    private final BimServer bimServer;
    private final Map<Integer, GeometryData> hashes = new ConcurrentHashMap<Integer, GeometryData>();
    private EClass productClass;
    private EClass productRepresentationClass;
    private EStructuralFeature geometryFeature;
    private EStructuralFeature representationFeature;
    private EStructuralFeature representationsFeature;
    private PackageMetaData packageMetaData;
    private AtomicLong bytesSaved = new AtomicLong();
    private AtomicLong totalBytes = new AtomicLong();

    public GeometryGenerator(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    public GenerateGeometryResult generateGeometry(long uoid, PluginManager pluginManager, final DatabaseSession databaseSession, IfcModelInterface model, int pid, int rid, boolean store, GeometryCache geometryCache) throws BimserverDatabaseException, GeometryGeneratingException {
        GenerateGeometryResult generateGeometryResult = new GenerateGeometryResult();
        this.packageMetaData = model.getPackageMetaData();
        this.productClass = this.packageMetaData.getEClass("IfcProduct");
        this.productRepresentationClass = this.packageMetaData.getEClass("IfcProductRepresentation");
        this.geometryFeature = this.productClass.getEStructuralFeature("geometry");
        this.representationFeature = this.productClass.getEStructuralFeature("Representation");
        this.representationsFeature = this.productRepresentationClass.getEStructuralFeature("Representations");
        if (geometryCache != null && !geometryCache.isEmpty()) {
            this.returnCachedData(model, geometryCache, databaseSession, pid, rid);
            return null;
        }
        long start = System.nanoTime();
        String pluginName = "";
        if (model.getPackageMetaData().getSchema() == Schema.IFC4) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc4StepSerializerPlugin";
        } else if (model.getPackageMetaData().getSchema() == Schema.IFC2X3TC1) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc2x3tc1StepSerializerPlugin";
        }
        try {
            SerializerPlugin ifcSerializerPlugin = (SerializerPlugin)pluginManager.getPlugin(pluginName, true);
            if (ifcSerializerPlugin == null) {
                throw new UserException("No IFC serializer found");
            }
            User user = (User)databaseSession.get(uoid, OldQuery.getDefault());
            UserSettings userSettings = user.getUserSettings();
            RenderEnginePluginConfiguration defaultRenderEngine = userSettings.getDefaultRenderEngine();
            if (defaultRenderEngine == null) {
                throw new UserException("No default render engine has been selected for this user");
            }
            int maxSimultanousThreads = Math.min(this.bimServer.getServerSettingsCache().getServerSettings().getRenderEngineProcesses(), Runtime.getRuntime().availableProcessors());
            if (maxSimultanousThreads < 1) {
                maxSimultanousThreads = 1;
            }
            RenderEngineSettings settings = new RenderEngineSettings();
            settings.setPrecision(Precision.SINGLE);
            settings.setIndexFormat(IndexFormat.AUTO_DETECT);
            settings.setGenerateNormals(true);
            settings.setGenerateTriangles(true);
            settings.setGenerateWireFrame(false);
            RenderEngineFilter renderEngineFilter = new RenderEngineFilter();
            if (maxSimultanousThreads == 1) {
                Runner runner = new Runner(null, defaultRenderEngine.getPluginDescriptor().getPluginClassName(), databaseSession, settings, store, model, ifcSerializerPlugin, model, pid, rid, null, renderEngineFilter, generateGeometryResult);
                runner.run();
            } else {
                HashSet<EClass> classes = new HashSet<EClass>();
                for (IdEObject object : model.getAllWithSubTypes(this.packageMetaData.getEClass("IfcProduct"))) {
                    IdEObject representation = (IdEObject)object.eGet(this.representationFeature);
                    if (representation == null || ((List)representation.eGet(this.representationsFeature)).size() <= 0) continue;
                    classes.add(object.eClass());
                }
                if (classes.size() == 0) {
                    return null;
                }
                classes.remove(this.packageMetaData.getEClass("IfcAnnotation"));
                classes.remove(this.packageMetaData.getEClass("IfcOpeningElement"));
                LOGGER.debug("Using " + maxSimultanousThreads + " processes for geometry generation");
                ThreadPoolExecutor executor = new ThreadPoolExecutor(maxSimultanousThreads, maxSimultanousThreads, 24L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(classes.size()));
                HashMap<IdEObject, IdEObject> bigMap = new HashMap<IdEObject, IdEObject>();
                HideAllInversesObjectIDM idm = new HideAllInversesObjectIDM(CollectionUtils.singleSet((Object)this.packageMetaData.getEPackage()), pluginManager.getMetaDataManager().getPackageMetaData("ifc2x3tc1"));
                OidProvider oidProvider = new OidProvider(){

                    public long newOid(EClass eClass) {
                        return databaseSession.newOid(eClass);
                    }
                };
                for (EClass eClass : classes) {
                    BasicIfcModel targetModel = new BasicIfcModel(pluginManager.getMetaDataManager().getPackageMetaData("ifc2x3tc1"), null);
                    ModelHelper modelHelper = new ModelHelper(this.bimServer.getMetaDataManager(), (IfcModelInterface)targetModel);
                    modelHelper.setOidProvider(oidProvider);
                    modelHelper.setObjectIDM((ObjectIDM)idm);
                    IdEObject newOwnerHistory = modelHelper.copyBasicObjects(model, bigMap);
                    for (IdEObject idEObject : model.getAll(eClass)) {
                        IdEObject newObject = modelHelper.copy(idEObject, false, ModelHelper.createObjectIdm((EClass)idEObject.eClass()));
                        modelHelper.copyDecomposes(idEObject, newOwnerHistory);
                        bigMap.put(newObject, idEObject);
                        if (!eClass.getName().equals("IfcWallStandardCase")) continue;
                        EStructuralFeature hasOpeningsFeature = idEObject.eClass().getEStructuralFeature("HasOpenings");
                        for (IdEObject ifcRelVoidsElement : (List)idEObject.eGet(hasOpeningsFeature)) {
                            bigMap.put(modelHelper.copy(ifcRelVoidsElement, false), ifcRelVoidsElement);
                            EStructuralFeature relatedOpeningElementFeature = ifcRelVoidsElement.eClass().getEStructuralFeature("RelatedOpeningElement");
                            IdEObject relatedOpeningElement = (IdEObject)ifcRelVoidsElement.eGet(relatedOpeningElementFeature);
                            if (relatedOpeningElement == null) continue;
                            bigMap.put(modelHelper.copy(relatedOpeningElement, false), relatedOpeningElement);
                        }
                    }
                    executor.submit(new Runner(eClass, defaultRenderEngine.getPluginDescriptor().getPluginClassName(), databaseSession, settings, store, (IfcModelInterface)targetModel, ifcSerializerPlugin, model, pid, rid, bigMap, renderEngineFilter, generateGeometryResult));
                }
                executor.shutdown();
                executor.awaitTermination(24L, TimeUnit.HOURS);
            }
            long end = System.nanoTime();
            LOGGER.info("Rendertime: " + (end - start) / 1000000L + "ms, " + "Reused: " + Formatters.bytesToString((long)this.bytesSaved.get()) + ", Total: " + Formatters.bytesToString((long)this.totalBytes.get()) + ", Final: " + Formatters.bytesToString((long)(this.totalBytes.get() - this.bytesSaved.get())));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new GeometryGeneratingException(e);
        }
        return generateGeometryResult;
    }

    private int hash(GeometryData geometryData) {
        int hashCode = 0;
        if (geometryData.getIndices() != null) {
            hashCode += Arrays.hashCode(geometryData.getIndices());
        }
        if (geometryData.getVertices() != null) {
            hashCode += Arrays.hashCode(geometryData.getVertices());
        }
        if (geometryData.getNormals() != null) {
            hashCode += Arrays.hashCode(geometryData.getNormals());
        }
        if (geometryData.getMaterialIndices() != null) {
            hashCode += Arrays.hashCode(geometryData.getMaterialIndices());
        }
        if (geometryData.getMaterials() != null) {
            hashCode += Arrays.hashCode(geometryData.getMaterials());
        }
        return hashCode;
    }

    private void processExtends(GeometryInfo geometryInfo, double[] transformationMatrix, float[] vertices, int index, GenerateGeometryResult generateGeometryResult) {
        double x = vertices[index];
        double y = vertices[index + 1];
        double z = vertices[index + 2];
        double[] result = new double[4];
        Matrix.multiplyMV((double[])result, (int)0, (double[])transformationMatrix, (int)0, (double[])new double[]{x, y, z, 1.0}, (int)0);
        x = result[0];
        y = result[1];
        z = result[2];
        geometryInfo.getMinBounds().setX(Math.min(x, geometryInfo.getMinBounds().getX()));
        geometryInfo.getMinBounds().setY(Math.min(y, geometryInfo.getMinBounds().getY()));
        geometryInfo.getMinBounds().setZ(Math.min(z, geometryInfo.getMinBounds().getZ()));
        geometryInfo.getMaxBounds().setX(Math.max(x, geometryInfo.getMaxBounds().getX()));
        geometryInfo.getMaxBounds().setY(Math.max(y, geometryInfo.getMaxBounds().getY()));
        geometryInfo.getMaxBounds().setZ(Math.max(z, geometryInfo.getMaxBounds().getZ()));
        generateGeometryResult.getMinBounds().setX(Math.min(x, generateGeometryResult.getMinBounds().getX()));
        generateGeometryResult.getMinBounds().setY(Math.min(y, generateGeometryResult.getMinBounds().getY()));
        generateGeometryResult.getMinBounds().setZ(Math.min(z, generateGeometryResult.getMinBounds().getZ()));
        generateGeometryResult.getMaxBounds().setX(Math.max(x, generateGeometryResult.getMaxBounds().getX()));
        generateGeometryResult.getMaxBounds().setY(Math.max(y, generateGeometryResult.getMaxBounds().getY()));
        generateGeometryResult.getMaxBounds().setZ(Math.max(z, generateGeometryResult.getMaxBounds().getZ()));
    }

    private byte[] floatArrayToByteArray(float[] vertices) {
        if (vertices == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[vertices.length * 4]);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer asFloatBuffer = buffer.asFloatBuffer();
        for (float f : vertices) {
            asFloatBuffer.put(f);
        }
        return buffer.array();
    }

    private byte[] intArrayToByteArray(int[] indices) {
        if (indices == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[indices.length * 4]);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer asIntBuffer = buffer.asIntBuffer();
        for (int i : indices) {
            asIntBuffer.put(i);
        }
        return buffer.array();
    }

    private void setTransformationMatrix(GeometryInfo geometryInfo, double[] transformationMatrix) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer asDoubleBuffer = byteBuffer.asDoubleBuffer();
        for (double f : transformationMatrix) {
            asDoubleBuffer.put(f);
        }
        geometryInfo.setTransformation(byteBuffer.array());
    }

    private static boolean almostTheSame(float f1, float f2, float maxDiff) {
        return Math.abs(f1 - f2) < maxDiff;
    }

    private static float[] getTransformationMatrix(float[] originalV1, float[] originalV2, float[] originalV3, float[] u1, float[] u2, float[] u3, float maxDiff) {
        float[] v1 = GeometryGenerator.copy(originalV1);
        float[] v2 = GeometryGenerator.copy(originalV2);
        float[] v3 = GeometryGenerator.copy(originalV3);
        u1 = GeometryGenerator.copy(u1);
        u2 = GeometryGenerator.copy(u2);
        u3 = GeometryGenerator.copy(u3);
        float transX = u1[0] - v1[0];
        float transY = u1[1] - v1[1];
        float transZ = u1[2] - v1[2];
        float[] translation = new float[16];
        Matrix.setIdentityM((float[])translation, (int)0);
        Matrix.translateM((float[])translation, (int)0, (float)u1[0], (float)u1[1], (float)u1[2]);
        float[] toZeroTranslation = new float[16];
        Matrix.setIdentityM((float[])toZeroTranslation, (int)0);
        Matrix.translateM((float[])toZeroTranslation, (int)0, (float)(-v1[0]), (float)(-v1[1]), (float)(-v1[2]));
        if (GeometryGenerator.almostTheSame(v2[0] + transX, u2[0], maxDiff) && GeometryGenerator.almostTheSame(v2[1] + transY, u2[1], maxDiff) && GeometryGenerator.almostTheSame(v2[2] + transZ, u2[2], maxDiff) && GeometryGenerator.almostTheSame(v3[0] + transX, u3[0], maxDiff) && GeometryGenerator.almostTheSame(v3[1] + transY, u3[1], maxDiff) && GeometryGenerator.almostTheSame(v3[2] + transZ, u3[2], maxDiff)) {
            return translation;
        }
        GeometryGenerator.subtract(u2, u1);
        GeometryGenerator.subtract(u3, u1);
        GeometryGenerator.subtract(u1, u1);
        GeometryGenerator.subtract(v2, v1);
        GeometryGenerator.subtract(v3, v1);
        GeometryGenerator.subtract(v1, v1);
        float[] u2CrossV2 = Vector.crossProduct((float[])u2, (float[])v2);
        float[] r2 = new float[16];
        Matrix.setIdentityM((float[])r2, (int)0);
        float[] r2v2 = new float[4];
        if (!GeometryGenerator.equalsAlmost(u2, v2, maxDiff)) {
            float u2InV2 = Vector.dot((float[])u2, (float[])v2);
            float[] axis = u2CrossV2;
            if (axis[0] == 0.0f && axis[1] == 0.0f && axis[2] == 0.0f) {
                axis = new float[]{u2[1], -u2[0], 0.0f, 0.0f};
            }
            Matrix.rotateM((float[])r2, (int)0, (float)((float)Math.toDegrees(Math.atan2(Vector.length((float[])u2CrossV2), u2InV2))), (float)axis[0], (float)axis[1], (float)axis[2]);
            Matrix.multiplyMV((float[])r2v2, (int)0, (float[])r2, (int)0, (float[])new float[]{v2[0], v2[1], v2[2], 1.0f}, (int)0);
            if (!GeometryGenerator.equalsAlmost(r2v2, u2, maxDiff)) {
                Matrix.setIdentityM((float[])r2, (int)0);
                Matrix.rotateM((float[])r2, (int)0, (float)(-((float)Math.toDegrees(Math.atan2(Vector.length((float[])u2CrossV2), u2InV2)))), (float)axis[0], (float)axis[1], (float)axis[2]);
                Matrix.multiplyMV((float[])r2v2, (int)0, (float[])r2, (int)0, (float[])new float[]{v2[0], v2[1], v2[2], 1.0f}, (int)0);
                if (!GeometryGenerator.equalsAlmost(r2v2, u2, maxDiff)) {
                    return null;
                }
            }
        } else {
            r2v2 = GeometryGenerator.copy(v2);
        }
        float[] r2v3 = new float[4];
        Matrix.multiplyMV((float[])r2v3, (int)0, (float[])r2, (int)0, (float[])new float[]{v3[0], v3[1], v3[2], 1.0f}, (int)0);
        float[] r3 = new float[16];
        Matrix.setIdentityM((float[])r3, (int)0);
        float angleDegrees = (float)Math.toDegrees(GeometryGenerator.getPlaneAngle(v1, r2v2, r2v3, u1, u2, u3));
        Matrix.rotateM((float[])r3, (int)0, (float)angleDegrees, (float)r2v2[0], (float)r2v2[1], (float)r2v2[2]);
        float[] r3v3 = new float[4];
        Matrix.multiplyMV((float[])r3v3, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v3[0], r2v3[1], r2v3[2], 1.0f}, (int)0);
        float[] r2v1 = new float[4];
        Matrix.multiplyMV((float[])r2v1, (int)0, (float[])r2, (int)0, (float[])new float[]{v1[0], v1[1], v1[2], 1.0f}, (int)0);
        float[] r3v1 = new float[4];
        Matrix.multiplyMV((float[])r3v1, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v1[0], r2v1[1], r2v1[2], 1.0f}, (int)0);
        if (!GeometryGenerator.equalsAlmost(r3v3, u3, maxDiff)) {
            Matrix.setIdentityM((float[])r3, (int)0);
            Matrix.rotateM((float[])r3, (int)0, (float)(-angleDegrees), (float)r2v2[0], (float)r2v2[1], (float)r2v2[2]);
            Matrix.multiplyMV((float[])r3v3, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v3[0], r2v3[1], r2v3[2], 1.0f}, (int)0);
            float[] r3v2 = new float[4];
            Matrix.multiplyMV((float[])r3v2, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v2[0], r2v2[1], r2v2[2], 1.0f}, (int)0);
            if (!GeometryGenerator.equalsAlmost(r3v3, u3, maxDiff) || !GeometryGenerator.equalsAlmost(r3v2, u2, maxDiff)) {
                return null;
            }
        }
        float[] subResult = new float[16];
        float[] subResult2 = new float[16];
        float[] subResult3 = new float[16];
        float[] totalResult = new float[16];
        float[] startMatrix = new float[16];
        Matrix.setIdentityM((float[])startMatrix, (int)0);
        Matrix.multiplyMM((float[])subResult, (int)0, (float[])toZeroTranslation, (int)0, (float[])startMatrix, (int)0);
        Matrix.multiplyMM((float[])subResult2, (int)0, (float[])r2, (int)0, (float[])subResult, (int)0);
        Matrix.multiplyMM((float[])subResult3, (int)0, (float[])r3, (int)0, (float[])subResult2, (int)0);
        Matrix.multiplyMM((float[])totalResult, (int)0, (float[])translation, (int)0, (float[])subResult3, (int)0);
        return totalResult;
    }

    private static double getPlaneAngle(float[] v1, float[] v2, float[] v3, float[] u1, float[] u2, float[] u3) {
        double result;
        float den;
        float[] cross1 = Vector.crossProduct((float[])new float[]{v2[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]}, (float[])new float[]{v3[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]});
        float[] fArray = new float[]{u2[0] - u1[0], u2[1] - u1[1], u2[2] - u1[2]};
        float[] fArray2 = new float[]{u3[0] - u1[0], u3[1] - u1[1], u3[2] - u1[2]};
        float[] cross2 = Vector.crossProduct((float[])fArray, (float[])fArray2);
        float num = Vector.dot((float[])cross1, (float[])cross2);
        float a = num / (den = Vector.length((float[])cross1) * Vector.length((float[])cross2));
        if (a > 1.0f) {
            a = 1.0f;
        }
        if (a < -1.0f) {
            a = -1.0f;
        }
        if (Double.isNaN(result = Math.acos(a))) {
            System.out.println();
        }
        return result;
    }

    private static boolean equalsAlmost(float[] r2v2, float[] u2, float maxDiff) {
        for (int i = 0; i < 3; ++i) {
            if (GeometryGenerator.almostTheSame(r2v2[i], u2[i], maxDiff)) continue;
            return false;
        }
        return true;
    }

    private static float[] copy(float[] v1) {
        float[] result = new float[v1.length];
        System.arraycopy(v1, 0, result, 0, v1.length);
        return result;
    }

    private static boolean test(float[] v1, float[] v2, float[] transformationMatrix, float maxDiff) {
        float[] resultVector = new float[4];
        Matrix.multiplyMV((float[])resultVector, (int)0, (float[])transformationMatrix, (int)0, (float[])new float[]{v1[0], v1[1], v1[2], 1.0f}, (int)0);
        GeometryGenerator.normalize(resultVector);
        boolean theSame = true;
        for (int i = 0; i < 3; ++i) {
            if (GeometryGenerator.almostTheSame(resultVector[i], v2[i], maxDiff)) continue;
            theSame = false;
        }
        if (!theSame) {
            System.out.println("Difference");
            Vector.dump((String)"Was", (float[])v1);
            Vector.dump((String)"Became", (float[])resultVector);
            Vector.dump((String)"Should be", (float[])v2);
            System.out.println();
            return false;
        }
        return true;
    }

    private static void normalize(float[] resultVector) {
        resultVector[0] = resultVector[0] * resultVector[3];
        resultVector[1] = resultVector[1] * resultVector[3];
        resultVector[2] = resultVector[2] * resultVector[3];
        resultVector[3] = 1.0f;
    }

    private static void subtract(float[] u2, float[] v1) {
        u2[0] = u2[0] - v1[0];
        u2[1] = u2[1] - v1[1];
        u2[2] = u2[2] - v1[2];
    }

    public static void main(String[] args) {
        float maxDiff = 0.1f;
        GeometryGenerator.test1(maxDiff);
        GeometryGenerator.test2(maxDiff);
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            float[] matrix = new float[16];
            Matrix.setIdentityM((float[])matrix, (int)0);
            for (int j = 0; j < 10; ++j) {
                Matrix.rotateM((float[])matrix, (int)0, (float)(random.nextFloat() * 360.0f), (float)random.nextFloat(), (float)random.nextFloat(), (float)random.nextFloat());
            }
            float[] v1 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] v2 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] v3 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] r1 = new float[4];
            float[] r2 = new float[4];
            float[] r3 = new float[4];
            Matrix.multiplyMV((float[])r1, (int)0, (float[])matrix, (int)0, (float[])v1, (int)0);
            Matrix.multiplyMV((float[])r2, (int)0, (float[])matrix, (int)0, (float[])v2, (int)0);
            Matrix.multiplyMV((float[])r3, (int)0, (float[])matrix, (int)0, (float[])v3, (int)0);
            float[] calculatedMatrix = GeometryGenerator.getTransformationMatrix(v1, v2, v3, r1, r2, r3, maxDiff);
            GeometryGenerator.test(v1, r1, calculatedMatrix, maxDiff);
            GeometryGenerator.test(v2, r2, calculatedMatrix, maxDiff);
            GeometryGenerator.test(v3, r3, calculatedMatrix, maxDiff);
            for (int j = 0; j < 10; ++j) {
                float[] q1 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] q2 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] q3 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] b1 = new float[4];
                float[] b2 = new float[4];
                float[] b3 = new float[4];
                Matrix.multiplyMV((float[])b1, (int)0, (float[])matrix, (int)0, (float[])q1, (int)0);
                Matrix.multiplyMV((float[])b2, (int)0, (float[])matrix, (int)0, (float[])q2, (int)0);
                Matrix.multiplyMV((float[])b3, (int)0, (float[])matrix, (int)0, (float[])q3, (int)0);
                GeometryGenerator.test(q1, b1, calculatedMatrix, maxDiff);
                GeometryGenerator.test(q2, b2, calculatedMatrix, maxDiff);
                GeometryGenerator.test(q3, b3, calculatedMatrix, maxDiff);
            }
        }
    }

    private static void test1(float maxDiff) {
        float[] v1 = new float[]{1.0f, 2.0f, 0.0f};
        float[] v2 = new float[]{1.0f, 1.0f, 0.0f};
        float[] v3 = new float[]{3.0f, 2.0f, 0.0f};
        float[] u1 = new float[]{0.0f, 2.0f, 0.0f};
        float[] u2 = new float[]{-1.0f, 2.0f, 0.0f};
        float[] u3 = new float[]{0.0f, 2.0f, 2.0f};
        float[] transformationMatrix = GeometryGenerator.getTransformationMatrix(v1, v2, v3, u1, u2, u3, maxDiff);
        GeometryGenerator.test(v1, u1, transformationMatrix, maxDiff);
        GeometryGenerator.test(v2, u2, transformationMatrix, maxDiff);
        GeometryGenerator.test(v3, u3, transformationMatrix, maxDiff);
    }

    private static void test2(float maxDiff) {
        float[] v1 = new float[]{3.0f, 0.0f, 0.0f};
        float[] v2 = new float[]{4.0f, 0.0f, 0.0f};
        float[] v3 = new float[]{4.0f, 1.0f, 0.0f};
        float[] u1 = new float[]{1.0f, 3.0f, 0.0f};
        float[] u2 = new float[]{0.0f, 3.0f, 0.0f};
        float[] u3 = new float[]{0.0f, 2.0f, 0.0f};
        float[] transformationMatrix = GeometryGenerator.getTransformationMatrix(v1, v2, v3, u1, u2, u3, maxDiff);
        GeometryGenerator.test(v1, u1, transformationMatrix, maxDiff);
        GeometryGenerator.test(v2, u2, transformationMatrix, maxDiff);
        GeometryGenerator.test(v3, u3, transformationMatrix, maxDiff);
    }

    private void returnCachedData(IfcModelInterface model, GeometryCache geometryCache, DatabaseSession databaseSession, int pid, int rid) throws BimserverDatabaseException {
        EClass productClass = model.getPackageMetaData().getEClass("IfcProduct");
        List products = model.getAllWithSubTypes(productClass);
        for (IdEObject ifcProduct : products) {
            GeometryCacheEntry geometryCacheEntry = geometryCache.get(ifcProduct.getExpressId());
            if (geometryCacheEntry == null) continue;
            GeometryData geometryData = (GeometryData)databaseSession.create(GeometryPackage.eINSTANCE.getGeometryData(), pid, rid);
            geometryData.setVertices(geometryCacheEntry.getVertices().array());
            geometryData.setNormals(geometryCacheEntry.getNormals().array());
            GeometryInfo geometryInfo = (GeometryInfo)databaseSession.create(GeometryPackage.eINSTANCE.getGeometryInfo(), pid, rid);
            Vector3f min = (Vector3f)databaseSession.create(GeometryPackage.eINSTANCE.getVector3f(), pid, rid);
            min.setX(geometryCacheEntry.getGeometryInfo().getMinBounds().getX());
            min.setY(geometryCacheEntry.getGeometryInfo().getMinBounds().getY());
            min.setZ(geometryCacheEntry.getGeometryInfo().getMinBounds().getZ());
            Vector3f max = (Vector3f)databaseSession.create(GeometryPackage.eINSTANCE.getVector3f(), pid, rid);
            max.setX(geometryCacheEntry.getGeometryInfo().getMaxBounds().getX());
            max.setY(geometryCacheEntry.getGeometryInfo().getMaxBounds().getY());
            max.setZ(geometryCacheEntry.getGeometryInfo().getMaxBounds().getZ());
            geometryInfo.setMinBounds(min);
            geometryInfo.setMaxBounds(max);
            geometryInfo.setData(geometryData);
            ifcProduct.eSet(ifcProduct.eClass().getEStructuralFeature("geometry"), (Object)geometryInfo);
        }
    }

    private Vector3f createVector3f(PackageMetaData packageMetaData, IfcModelInterface model, float defaultValue, DatabaseSession session, boolean store, int pid, int rid) throws BimserverDatabaseException, IfcModelInterfaceException {
        Vector3f vector3f = null;
        if (store) {
            vector3f = (Vector3f)model.createAndAdd(GeometryPackage.eINSTANCE.getVector3f(), session.newOid(GeometryPackage.eINSTANCE.getVector3f()));
            session.store((IdEObject)vector3f, pid, rid);
        } else {
            vector3f = GeometryFactory.eINSTANCE.createVector3f();
        }
        vector3f.setX((double)defaultValue);
        vector3f.setY((double)defaultValue);
        vector3f.setZ((double)defaultValue);
        return vector3f;
    }

    public class Runner
    implements Runnable {
        private EClass eClass;
        private DatabaseSession databaseSession;
        private RenderEngineSettings renderEngineSettings;
        private RenderEngineFilter renderEngineFilter;
        private RenderEngineFilter renderEngineFilterTransformed = new RenderEngineFilter(true);
        private boolean store;
        private IfcModelInterface targetModel;
        private SerializerPlugin ifcSerializerPlugin;
        private IfcModelInterface model;
        private int pid;
        private int rid;
        private Map<IdEObject, IdEObject> bigMap;
        private GenerateGeometryResult generateGeometryResult;
        private String renderEnginePluginClassName;

        public Runner(EClass eClass, String renderEnginePluginClassName, DatabaseSession databaseSession, RenderEngineSettings renderEngineSettings, boolean store, IfcModelInterface targetModel, SerializerPlugin ifcSerializerPlugin, IfcModelInterface model, int pid, int rid, Map<IdEObject, IdEObject> bigMap, RenderEngineFilter renderEngineFilter, GenerateGeometryResult generateGeometryResult) {
            this.eClass = eClass;
            this.renderEnginePluginClassName = renderEnginePluginClassName;
            this.databaseSession = databaseSession;
            this.renderEngineSettings = renderEngineSettings;
            this.store = store;
            this.targetModel = targetModel;
            this.ifcSerializerPlugin = ifcSerializerPlugin;
            this.model = model;
            this.pid = pid;
            this.rid = rid;
            this.bigMap = bigMap;
            this.renderEngineFilter = renderEngineFilter;
            this.generateGeometryResult = generateGeometryResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.targetModel.generateMinimalExpressIds();
            Serializer ifcSerializer = this.ifcSerializerPlugin.createSerializer(new PluginConfiguration());
            RenderEnginePool pool = null;
            RenderEngine renderEngine = null;
            try {
                pool = GeometryGenerator.this.bimServer.getRenderEnginePools().getRenderEnginePool(this.model.getPackageMetaData().getSchema(), this.renderEnginePluginClassName);
                renderEngine = pool.request();
                renderEngine.init();
                ifcSerializer.init(this.targetModel, null, (PluginManagerInterface)GeometryGenerator.this.bimServer.getPluginManager(), this.model.getPackageMetaData(), true);
                boolean debug = true;
                InputStream in = null;
                if (debug) {
                    File file = new File((this.eClass == null ? "all" : this.eClass.getName()) + ".ifc");
                    FileOutputStream fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)ifcSerializer.getInputStream(), (OutputStream)fos);
                    fos.close();
                    in = new FileInputStream(file);
                } else {
                    in = ifcSerializer.getInputStream();
                }
                RenderEngineModel renderEngineModel = renderEngine.openModel(in);
                try {
                    renderEngineModel.setSettings(this.renderEngineSettings);
                    renderEngineModel.setFilter(this.renderEngineFilter);
                    renderEngineModel.generateGeneralGeometry();
                    List allWithSubTypes = null;
                    allWithSubTypes = this.eClass == null ? this.targetModel.getAllWithSubTypes(GeometryGenerator.this.packageMetaData.getEClass("IfcProduct")) : this.targetModel.getAll(this.eClass);
                    for (IdEObject ifcProduct : allWithSubTypes) {
                        IdEObject representation = (IdEObject)ifcProduct.eGet(GeometryGenerator.this.representationFeature);
                        if (representation == null || ((List)representation.eGet(GeometryGenerator.this.representationsFeature)).size() <= 0) continue;
                        List representations = (List)representation.eGet(GeometryGenerator.this.representationsFeature);
                        try {
                            RenderEngineInstance renderEngineInstance = renderEngineModel.getInstanceFromExpressId(ifcProduct.getExpressId());
                            RenderEngineGeometry geometry = renderEngineInstance.generateGeometry();
                            boolean translate = true;
                            if (geometry == null || geometry.getIndices().length == 0) {
                                renderEngineModel.setFilter(this.renderEngineFilterTransformed);
                                geometry = renderEngineInstance.generateGeometry();
                                if (geometry != null) {
                                    translate = false;
                                }
                                renderEngineModel.setFilter(this.renderEngineFilter);
                            }
                            if (geometry == null || geometry.getNrIndices() <= 0) continue;
                            GeometryInfo geometryInfo = null;
                            if (this.store) {
                                geometryInfo = (GeometryInfo)this.model.createAndAdd(GeometryPackage.eINSTANCE.getGeometryInfo(), this.databaseSession.newOid(GeometryPackage.eINSTANCE.getGeometryInfo()));
                                this.databaseSession.store((IdEObject)geometryInfo, this.pid, this.rid);
                            } else {
                                geometryInfo = GeometryFactory.eINSTANCE.createGeometryInfo();
                            }
                            geometryInfo.setMinBounds(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Float.POSITIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
                            geometryInfo.setMaxBounds(GeometryGenerator.this.createVector3f(GeometryGenerator.this.packageMetaData, this.model, Float.NEGATIVE_INFINITY, this.databaseSession, this.store, this.pid, this.rid));
                            try {
                                double area = renderEngineInstance.getArea();
                                geometryInfo.setArea(area);
                                double volume = renderEngineInstance.getVolume();
                                if (volume < 0.0) {
                                    volume = -volume;
                                }
                                geometryInfo.setVolume(volume);
                            }
                            catch (UnsupportedOperationException area) {
                                // empty catch block
                            }
                            GeometryData geometryData = null;
                            if (this.store) {
                                geometryData = (GeometryData)this.model.createAndAdd(GeometryPackage.eINSTANCE.getGeometryData(), this.databaseSession.newOid(GeometryPackage.eINSTANCE.getGeometryData()));
                                this.databaseSession.store((IdEObject)geometryData, this.pid, this.rid);
                            } else {
                                geometryData = GeometryFactory.eINSTANCE.createGeometryData();
                            }
                            geometryData.setIndices(GeometryGenerator.this.intArrayToByteArray(geometry.getIndices()));
                            geometryData.setVertices(GeometryGenerator.this.floatArrayToByteArray(geometry.getVertices()));
                            geometryData.setMaterialIndices(GeometryGenerator.this.intArrayToByteArray(geometry.getMaterialIndices()));
                            geometryData.setNormals(GeometryGenerator.this.floatArrayToByteArray(geometry.getNormals()));
                            geometryInfo.setPrimitiveCount(Integer.valueOf(geometry.getIndices().length / 3));
                            if (geometry.getMaterialIndices() != null && geometry.getMaterialIndices().length > 0) {
                                boolean hasMaterial = false;
                                float[] vertex_colors = new float[geometry.getVertices().length / 3 * 4];
                                for (int i = 0; i < geometry.getMaterialIndices().length; ++i) {
                                    int c = geometry.getMaterialIndices()[i];
                                    for (int j = 0; j < 3; ++j) {
                                        int k = geometry.getIndices()[i * 3 + j];
                                        if (c <= -1) continue;
                                        hasMaterial = true;
                                        for (int l = 0; l < 4; ++l) {
                                            vertex_colors[4 * k + l] = geometry.getMaterials()[4 * c + l];
                                        }
                                    }
                                }
                                if (hasMaterial) {
                                    geometryData.setMaterials(GeometryGenerator.this.floatArrayToByteArray(vertex_colors));
                                }
                            }
                            double[] tranformationMatrix = new double[16];
                            Matrix.setIdentityM((double[])tranformationMatrix, (int)0);
                            if (translate && renderEngineInstance.getTransformationMatrix() != null) {
                                tranformationMatrix = renderEngineInstance.getTransformationMatrix();
                            }
                            for (int i = 0; i < geometry.getIndices().length; ++i) {
                                GeometryGenerator.this.processExtends(geometryInfo, tranformationMatrix, geometry.getVertices(), geometry.getIndices()[i] * 3, this.generateGeometryResult);
                            }
                            geometryInfo.setData(geometryData);
                            long length = (geometryData.getIndices() != null ? geometryData.getIndices().length : 0) + (geometryData.getVertices() != null ? geometryData.getVertices().length : 0) + (geometryData.getNormals() != null ? geometryData.getNormals().length : 0) + (geometryData.getMaterials() != null ? geometryData.getMaterials().length : 0) + (geometryData.getMaterialIndices() != null ? geometryData.getMaterialIndices().length : 0);
                            GeometryGenerator.this.setTransformationMatrix(geometryInfo, tranformationMatrix);
                            if (GeometryGenerator.this.bimServer.getServerSettingsCache().getServerSettings().isReuseGeometry()) {
                                int hash = GeometryGenerator.this.hash(geometryData);
                                if (GeometryGenerator.this.hashes.containsKey(hash)) {
                                    this.databaseSession.removeFromCommit((IdEObject)geometryData);
                                    geometryInfo.setData((GeometryData)GeometryGenerator.this.hashes.get(hash));
                                    GeometryGenerator.this.bytesSaved.addAndGet(length);
                                } else {
                                    GeometryGenerator.this.hashes.put(hash, geometryData);
                                }
                            }
                            GeometryGenerator.this.totalBytes.addAndGet(length);
                            if (this.bigMap == null) {
                                ifcProduct.eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                                if (!this.store) continue;
                                this.databaseSession.store(ifcProduct, this.pid, this.rid);
                                continue;
                            }
                            this.bigMap.get(ifcProduct).eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                            ifcProduct.eSet(GeometryGenerator.this.geometryFeature, (Object)geometryInfo);
                            if (!this.store) continue;
                            this.databaseSession.store(this.bigMap.get(ifcProduct), this.pid, this.rid);
                        }
                        catch (EntityNotFoundException e) {
                            boolean ignoreNotFound = true;
                            for (Object rep : representations) {
                                IfcShapeRepresentation ifcShapeRepresentation;
                                if (!(rep instanceof IfcShapeRepresentation) || "Curve2D".equals((ifcShapeRepresentation = (IfcShapeRepresentation)rep).getRepresentationType())) continue;
                                ignoreNotFound = false;
                            }
                            if (ignoreNotFound) continue;
                            LOGGER.info("Entity not found " + ifcProduct.eClass().getName() + " " + ifcProduct.getExpressId() + "/" + ifcProduct.getOid());
                        }
                        catch (BimserverDatabaseException | RenderEngineException e) {
                            LOGGER.error("", e);
                        }
                        catch (IfcModelInterfaceException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                }
                finally {
                    in.close();
                    renderEngineModel.close();
                }
                if (pool != null && renderEngine != null) {
                    pool.release(renderEngine);
                }
            }
            catch (IOException | InterruptedException | SerializerException | PluginException e) {
                LOGGER.error("", e);
            }
            finally {
                if (pool != null && renderEngine != null) {
                    pool.release(renderEngine);
                }
            }
        }
    }
}

