/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.file.Paths;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.resources.JarResourceFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarBimServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarBimServer.class);
    private BimServer bimServer;

    public static void main(String[] args) {
        String address = "127.0.0.1";
        String port = "8082";
        String homedir = "home";
        for (String arg : args) {
            if (arg.startsWith("address=")) {
                address = arg.substring(8);
                if (!address.startsWith("\"") || !address.endsWith("\"")) continue;
                address = address.substring(1, address.length() - 1);
                continue;
            }
            if (arg.startsWith("port=")) {
                port = arg.substring(5);
                if (!port.startsWith("\"") || !port.endsWith("\"")) continue;
                port = port.substring(1, port.length() - 1);
                continue;
            }
            if (!arg.startsWith("homedir=") || !(homedir = arg.substring(8)).startsWith("\"") || !homedir.endsWith("\"")) continue;
            homedir = homedir.substring(1, homedir.length() - 1);
        }
        JarBimServer server = new JarBimServer();
        server.start(address, Integer.parseInt(port), homedir, "www");
    }

    public void stop() {
        LOGGER.info("Stopping server...");
        try {
            this.bimServer.stop();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        LOGGER.info("Server stopped successfully");
    }

    public void start(String address, int port, String homedir, String resourceBase) {
        if (homedir.startsWith("\"") && homedir.endsWith("\"")) {
            homedir = homedir.substring(1, homedir.length() - 2);
        }
        System.setProperty("org.apache.cxf.Logger", "org.apache.cxf.common.logging.Log4jLogger");
        BimServerConfig bimServerConfig = new BimServerConfig();
        bimServerConfig.setHomeDir(Paths.get(homedir, new String[0]));
        bimServerConfig.setResourceFetcher(new JarResourceFetcher());
        bimServerConfig.setStartEmbeddedWebServer(true);
        bimServerConfig.setPort(port);
        bimServerConfig.setClassPath(System.getProperty("java.class.path"));
        this.bimServer = new BimServer(bimServerConfig);
        try {
            LOGGER.debug("Setting resourcebase to www");
            this.bimServer.getEmbeddedWebServer().getContext().setResourceBase("www");
            this.bimServer.start();
            LOGGER.info("Server started successfully");
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

