/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.util.Properties;
import org.bimserver.BimServer;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobScheduler.class);
    private static final int COMPARE_RESULT_CLEAN_INTERVAL_MILLIS = 1800000;
    private static final int LONG_ACTION_MANAGER_CLEANUP_INTERVAL_MILLIS = 60000;
    private SchedulerFactory sf;
    private Scheduler sched;

    public JobScheduler(BimServer bimServer) {
        try {
            Properties properties = new Properties();
            String instanceName = "UniqueName" + Math.random();
            properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            properties.setProperty("org.quartz.threadPool.threadCount", "1");
            properties.setProperty("org.quartz.scheduler.instanceName", instanceName);
            this.sf = new StdSchedulerFactory(properties);
            this.sched = this.sf.getScheduler();
            this.sched.getContext().put("bimserver", (Object)bimServer);
        }
        catch (SchedulerException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void start() {
        try {
            this.addRecurringJob(CompareResultCacheCleaner.class, 1800000);
            this.addRecurringJob(LongActionManagerCleaner.class, 60000);
            this.sched.start();
        }
        catch (SchedulerException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void addRecurringJob(Class<? extends Job> class1, int intervalMillis) throws SchedulerException {
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("group1", class1.getSimpleName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)intervalMillis).repeatForever()).build();
        JobDetail job = JobBuilder.newJob(class1).withIdentity("group1", class1.getSimpleName()).build();
        this.sched.scheduleJob(job, (Trigger)trigger);
    }

    public void close() {
        try {
            this.sched.shutdown();
        }
        catch (SchedulerException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static class LongActionManagerCleaner
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            try {
                BimServer bimServer = (BimServer)jobExecutionContext.getScheduler().getContext().get((Object)"bimserver");
                bimServer.getLongActionManager().cleanup();
            }
            catch (SchedulerException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public static class CompareResultCacheCleaner
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            try {
                BimServer bimServer = (BimServer)jobExecutionContext.getScheduler().getContext().get((Object)"bimserver");
                bimServer.getCompareCache().cleanup();
            }
            catch (SchedulerException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

