/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.bimserver.BimServer;
import org.bimserver.Recording;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.json.JsonConverter;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.reflector.KeyValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonHandler.class);
    private final BimServer bimServer;
    private final JsonConverter converter;

    public JsonHandler(BimServer bimServer) {
        this.bimServer = bimServer;
        this.converter = new JsonConverter(bimServer.getServicesMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JsonObject incomingMessage, HttpServletRequest httpRequest, Writer out) {
        JsonWriter jsonWriter = new JsonWriter(out);
        try {
            String token;
            jsonWriter.beginObject();
            String string = token = incomingMessage.has("token") ? incomingMessage.get("token").getAsString() : null;
            if (incomingMessage.has("request")) {
                jsonWriter.name("response");
                this.processSingleRequest(incomingMessage.getAsJsonObject("request"), token, httpRequest, jsonWriter);
            } else if (incomingMessage.has("requests")) {
                this.processMultiRequest(incomingMessage.getAsJsonArray("requests"), token, httpRequest, jsonWriter);
            }
        }
        catch (Throwable throwable) {
            this.handleThrowable(jsonWriter, throwable);
        }
        finally {
            try {
                jsonWriter.endObject();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private void processMultiRequest(JsonArray requests, String jsonToken, HttpServletRequest httpRequest, JsonWriter out) throws Exception {
        out.name("responses");
        out.beginArray();
        for (int r = 0; r < requests.size(); ++r) {
            try {
                this.processSingleRequest((JsonObject)requests.get(r), jsonToken, httpRequest, out);
                continue;
            }
            catch (Exception e) {
                this.handleThrowable(out, e);
            }
        }
        out.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleRequest(JsonObject request, String jsonToken, HttpServletRequest httpRequest, JsonWriter writer) throws Exception {
        long s = System.nanoTime();
        String interfaceName = request.get("interface").getAsString();
        String methodName = request.get("method").getAsString();
        SService sService = this.bimServer.getServicesMap().getByName(interfaceName);
        if (sService == null) {
            sService = this.bimServer.getServicesMap().getBySimpleName(interfaceName);
        }
        if (sService == null) {
            throw new UserException("No service found with name " + interfaceName);
        }
        SMethod method = sService.getSMethod(methodName);
        if (method == null) {
            SMethod alternative = this.bimServer.getServicesMap().findMethod(methodName);
            if (alternative == null) {
                throw new UserException("Method " + methodName + " not found on " + interfaceName);
            }
            throw new UserException("Method " + methodName + " not found on " + interfaceName + " (suggestion: " + alternative.getService().getSimpleName() + ")");
        }
        KeyValuePair[] parameters = new KeyValuePair[method.getParameters().size()];
        if (request.has("parameters")) {
            JsonObject parametersJson = request.getAsJsonObject("parameters");
            for (int i = 0; i < method.getParameters().size(); ++i) {
                SParameter parameter = method.getParameter(i);
                if (!parametersJson.has(parameter.getName())) {
                    LOGGER.error("Missing parameter: " + method.getName() + " -> " + parameter.getName());
                    throw new UserException("Missing parameter: " + method.getName() + " -> " + parameter.getName());
                }
                parameters[i] = new KeyValuePair(parameter.getName(), this.converter.fromJson(parameter.getType(), parameter.getGenericType(), (Object)parametersJson.get(parameter.getName())));
            }
        } else if (parameters.length > 0) {
            throw new UserException("Missing 'parameters' field, expected " + parameters.length + " parameters");
        }
        Object service = this.getServiceInterface(httpRequest, this.bimServer, sService.getInterfaceClass(), methodName, jsonToken);
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(interfaceName + "." + methodName);
        try {
            Recording recording = this.bimServer.getMetricsRegistry().startRecording(sService, method);
            Object result = method.invoke(sService.getInterfaceClass(), service, parameters);
            recording.finish();
            if (writer != null) {
                if (result == null) {
                    writer.beginObject();
                    writer.name("result");
                    writer.beginObject();
                    writer.endObject();
                    writer.endObject();
                } else {
                    writer.beginObject();
                    writer.name("result");
                    this.converter.toJson(result, writer);
                    writer.endObject();
                }
            }
            long e = System.nanoTime();
            LOGGER.debug(interfaceName + "." + methodName + " " + (e - s) / 1000000L + "ms");
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private void handleThrowable(JsonWriter writer, Throwable throwable) {
        if (!(throwable instanceof ServiceException)) {
            LoggerFactory.getLogger(JsonHandler.class).error("", throwable);
        } else if (LoggerFactory.getLogger(JsonHandler.class).isDebugEnabled()) {
            LoggerFactory.getLogger(JsonHandler.class).debug("", throwable);
        }
        try {
            ServiceException serviceException;
            writer.beginObject();
            writer.name("exception");
            writer.beginObject();
            writer.name("__type");
            writer.value(throwable.getClass().getSimpleName());
            writer.name("message");
            writer.value(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage());
            if (throwable instanceof ServiceException && (serviceException = (ServiceException)throwable).getErrorCode() != null) {
                writer.name("errorCode");
                writer.value((long)serviceException.getErrorCode().getCode());
            }
            writer.endObject();
            writer.endObject();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private <T extends PublicInterface> T getServiceInterface(HttpServletRequest httpRequest, BimServer bimServer, Class<T> interfaceClass, String methodName, String token) throws UserException, ServerException {
        if (methodName.equals("login") || methodName.equals("autologin")) {
            return bimServer.getServiceFactory().get(AccessMethod.JSON).get(interfaceClass);
        }
        if (token == null) {
            String string = token = httpRequest == null ? null : (String)httpRequest.getSession().getAttribute("token");
        }
        if (token == null) {
            return bimServer.getServiceFactory().get(AccessMethod.JSON).get(interfaceClass);
        }
        T service = bimServer.getServiceFactory().get(token, AccessMethod.JSON).get(interfaceClass);
        if (service == null) {
            service = bimServer.getServiceFactory().get(AccessMethod.JSON).get(interfaceClass);
            if (httpRequest != null) {
                httpRequest.getSession().setAttribute("token", (Object)token);
            }
        }
        return service;
    }

    public JsonConverter getJsonConverter() {
        return this.converter;
    }
}

