/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.LocalDevPluginLoader;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.plugins.OptionsParser;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.shared.LocalDevelopmentResourceFetcher;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDevBimServerStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDevBimServerStarter.class);
    private BimServer bimServer;

    public static void main(String[] args) {
        new LocalDevBimServerStarter().start(-1, "localhost", 8080, 8085, new OptionsParser(args).getPluginDirectories());
    }

    public void start(int id, String address, int port, int pbport, Path[] pluginDirectories) {
        BimServerConfig config = new BimServerConfig();
        config.setHomeDir(Paths.get("home" + (id == -1 ? "" : Integer.valueOf(id)), new String[0]));
        config.setResourceFetcher((ResourceFetcher)new LocalDevelopmentResourceFetcher(Paths.get("../", new String[0])));
        config.setStartEmbeddedWebServer(true);
        config.setClassPath(System.getProperty("java.class.path"));
        config.setLocalDev(true);
        config.setPort(port);
        config.setStartCommandLine(true);
        this.bimServer = new BimServer(config);
        this.bimServer.getVersionChecker().getLocalVersion().setDate(new Date());
        try {
            if (pluginDirectories == null || pluginDirectories.length == 0) {
                LOGGER.warn("No plugin directories given, this BIMserver will probably not work as expected, see https://github.com/opensourceBIM/BIMserver/wiki/Eclipse#adding-the-plugins-property");
            }
            LocalDevPluginLoader.loadPlugins(this.bimServer.getPluginManager(), pluginDirectories);
            this.bimServer.start();
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseInitException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseRestartRequiredException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }
}

