/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.bimserver.LocalDevPluginLoader;
import org.bimserver.client.json.JsonBimServerClientFactory;
import org.bimserver.client.protocolbuffers.ProtocolBuffersBimServerClientFactory;
import org.bimserver.client.soap.SoapBimServerClientFactory;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.plugins.OptionsParser;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.UsernamePasswordAuthenticationInfo;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDevSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDevSetup.class);

    public static void loadPlugins(PluginManager pluginManager, Path current, Path[] pluginDirectories) throws PluginException {
        LOGGER.info("Loading plugins from " + current.toString());
        if (pluginDirectories != null) {
            for (Path pluginDirectory : pluginDirectories) {
                try {
                    pluginManager.loadAllPluginsFromEclipseWorkspaces(pluginDirectory, false);
                }
                catch (PluginException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    public static final PluginManagerInterface setupPluginManager(String[] args) {
        try {
            Path tmp;
            Path home = Paths.get("home", new String[0]);
            if (!Files.exists(home, new LinkOption[0])) {
                Files.createDirectory(home, new FileAttribute[0]);
            }
            if (!Files.exists(tmp = home.resolve("tmp"), new LinkOption[0])) {
                Files.createDirectories(tmp, new FileAttribute[0]);
            }
            PluginManager pluginManager = new PluginManager(tmp, null, System.getProperty("java.class.path"), null, null, null);
            MetaDataManager metaDataManager = new MetaDataManager(tmp);
            pluginManager.setMetaDataManager(metaDataManager);
            LocalDevSetup.loadPlugins(pluginManager, Paths.get("..", new String[0]), new OptionsParser(args).getPluginDirectories());
            metaDataManager.init();
            pluginManager.initAllLoadedPlugins();
            return pluginManager;
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final BimServerClientInterface setupJson(String address) {
        try {
            Path home = Paths.get("home", new String[0]);
            if (!Files.isDirectory(home, new LinkOption[0])) {
                Files.createDirectory(home, new FileAttribute[0]);
            }
            Path tmp = home.resolve("tmp");
            PluginManager pluginManager = new PluginManager(tmp, null, System.getProperty("java.class.path"), null, null, null);
            pluginManager.loadAllPluginsFromEclipseWorkspace(Paths.get("../", new String[0]), true);
            MetaDataManager metaDataManager = new MetaDataManager(tmp);
            pluginManager.setMetaDataManager(metaDataManager);
            metaDataManager.init();
            pluginManager.initAllLoadedPlugins();
            JsonBimServerClientFactory factory = new JsonBimServerClientFactory(metaDataManager, address);
            return factory.create((AuthenticationInfo)new UsernamePasswordAuthenticationInfo("admin@bimserver.org", "admin"));
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ChannelConnectionException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    public static final BimServerClientInterface setupSoap(String address) {
        try {
            Path home = Paths.get("home", new String[0]);
            Path tmp = home.resolve("tmp");
            PluginManager pluginManager = LocalDevPluginLoader.createPluginManager(home);
            MetaDataManager metaDataManager = new MetaDataManager(tmp);
            pluginManager.setMetaDataManager(metaDataManager);
            SoapBimServerClientFactory factory = new SoapBimServerClientFactory(metaDataManager, address);
            return factory.create((AuthenticationInfo)new UsernamePasswordAuthenticationInfo("admin@bimserver.org", "admin"));
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ChannelConnectionException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    public static final BimServerClientInterface setupProtocolBuffers(String address) {
        try {
            Path home = Paths.get("home", new String[0]);
            Path tmp = home.resolve("tmp");
            PluginManager pluginManager = LocalDevPluginLoader.createPluginManager(home);
            MetaDataManager metaDataManager = new MetaDataManager(tmp);
            pluginManager.setMetaDataManager(metaDataManager);
            ProtocolBuffersBimServerClientFactory factory = new ProtocolBuffersBimServerClientFactory(address, 8000, 8000, null, metaDataManager);
            return factory.create((AuthenticationInfo)new UsernamePasswordAuthenticationInfo("admin@bimserver.org", "admin"));
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ChannelConnectionException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }
}

