/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.LocalDevBimServerStarter;
import org.bimserver.LocalDevPluginLoader;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ServerState;
import org.bimserver.plugins.OptionsParser;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.shared.LocalDevelopmentResourceFetcher;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLeakTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDevBimServerStarter.class);
    private BimServer bimServer;

    public static void main(String[] args) {
        new MemoryLeakTester().start(1, "localhost", 8080, 8085, new OptionsParser(args).getPluginDirectories());
    }

    public void start(int id, String address, int port, int pbport, Path[] pluginDirectories) {
        BimServerConfig config = new BimServerConfig();
        config.setHomeDir(Paths.get("home" + id, new String[0]));
        config.setResourceFetcher((ResourceFetcher)new LocalDevelopmentResourceFetcher(Paths.get("../", new String[0])));
        config.setStartEmbeddedWebServer(true);
        config.setClassPath(System.getProperty("java.class.path"));
        config.setStartCommandLine(false);
        config.setLocalDev(true);
        config.setPort(port);
        this.bimServer = new BimServer(config);
        this.bimServer.getVersionChecker().getLocalVersion().setDate(new Date());
        try {
            LocalDevPluginLoader.loadPlugins(this.bimServer.getPluginManager(), pluginDirectories);
            this.bimServer.start();
            if (this.bimServer.getServerInfo().getServerState() == ServerState.NOT_SETUP) {
                AdminInterface adminInterface = this.bimServer.getServiceFactory().get(new SystemAuthorization(1, TimeUnit.HOURS), AccessMethod.INTERNAL).get(AdminInterface.class);
                adminInterface.setup("http://localhost:" + port, "Administrator", "admin@bimserver.org", "admin");
                SettingsInterface settingsInterface = this.bimServer.getServiceFactory().get(new SystemAuthorization(1, TimeUnit.HOURS), AccessMethod.INTERNAL).get(SettingsInterface.class);
                settingsInterface.setCacheOutputFiles(Boolean.valueOf(false));
            }
            this.bimServer.stop();
            this.bimServer = null;
            Thread.sleep(1000000L);
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseInitException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseRestartRequiredException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

