/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ModelMergerPluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.modelmerger.MergeException;
import org.bimserver.plugins.modelmerger.ModelMerger;
import org.bimserver.plugins.modelmerger.ModelMergerPlugin;

public class MergerFactory {
    private final BimServer bimServer;

    public MergerFactory(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    public ModelMerger createMerger(DatabaseSession databaseSession, Long currentUoid) throws MergeException, BimserverDatabaseException {
        try (DatabaseSession session = this.bimServer.getDatabase().createSession();){
            User user = (User)databaseSession.get(StorePackage.eINSTANCE.getUser(), (long)currentUoid, (QueryInterface)OldQuery.getDefault());
            UserSettings userSettings = user.getUserSettings();
            ModelMergerPluginConfiguration modelMergerObject = userSettings.getDefaultModelMerger();
            if (modelMergerObject != null) {
                ModelMergerPlugin modelMergerPlugin = this.bimServer.getPluginManager().getModelMergerPlugin(modelMergerObject.getPluginDescriptor().getPluginClassName(), true);
                if (modelMergerPlugin != null) {
                    ModelMerger modelMerger;
                    ModelMerger modelMerger2 = modelMerger = modelMergerPlugin.createModelMerger(new PluginConfiguration(modelMergerObject.getSettings()));
                    return modelMerger2;
                }
                throw new MergeException("No Model Merger found " + modelMergerObject.getPluginDescriptor().getPluginClassName());
            }
            throw new MergeException("No configured Model Merger found");
        }
    }
}

