/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.util.HashMap;
import java.util.Map;
import org.bimserver.MethodStats;
import org.bimserver.Recording;
import org.bimserver.interfaces.objects.SInterfaceMetric;
import org.bimserver.interfaces.objects.SMethodMetric;
import org.bimserver.interfaces.objects.SMetrics;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SService;

public class MetricsRegistry {
    private final Map<SService, Map<SMethod, MethodStats>> methodStats = new HashMap<SService, Map<SMethod, MethodStats>>();

    public Recording startRecording(SService sService, SMethod method) {
        return new Recording(this, sService, method);
    }

    public synchronized MethodStats getMethodStats(SMethod sMethod) {
        MethodStats methodStats;
        Map<SMethod, MethodStats> map = this.methodStats.get(sMethod.getService());
        if (map == null) {
            map = new HashMap<SMethod, MethodStats>();
            this.methodStats.put(sMethod.getService(), map);
        }
        if ((methodStats = map.get(sMethod)) == null) {
            methodStats = new MethodStats(sMethod.getService(), sMethod);
            map.put(sMethod, methodStats);
        }
        return methodStats;
    }

    public synchronized SMetrics getMetrics() {
        SMetrics sMetrics = new SMetrics();
        for (SService sService : this.methodStats.keySet()) {
            SInterfaceMetric interfaceMetric = new SInterfaceMetric();
            interfaceMetric.setName(sService.getSimpleName());
            sMetrics.getInterfaces().add(interfaceMetric);
            for (SMethod sMethod : this.methodStats.get(sService).keySet()) {
                SMethodMetric sMethodMetric = new SMethodMetric();
                sMethodMetric.setName(sMethod.getName());
                interfaceMetric.getMethods().add(sMethodMetric);
                MethodStats methodStats = this.getMethodStats(sMethod);
                sMethodMetric.setNrCalls(Long.valueOf(methodStats.getNrCalls()));
                sMethodMetric.setAverageMs(Long.valueOf(methodStats.getAverageNanoSecondsPerCall() / 1000000L));
            }
        }
        return sMetrics;
    }
}

