/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.StorePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSettingsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSettingsCache.class);
    private BimDatabase database;
    private final Set<String> allowedHosts = new HashSet<String>();
    private boolean onlyWhitelistedDomains = false;
    private ServerSettings serverSettings;

    public ServerSettingsCache(BimDatabase database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCache() {
        try (DatabaseSession session = this.database.createSession();){
            this.serverSettings = (ServerSettings)session.getSingle(StorePackage.eINSTANCE.getServerSettings(), new OldQuery(session.getMetaDataManager().getPackageMetaData("store"), true));
            if (this.serverSettings.getSessionTimeOutSeconds() == 0) {
                this.serverSettings.setSessionTimeOutSeconds(2592000);
            }
            this.allowedHosts.clear();
            for (String domain : this.serverSettings.getWhitelistedDomains()) {
                this.allowedHosts.add(domain);
            }
        }
    }

    public boolean isHostAllowed(String address) {
        if (!this.onlyWhitelistedDomains) {
            return true;
        }
        if (address.startsWith("http://")) {
            address = address.substring(7);
        }
        return this.allowedHosts.contains(address);
    }

    public ServerSettings getServerSettings() {
        if (this.serverSettings == null) {
            this.updateCache();
        }
        return this.serverSettings;
    }

    public void init() {
        this.updateCache();
    }
}

