/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.GenerateGeometryResult;
import org.bimserver.GeometryGeneratingException;
import org.bimserver.ObjectListener;
import org.bimserver.ObjectProviderProxy;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ProgressListener;
import org.bimserver.database.queries.QueryObjectProvider;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.Schema;
import org.bimserver.geometry.Matrix;
import org.bimserver.geometry.Vector;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.renderengine.EntityNotFoundException;
import org.bimserver.plugins.renderengine.IndexFormat;
import org.bimserver.plugins.renderengine.Precision;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineFilter;
import org.bimserver.plugins.renderengine.RenderEngineGeometry;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineModel;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.renderengine.RenderEngineSettings;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.OidConvertingSerializer;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.plugins.serializers.StreamingSerializer;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.VirtualObject;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.Formatters;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingGeometryGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingGeometryGenerator.class);
    private final BimServer bimServer;
    private final Map<Integer, VirtualObject> hashes = new ConcurrentHashMap<Integer, VirtualObject>();
    private EClass productClass;
    private EStructuralFeature geometryFeature;
    private EStructuralFeature representationFeature;
    private PackageMetaData packageMetaData;
    private AtomicLong bytesSaved = new AtomicLong();
    private AtomicLong totalBytes = new AtomicLong();
    private AtomicInteger jobsDone = new AtomicInteger();
    private AtomicInteger jobsTotal = new AtomicInteger();
    private ProgressListener progressListener;

    public StreamingGeometryGenerator(BimServer bimServer, ProgressListener progressListener) {
        this.bimServer = bimServer;
        this.progressListener = progressListener;
    }

    private void updateProgress() {
        this.progressListener.updateProgress("Generating geometry", (int)(100.0 * (double)this.jobsDone.get() / (double)this.jobsTotal.get()));
    }

    public GenerateGeometryResult generateGeometry(long uoid, DatabaseSession databaseSession, QueryContext queryContext) throws BimserverDatabaseException, GeometryGeneratingException {
        GenerateGeometryResult generateGeometryResult = new GenerateGeometryResult();
        this.packageMetaData = queryContext.getPackageMetaData();
        this.productClass = this.packageMetaData.getEClass("IfcProduct");
        this.geometryFeature = this.productClass.getEStructuralFeature("geometry");
        this.representationFeature = this.productClass.getEStructuralFeature("Representation");
        long start = System.nanoTime();
        String pluginName = "";
        if (queryContext.getPackageMetaData().getSchema() == Schema.IFC4) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc4StepStreamingSerializerPlugin";
        } else if (queryContext.getPackageMetaData().getSchema() == Schema.IFC2X3TC1) {
            pluginName = "org.bimserver.ifc.step.serializer.Ifc2x3tc1StepStreamingSerializerPlugin";
        }
        try {
            StreamingSerializerPlugin ifcSerializerPlugin = (StreamingSerializerPlugin)this.bimServer.getPluginManager().getPlugin(pluginName, true);
            if (ifcSerializerPlugin == null) {
                throw new UserException("No IFC serializer found");
            }
            User user = (User)databaseSession.get(uoid, OldQuery.getDefault());
            UserSettings userSettings = user.getUserSettings();
            RenderEnginePluginConfiguration defaultRenderEngine = userSettings.getDefaultRenderEngine();
            if (defaultRenderEngine == null) {
                throw new UserException("No default render engine has been selected for this user");
            }
            RenderEnginePlugin renderEnginePlugin = this.bimServer.getPluginManager().getRenderEnginePlugin(defaultRenderEngine.getPluginDescriptor().getPluginClassName(), true);
            if (renderEnginePlugin == null) {
                throw new UserException("No (enabled) render engine found of type " + defaultRenderEngine.getPluginDescriptor().getPluginClassName());
            }
            int maxSimultanousThreads = Math.min(this.bimServer.getServerSettingsCache().getServerSettings().getRenderEngineProcesses(), Runtime.getRuntime().availableProcessors());
            if (maxSimultanousThreads < 1) {
                maxSimultanousThreads = 1;
            }
            RenderEngineSettings settings = new RenderEngineSettings();
            settings.setPrecision(Precision.SINGLE);
            settings.setIndexFormat(IndexFormat.AUTO_DETECT);
            settings.setGenerateNormals(true);
            settings.setGenerateTriangles(true);
            settings.setGenerateWireFrame(false);
            RenderEngineFilter renderEngineFilter = new RenderEngineFilter();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(maxSimultanousThreads, maxSimultanousThreads, 24L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(queryContext.getOidCounters().size()));
            for (EClass eClass : queryContext.getOidCounters().keySet()) {
                if (!this.packageMetaData.getEClass("IfcProduct").isSuperTypeOf(eClass)) continue;
                Query query = new Query("test", this.packageMetaData);
                QueryPart queryPart = query.createQueryPart();
                queryPart.addType(eClass, false);
                JsonQueryObjectModelConverter jsonQueryObjectModelConverter = new JsonQueryObjectModelConverter(this.packageMetaData);
                queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile("validifc:ContainedInStructure"));
                queryPart.addInclude(jsonQueryObjectModelConverter.getDefineFromFile("validifc:OwnerHistory"));
                Include representation = jsonQueryObjectModelConverter.getDefineFromFile("validifc:Representation");
                queryPart.addInclude(representation);
                Include objectPlacement = jsonQueryObjectModelConverter.getDefineFromFile("validifc:ObjectPlacement");
                queryPart.addInclude(objectPlacement);
                if (this.packageMetaData.getEClass("IfcWall").isSuperTypeOf(eClass)) {
                    Include ifcWall = queryPart.createInclude();
                    ifcWall.addType(this.packageMetaData.getEClass(eClass.getName()), false);
                    ifcWall.addField("HasOpenings");
                    Include hasOpenings = ifcWall.createInclude();
                    hasOpenings.addType(this.packageMetaData.getEClass("IfcRelVoidsElement"), false);
                    hasOpenings.addField("RelatedOpeningElement");
                    hasOpenings.addInclude(representation);
                    hasOpenings.addInclude(objectPlacement);
                }
                QueryObjectProvider queryObjectProvider = new QueryObjectProvider(databaseSession, this.bimServer, query, Collections.singleton(queryContext.getRoid()), this.packageMetaData);
                HashMapVirtualObject next = queryObjectProvider.next();
                query = new Query("test", this.packageMetaData);
                queryPart = query.createQueryPart();
                while (next != null) {
                    queryPart.addOid(next.getOid());
                    next = queryObjectProvider.next();
                }
                queryObjectProvider = new QueryObjectProvider(databaseSession, this.bimServer, query, Collections.singleton(queryContext.getRoid()), this.packageMetaData);
                Runner runner = new Runner(eClass, renderEnginePlugin, databaseSession, settings, queryObjectProvider, ifcSerializerPlugin, renderEngineFilter, generateGeometryResult, queryContext);
                executor.submit(runner);
                this.jobsTotal.incrementAndGet();
            }
            executor.shutdown();
            executor.awaitTermination(24L, TimeUnit.HOURS);
            long end = System.nanoTime();
            LOGGER.info("Rendertime: " + (end - start) / 1000000L + "ms, " + "Reused: " + Formatters.bytesToString((long)this.bytesSaved.get()) + ", Total: " + Formatters.bytesToString((long)this.totalBytes.get()) + ", Final: " + Formatters.bytesToString((long)(this.totalBytes.get() - this.bytesSaved.get())));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new GeometryGeneratingException(e);
        }
        return generateGeometryResult;
    }

    private long getSize(VirtualObject geometryData) {
        long size = 0L;
        if (geometryData.has("indices")) {
            size += (long)((byte[])geometryData.get("vertices")).length;
        }
        if (geometryData.has("vertices")) {
            size += (long)((byte[])geometryData.get("vertices")).length;
        }
        if (geometryData.has("normals")) {
            size += (long)((byte[])geometryData.get("normals")).length;
        }
        if (geometryData.has("materialIndices")) {
            size += (long)((byte[])geometryData.get("materialIndices")).length;
        }
        if (geometryData.has("materials")) {
            size += (long)((byte[])geometryData.get("materials")).length;
        }
        return size;
    }

    private int hash(VirtualObject geometryData) {
        int hashCode = 0;
        if (geometryData.has("indices")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("vertices"));
        }
        if (geometryData.has("vertices")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("vertices"));
        }
        if (geometryData.has("normals")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("normals"));
        }
        if (geometryData.has("materialIndices")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("materialIndices"));
        }
        if (geometryData.has("materials")) {
            hashCode += Arrays.hashCode((byte[])geometryData.get("materials"));
        }
        return hashCode;
    }

    private void processExtends(VirtualObject geometryInfo, double[] transformationMatrix, float[] vertices, int index, GenerateGeometryResult generateGeometryResult) throws BimserverDatabaseException {
        double x = vertices[index];
        double y = vertices[index + 1];
        double z = vertices[index + 2];
        double[] result = new double[4];
        Matrix.multiplyMV((double[])result, (int)0, (double[])transformationMatrix, (int)0, (double[])new double[]{x, y, z, 1.0}, (int)0);
        x = result[0];
        y = result[1];
        z = result[2];
        HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)geometryInfo.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBounds());
        HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)geometryInfo.eGet((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBounds());
        minBounds.set("x", (Object)Math.min(x, (double)((Float)minBounds.eGet("x")).floatValue()));
        minBounds.set("y", (Object)Math.min(y, (double)((Float)minBounds.eGet("y")).floatValue()));
        minBounds.set("z", (Object)Math.min(z, (double)((Float)minBounds.eGet("z")).floatValue()));
        maxBounds.set("x", (Object)Math.max(x, (double)((Float)maxBounds.eGet("x")).floatValue()));
        maxBounds.set("y", (Object)Math.max(y, (double)((Float)maxBounds.eGet("y")).floatValue()));
        maxBounds.set("z", (Object)Math.max(z, (double)((Float)maxBounds.eGet("z")).floatValue()));
        generateGeometryResult.getMinBounds().setX(Math.min(x, generateGeometryResult.getMinBounds().getX()));
        generateGeometryResult.getMinBounds().setY(Math.min(y, generateGeometryResult.getMinBounds().getY()));
        generateGeometryResult.getMinBounds().setZ(Math.min(z, generateGeometryResult.getMinBounds().getZ()));
        generateGeometryResult.getMaxBounds().setX(Math.max(x, generateGeometryResult.getMaxBounds().getX()));
        generateGeometryResult.getMaxBounds().setY(Math.max(y, generateGeometryResult.getMaxBounds().getY()));
        generateGeometryResult.getMaxBounds().setZ(Math.max(z, generateGeometryResult.getMaxBounds().getZ()));
    }

    private byte[] floatArrayToByteArray(float[] vertices) {
        if (vertices == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[vertices.length * 4]);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer asFloatBuffer = buffer.asFloatBuffer();
        for (float f : vertices) {
            asFloatBuffer.put(f);
        }
        return buffer.array();
    }

    private byte[] intArrayToByteArray(int[] indices) {
        if (indices == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[indices.length * 4]);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer asIntBuffer = buffer.asIntBuffer();
        for (int i : indices) {
            asIntBuffer.put(i);
        }
        return buffer.array();
    }

    private void setTransformationMatrix(VirtualObject geometryInfo, double[] transformationMatrix) throws BimserverDatabaseException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer asDoubleBuffer = byteBuffer.asDoubleBuffer();
        for (double f : transformationMatrix) {
            asDoubleBuffer.put(f);
        }
        geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Transformation(), (Object)byteBuffer.array());
    }

    private static boolean almostTheSame(float f1, float f2, float maxDiff) {
        return Math.abs(f1 - f2) < maxDiff;
    }

    private static float[] getTransformationMatrix(float[] originalV1, float[] originalV2, float[] originalV3, float[] u1, float[] u2, float[] u3, float maxDiff) {
        float[] v1 = StreamingGeometryGenerator.copy(originalV1);
        float[] v2 = StreamingGeometryGenerator.copy(originalV2);
        float[] v3 = StreamingGeometryGenerator.copy(originalV3);
        u1 = StreamingGeometryGenerator.copy(u1);
        u2 = StreamingGeometryGenerator.copy(u2);
        u3 = StreamingGeometryGenerator.copy(u3);
        float transX = u1[0] - v1[0];
        float transY = u1[1] - v1[1];
        float transZ = u1[2] - v1[2];
        float[] translation = new float[16];
        Matrix.setIdentityM((float[])translation, (int)0);
        Matrix.translateM((float[])translation, (int)0, (float)u1[0], (float)u1[1], (float)u1[2]);
        float[] toZeroTranslation = new float[16];
        Matrix.setIdentityM((float[])toZeroTranslation, (int)0);
        Matrix.translateM((float[])toZeroTranslation, (int)0, (float)(-v1[0]), (float)(-v1[1]), (float)(-v1[2]));
        if (StreamingGeometryGenerator.almostTheSame(v2[0] + transX, u2[0], maxDiff) && StreamingGeometryGenerator.almostTheSame(v2[1] + transY, u2[1], maxDiff) && StreamingGeometryGenerator.almostTheSame(v2[2] + transZ, u2[2], maxDiff) && StreamingGeometryGenerator.almostTheSame(v3[0] + transX, u3[0], maxDiff) && StreamingGeometryGenerator.almostTheSame(v3[1] + transY, u3[1], maxDiff) && StreamingGeometryGenerator.almostTheSame(v3[2] + transZ, u3[2], maxDiff)) {
            return translation;
        }
        StreamingGeometryGenerator.subtract(u2, u1);
        StreamingGeometryGenerator.subtract(u3, u1);
        StreamingGeometryGenerator.subtract(u1, u1);
        StreamingGeometryGenerator.subtract(v2, v1);
        StreamingGeometryGenerator.subtract(v3, v1);
        StreamingGeometryGenerator.subtract(v1, v1);
        float[] u2CrossV2 = Vector.crossProduct((float[])u2, (float[])v2);
        float[] r2 = new float[16];
        Matrix.setIdentityM((float[])r2, (int)0);
        float[] r2v2 = new float[4];
        if (!StreamingGeometryGenerator.equalsAlmost(u2, v2, maxDiff)) {
            float u2InV2 = Vector.dot((float[])u2, (float[])v2);
            float[] axis = u2CrossV2;
            if (axis[0] == 0.0f && axis[1] == 0.0f && axis[2] == 0.0f) {
                axis = new float[]{u2[1], -u2[0], 0.0f, 0.0f};
            }
            Matrix.rotateM((float[])r2, (int)0, (float)((float)Math.toDegrees(Math.atan2(Vector.length((float[])u2CrossV2), u2InV2))), (float)axis[0], (float)axis[1], (float)axis[2]);
            Matrix.multiplyMV((float[])r2v2, (int)0, (float[])r2, (int)0, (float[])new float[]{v2[0], v2[1], v2[2], 1.0f}, (int)0);
            if (!StreamingGeometryGenerator.equalsAlmost(r2v2, u2, maxDiff)) {
                Matrix.setIdentityM((float[])r2, (int)0);
                Matrix.rotateM((float[])r2, (int)0, (float)(-((float)Math.toDegrees(Math.atan2(Vector.length((float[])u2CrossV2), u2InV2)))), (float)axis[0], (float)axis[1], (float)axis[2]);
                Matrix.multiplyMV((float[])r2v2, (int)0, (float[])r2, (int)0, (float[])new float[]{v2[0], v2[1], v2[2], 1.0f}, (int)0);
                if (!StreamingGeometryGenerator.equalsAlmost(r2v2, u2, maxDiff)) {
                    return null;
                }
            }
        } else {
            r2v2 = StreamingGeometryGenerator.copy(v2);
        }
        float[] r2v3 = new float[4];
        Matrix.multiplyMV((float[])r2v3, (int)0, (float[])r2, (int)0, (float[])new float[]{v3[0], v3[1], v3[2], 1.0f}, (int)0);
        float[] r3 = new float[16];
        Matrix.setIdentityM((float[])r3, (int)0);
        float angleDegrees = (float)Math.toDegrees(StreamingGeometryGenerator.getPlaneAngle(v1, r2v2, r2v3, u1, u2, u3));
        Matrix.rotateM((float[])r3, (int)0, (float)angleDegrees, (float)r2v2[0], (float)r2v2[1], (float)r2v2[2]);
        float[] r3v3 = new float[4];
        Matrix.multiplyMV((float[])r3v3, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v3[0], r2v3[1], r2v3[2], 1.0f}, (int)0);
        float[] r2v1 = new float[4];
        Matrix.multiplyMV((float[])r2v1, (int)0, (float[])r2, (int)0, (float[])new float[]{v1[0], v1[1], v1[2], 1.0f}, (int)0);
        float[] r3v1 = new float[4];
        Matrix.multiplyMV((float[])r3v1, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v1[0], r2v1[1], r2v1[2], 1.0f}, (int)0);
        if (!StreamingGeometryGenerator.equalsAlmost(r3v3, u3, maxDiff)) {
            Matrix.setIdentityM((float[])r3, (int)0);
            Matrix.rotateM((float[])r3, (int)0, (float)(-angleDegrees), (float)r2v2[0], (float)r2v2[1], (float)r2v2[2]);
            Matrix.multiplyMV((float[])r3v3, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v3[0], r2v3[1], r2v3[2], 1.0f}, (int)0);
            float[] r3v2 = new float[4];
            Matrix.multiplyMV((float[])r3v2, (int)0, (float[])r3, (int)0, (float[])new float[]{r2v2[0], r2v2[1], r2v2[2], 1.0f}, (int)0);
            if (!StreamingGeometryGenerator.equalsAlmost(r3v3, u3, maxDiff) || !StreamingGeometryGenerator.equalsAlmost(r3v2, u2, maxDiff)) {
                return null;
            }
        }
        float[] subResult = new float[16];
        float[] subResult2 = new float[16];
        float[] subResult3 = new float[16];
        float[] totalResult = new float[16];
        float[] startMatrix = new float[16];
        Matrix.setIdentityM((float[])startMatrix, (int)0);
        Matrix.multiplyMM((float[])subResult, (int)0, (float[])toZeroTranslation, (int)0, (float[])startMatrix, (int)0);
        Matrix.multiplyMM((float[])subResult2, (int)0, (float[])r2, (int)0, (float[])subResult, (int)0);
        Matrix.multiplyMM((float[])subResult3, (int)0, (float[])r3, (int)0, (float[])subResult2, (int)0);
        Matrix.multiplyMM((float[])totalResult, (int)0, (float[])translation, (int)0, (float[])subResult3, (int)0);
        return totalResult;
    }

    private static double getPlaneAngle(float[] v1, float[] v2, float[] v3, float[] u1, float[] u2, float[] u3) {
        double result;
        float den;
        float[] cross1 = Vector.crossProduct((float[])new float[]{v2[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]}, (float[])new float[]{v3[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]});
        float[] fArray = new float[]{u2[0] - u1[0], u2[1] - u1[1], u2[2] - u1[2]};
        float[] fArray2 = new float[]{u3[0] - u1[0], u3[1] - u1[1], u3[2] - u1[2]};
        float[] cross2 = Vector.crossProduct((float[])fArray, (float[])fArray2);
        float num = Vector.dot((float[])cross1, (float[])cross2);
        float a = num / (den = Vector.length((float[])cross1) * Vector.length((float[])cross2));
        if (a > 1.0f) {
            a = 1.0f;
        }
        if (a < -1.0f) {
            a = -1.0f;
        }
        if (Double.isNaN(result = Math.acos(a))) {
            System.out.println();
        }
        return result;
    }

    private static boolean equalsAlmost(float[] r2v2, float[] u2, float maxDiff) {
        for (int i = 0; i < 3; ++i) {
            if (StreamingGeometryGenerator.almostTheSame(r2v2[i], u2[i], maxDiff)) continue;
            return false;
        }
        return true;
    }

    private static float[] copy(float[] v1) {
        float[] result = new float[v1.length];
        System.arraycopy(v1, 0, result, 0, v1.length);
        return result;
    }

    private static boolean test(float[] v1, float[] v2, float[] transformationMatrix, float maxDiff) {
        float[] resultVector = new float[4];
        Matrix.multiplyMV((float[])resultVector, (int)0, (float[])transformationMatrix, (int)0, (float[])new float[]{v1[0], v1[1], v1[2], 1.0f}, (int)0);
        StreamingGeometryGenerator.normalize(resultVector);
        boolean theSame = true;
        for (int i = 0; i < 3; ++i) {
            if (StreamingGeometryGenerator.almostTheSame(resultVector[i], v2[i], maxDiff)) continue;
            theSame = false;
        }
        if (!theSame) {
            System.out.println("Difference");
            Vector.dump((String)"Was", (float[])v1);
            Vector.dump((String)"Became", (float[])resultVector);
            Vector.dump((String)"Should be", (float[])v2);
            System.out.println();
            return false;
        }
        return true;
    }

    private static void normalize(float[] resultVector) {
        resultVector[0] = resultVector[0] * resultVector[3];
        resultVector[1] = resultVector[1] * resultVector[3];
        resultVector[2] = resultVector[2] * resultVector[3];
        resultVector[3] = 1.0f;
    }

    private static void subtract(float[] u2, float[] v1) {
        u2[0] = u2[0] - v1[0];
        u2[1] = u2[1] - v1[1];
        u2[2] = u2[2] - v1[2];
    }

    public static void main(String[] args) {
        float maxDiff = 0.1f;
        StreamingGeometryGenerator.test1(maxDiff);
        StreamingGeometryGenerator.test2(maxDiff);
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            float[] matrix = new float[16];
            Matrix.setIdentityM((float[])matrix, (int)0);
            for (int j = 0; j < 10; ++j) {
                Matrix.rotateM((float[])matrix, (int)0, (float)(random.nextFloat() * 360.0f), (float)random.nextFloat(), (float)random.nextFloat(), (float)random.nextFloat());
            }
            float[] v1 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] v2 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] v3 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
            float[] r1 = new float[4];
            float[] r2 = new float[4];
            float[] r3 = new float[4];
            Matrix.multiplyMV((float[])r1, (int)0, (float[])matrix, (int)0, (float[])v1, (int)0);
            Matrix.multiplyMV((float[])r2, (int)0, (float[])matrix, (int)0, (float[])v2, (int)0);
            Matrix.multiplyMV((float[])r3, (int)0, (float[])matrix, (int)0, (float[])v3, (int)0);
            float[] calculatedMatrix = StreamingGeometryGenerator.getTransformationMatrix(v1, v2, v3, r1, r2, r3, maxDiff);
            StreamingGeometryGenerator.test(v1, r1, calculatedMatrix, maxDiff);
            StreamingGeometryGenerator.test(v2, r2, calculatedMatrix, maxDiff);
            StreamingGeometryGenerator.test(v3, r3, calculatedMatrix, maxDiff);
            for (int j = 0; j < 10; ++j) {
                float[] q1 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] q2 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] q3 = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), 1.0f};
                float[] b1 = new float[4];
                float[] b2 = new float[4];
                float[] b3 = new float[4];
                Matrix.multiplyMV((float[])b1, (int)0, (float[])matrix, (int)0, (float[])q1, (int)0);
                Matrix.multiplyMV((float[])b2, (int)0, (float[])matrix, (int)0, (float[])q2, (int)0);
                Matrix.multiplyMV((float[])b3, (int)0, (float[])matrix, (int)0, (float[])q3, (int)0);
                StreamingGeometryGenerator.test(q1, b1, calculatedMatrix, maxDiff);
                StreamingGeometryGenerator.test(q2, b2, calculatedMatrix, maxDiff);
                StreamingGeometryGenerator.test(q3, b3, calculatedMatrix, maxDiff);
            }
        }
    }

    private static void test1(float maxDiff) {
        float[] v1 = new float[]{1.0f, 2.0f, 0.0f};
        float[] v2 = new float[]{1.0f, 1.0f, 0.0f};
        float[] v3 = new float[]{3.0f, 2.0f, 0.0f};
        float[] u1 = new float[]{0.0f, 2.0f, 0.0f};
        float[] u2 = new float[]{-1.0f, 2.0f, 0.0f};
        float[] u3 = new float[]{0.0f, 2.0f, 2.0f};
        float[] transformationMatrix = StreamingGeometryGenerator.getTransformationMatrix(v1, v2, v3, u1, u2, u3, maxDiff);
        StreamingGeometryGenerator.test(v1, u1, transformationMatrix, maxDiff);
        StreamingGeometryGenerator.test(v2, u2, transformationMatrix, maxDiff);
        StreamingGeometryGenerator.test(v3, u3, transformationMatrix, maxDiff);
    }

    private static void test2(float maxDiff) {
        float[] v1 = new float[]{3.0f, 0.0f, 0.0f};
        float[] v2 = new float[]{4.0f, 0.0f, 0.0f};
        float[] v3 = new float[]{4.0f, 1.0f, 0.0f};
        float[] u1 = new float[]{1.0f, 3.0f, 0.0f};
        float[] u2 = new float[]{0.0f, 3.0f, 0.0f};
        float[] u3 = new float[]{0.0f, 2.0f, 0.0f};
        float[] transformationMatrix = StreamingGeometryGenerator.getTransformationMatrix(v1, v2, v3, u1, u2, u3, maxDiff);
        StreamingGeometryGenerator.test(v1, u1, transformationMatrix, maxDiff);
        StreamingGeometryGenerator.test(v2, u2, transformationMatrix, maxDiff);
        StreamingGeometryGenerator.test(v3, u3, transformationMatrix, maxDiff);
    }

    public class Runner
    implements Runnable {
        private EClass eClass;
        private RenderEnginePlugin renderEnginePlugin;
        private RenderEngineSettings renderEngineSettings;
        private RenderEngineFilter renderEngineFilter;
        private RenderEngineFilter renderEngineFilterTransformed = new RenderEngineFilter(true);
        private StreamingSerializerPlugin ifcSerializerPlugin;
        private GenerateGeometryResult generateGeometryResult;
        private ObjectProvider objectProvider;
        private QueryContext queryContext;

        public Runner(EClass eClass, RenderEnginePlugin renderEnginePlugin, DatabaseSession databaseSession, RenderEngineSettings renderEngineSettings, ObjectProvider objectProvider, StreamingSerializerPlugin ifcSerializerPlugin, RenderEngineFilter renderEngineFilter, GenerateGeometryResult generateGeometryResult, QueryContext queryContext) {
            this.eClass = eClass;
            this.renderEnginePlugin = renderEnginePlugin;
            this.renderEngineSettings = renderEngineSettings;
            this.objectProvider = objectProvider;
            this.ifcSerializerPlugin = ifcSerializerPlugin;
            this.renderEngineFilter = renderEngineFilter;
            this.generateGeometryResult = generateGeometryResult;
            this.queryContext = queryContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StreamingSerializer ifcSerializer = this.ifcSerializerPlugin.createSerializer(new PluginConfiguration());
            try (RenderEngine renderEngine = this.renderEnginePlugin.createRenderEngine(new PluginConfiguration(), this.queryContext.getPackageMetaData().getSchema().getEPackageName());){
                renderEngine.init();
                final HashSet oids = new HashSet();
                ObjectProviderProxy proxy = new ObjectProviderProxy(this.objectProvider, new ObjectListener(){

                    @Override
                    public void newObject(HashMapVirtualObject next) {
                        if (Runner.this.eClass.isSuperTypeOf(next.eClass())) {
                            oids.add(next);
                        }
                    }
                });
                ifcSerializer.init((ObjectProvider)proxy, null, null, (PluginManagerInterface)StreamingGeometryGenerator.this.bimServer.getPluginManager(), StreamingGeometryGenerator.this.packageMetaData);
                boolean debug = true;
                InputStream in = null;
                if (debug) {
                    File file = new File((this.eClass == null ? "all" : this.eClass.getName()) + ".ifc");
                    FileOutputStream fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)ifcSerializer.getInputStream(), (OutputStream)fos);
                    fos.close();
                    in = new FileInputStream(file);
                } else {
                    in = ifcSerializer.getInputStream();
                }
                RenderEngineModel renderEngineModel = renderEngine.openModel(in);
                try {
                    renderEngineModel.setSettings(this.renderEngineSettings);
                    renderEngineModel.setFilter(this.renderEngineFilter);
                    renderEngineModel.generateGeneralGeometry();
                    OidConvertingSerializer oidConvertingSerializer = (OidConvertingSerializer)ifcSerializer;
                    Map oidToEid = oidConvertingSerializer.getOidToEid();
                    for (HashMapVirtualObject ifcProduct : oids) {
                        Integer expressId = (Integer)oidToEid.get(ifcProduct.getOid());
                        if (ifcProduct.eGet(StreamingGeometryGenerator.this.representationFeature) == null) continue;
                        try {
                            RenderEngineInstance renderEngineInstance = renderEngineModel.getInstanceFromExpressId(expressId.intValue());
                            RenderEngineGeometry geometry = renderEngineInstance.generateGeometry();
                            boolean translate = true;
                            if (geometry == null || geometry.getIndices().length == 0) {
                                renderEngineModel.setFilter(this.renderEngineFilterTransformed);
                                geometry = renderEngineInstance.generateGeometry();
                                if (geometry != null) {
                                    translate = false;
                                }
                                renderEngineModel.setFilter(this.renderEngineFilter);
                            }
                            if (geometry == null || geometry.getNrIndices() <= 0) continue;
                            HashMapVirtualObject geometryInfo = new HashMapVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getGeometryInfo());
                            HashMapWrappedVirtualObject minBounds = new HashMapWrappedVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getVector3f());
                            HashMapWrappedVirtualObject maxBounds = new HashMapWrappedVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getVector3f());
                            minBounds.set("x", (Object)Float.valueOf(Float.POSITIVE_INFINITY));
                            minBounds.set("y", (Object)Float.valueOf(Float.POSITIVE_INFINITY));
                            minBounds.set("z", (Object)Float.valueOf(Float.POSITIVE_INFINITY));
                            maxBounds.set("x", (Object)Float.valueOf(Float.POSITIVE_INFINITY));
                            maxBounds.set("y", (Object)Float.valueOf(Float.POSITIVE_INFINITY));
                            maxBounds.set("z", (Object)Float.valueOf(Float.POSITIVE_INFINITY));
                            geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MinBounds(), (Object)minBounds);
                            geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_MaxBounds(), (Object)maxBounds);
                            HashMapVirtualObject geometryData = new HashMapVirtualObject(this.queryContext, GeometryPackage.eINSTANCE.getGeometryData());
                            geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Indices(), (Object)StreamingGeometryGenerator.this.intArrayToByteArray(geometry.getIndices()));
                            geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Vertices(), (Object)StreamingGeometryGenerator.this.floatArrayToByteArray(geometry.getVertices()));
                            geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_MaterialIndices(), (Object)StreamingGeometryGenerator.this.intArrayToByteArray(geometry.getMaterialIndices()));
                            geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Normals(), (Object)StreamingGeometryGenerator.this.floatArrayToByteArray(geometry.getNormals()));
                            geometryInfo.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_PrimitiveCount(), (Object)(geometry.getIndices().length / 3));
                            if (geometry.getMaterialIndices() != null && geometry.getMaterialIndices().length > 0) {
                                boolean hasMaterial = false;
                                float[] vertex_colors = new float[geometry.getVertices().length / 3 * 4];
                                for (int i = 0; i < geometry.getMaterialIndices().length; ++i) {
                                    int c = geometry.getMaterialIndices()[i];
                                    for (int j = 0; j < 3; ++j) {
                                        int k = geometry.getIndices()[i * 3 + j];
                                        if (c <= -1) continue;
                                        hasMaterial = true;
                                        for (int l = 0; l < 4; ++l) {
                                            vertex_colors[4 * k + l] = geometry.getMaterials()[4 * c + l];
                                        }
                                    }
                                }
                                if (hasMaterial) {
                                    geometryData.setAttribute((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryData_Materials(), (Object)StreamingGeometryGenerator.this.floatArrayToByteArray(vertex_colors));
                                }
                            }
                            double[] tranformationMatrix = new double[16];
                            if (translate && renderEngineInstance.getTransformationMatrix() != null) {
                                tranformationMatrix = renderEngineInstance.getTransformationMatrix();
                            } else {
                                Matrix.setIdentityM((double[])tranformationMatrix, (int)0);
                            }
                            for (int i = 0; i < geometry.getIndices().length; ++i) {
                                StreamingGeometryGenerator.this.processExtends((VirtualObject)geometryInfo, tranformationMatrix, geometry.getVertices(), geometry.getIndices()[i] * 3, this.generateGeometryResult);
                            }
                            geometryInfo.setReference((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Data(), geometryData.getOid(), 0);
                            long size = StreamingGeometryGenerator.this.getSize((VirtualObject)geometryData);
                            StreamingGeometryGenerator.this.setTransformationMatrix((VirtualObject)geometryInfo, tranformationMatrix);
                            if (StreamingGeometryGenerator.this.bimServer.getServerSettingsCache().getServerSettings().isReuseGeometry()) {
                                int hash = StreamingGeometryGenerator.this.hash((VirtualObject)geometryData);
                                if (StreamingGeometryGenerator.this.hashes.containsKey(hash)) {
                                    geometryInfo.setReference((EStructuralFeature)GeometryPackage.eINSTANCE.getGeometryInfo_Data(), ((VirtualObject)StreamingGeometryGenerator.this.hashes.get(hash)).getOid(), 0);
                                    StreamingGeometryGenerator.this.bytesSaved.addAndGet(size);
                                } else {
                                    StreamingGeometryGenerator.this.hashes.put(hash, geometryData);
                                    geometryData.save();
                                }
                            } else {
                                geometryData.save();
                            }
                            geometryInfo.save();
                            StreamingGeometryGenerator.this.totalBytes.addAndGet(size);
                            ifcProduct.setReference(StreamingGeometryGenerator.this.geometryFeature, geometryInfo.getOid(), 0);
                            ifcProduct.saveOverwrite();
                        }
                        catch (EntityNotFoundException e) {
                            boolean ignoreNotFound = false;
                            if (ignoreNotFound) continue;
                            LOGGER.info("Entity not found " + ifcProduct.eClass().getName() + " " + expressId + "/" + ifcProduct.getOid());
                        }
                        catch (BimserverDatabaseException | RenderEngineException e) {
                            LOGGER.error("", e);
                        }
                    }
                }
                finally {
                    in.close();
                    renderEngineModel.close();
                    StreamingGeometryGenerator.this.jobsDone.incrementAndGet();
                    StreamingGeometryGenerator.this.updateProgress();
                }
            }
            catch (IOException | RenderEngineException | SerializerException e) {
                LOGGER.error("", e);
            }
        }
    }
}

