/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.util.Map;
import java.util.TreeMap;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.EClassNameComparator;
import org.bimserver.database.DatabaseSession;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.store.RevisionSummary;
import org.bimserver.models.store.RevisionSummaryContainer;
import org.bimserver.models.store.RevisionSummaryType;
import org.eclipse.emf.ecore.EClass;

public class SummaryMap {
    private final Map<EClass, Integer> summaryMap;
    private final PackageMetaData packageMetaData;

    public SummaryMap(IfcModelInterface model) throws BimserverDatabaseException {
        this.packageMetaData = model.getPackageMetaData();
        this.summaryMap = new TreeMap<EClass, Integer>(new EClassNameComparator());
        for (IdEObject idEObject : model.getValues()) {
            if (!this.summaryMap.containsKey(idEObject.eClass())) {
                this.summaryMap.put(idEObject.eClass(), 1);
                continue;
            }
            this.summaryMap.put(idEObject.eClass(), this.summaryMap.get(idEObject.eClass()) + 1);
        }
    }

    public SummaryMap(PackageMetaData packageMetaData) {
        this.summaryMap = new TreeMap<EClass, Integer>(new EClassNameComparator());
        this.packageMetaData = packageMetaData;
    }

    public SummaryMap(PackageMetaData packageMetaData, RevisionSummary revisionSummary) {
        this.packageMetaData = packageMetaData;
        this.summaryMap = new TreeMap<EClass, Integer>(new EClassNameComparator());
        for (RevisionSummaryContainer revisionSummaryContainer : revisionSummary.getList()) {
            for (RevisionSummaryType revisionSummaryType : revisionSummaryContainer.getTypes()) {
                this.summaryMap.put((EClass)packageMetaData.getEPackage().getEClassifier(revisionSummaryType.getName()), revisionSummaryType.getCount());
            }
        }
    }

    public SummaryMap(PackageMetaData packageMetaData, Map<EClass, Integer> summaryMap) {
        this.packageMetaData = packageMetaData;
        this.summaryMap = summaryMap;
    }

    public void remove(EClass eClass, int count) {
        if (count == 0) {
            return;
        }
        if (!this.summaryMap.containsKey(eClass)) {
            this.summaryMap.put(eClass, 0);
        } else {
            this.summaryMap.put(eClass, this.summaryMap.get(eClass) - count);
        }
    }

    public void add(EClass eClass, int count) {
        if (count == 0) {
            return;
        }
        if (!this.summaryMap.containsKey(eClass)) {
            this.summaryMap.put(eClass, count);
        } else {
            this.summaryMap.put(eClass, this.summaryMap.get(eClass) + count);
        }
    }

    public RevisionSummary toRevisionSummary(DatabaseSession databaseSession) throws BimserverDatabaseException {
        RevisionSummary revisionSummary = databaseSession.create(RevisionSummary.class);
        RevisionSummaryContainer revisionSummaryContainerEntities = databaseSession.create(RevisionSummaryContainer.class);
        revisionSummaryContainerEntities.setName("IFC Entities");
        revisionSummary.getList().add((Object)revisionSummaryContainerEntities);
        RevisionSummaryContainer revisionSummaryContainerRelations = databaseSession.create(RevisionSummaryContainer.class);
        revisionSummaryContainerRelations.setName("IFC Relations");
        revisionSummary.getList().add((Object)revisionSummaryContainerRelations);
        RevisionSummaryContainer revisionSummaryContainerPrimitives = databaseSession.create(RevisionSummaryContainer.class);
        revisionSummaryContainerPrimitives.setName("IFC Primitives");
        revisionSummary.getList().add((Object)revisionSummaryContainerPrimitives);
        RevisionSummaryContainer revisionSummaryContainerOther = databaseSession.create(RevisionSummaryContainer.class);
        revisionSummaryContainerOther.setName("Rest");
        revisionSummary.getList().add((Object)revisionSummaryContainerOther);
        for (EClass eClass : this.summaryMap.keySet()) {
            RevisionSummaryContainer subMap = null;
            subMap = ((EClass)this.packageMetaData.getEPackage().getEClassifier("IfcObject")).isSuperTypeOf(eClass) ? revisionSummaryContainerEntities : (((EClass)this.packageMetaData.getEPackage().getEClassifier("IfcRelationship")).isSuperTypeOf(eClass) ? revisionSummaryContainerRelations : (eClass.getEAnnotation("wrapped") != null ? revisionSummaryContainerPrimitives : revisionSummaryContainerOther));
            RevisionSummaryType createRevisionSummaryType = databaseSession.create(RevisionSummaryType.class);
            createRevisionSummaryType.setSchema(eClass.getEPackage().getName());
            createRevisionSummaryType.setCount(this.summaryMap.get(eClass));
            createRevisionSummaryType.setName(eClass.getName());
            subMap.getTypes().add((Object)createRevisionSummaryType);
        }
        return revisionSummary;
    }

    public int count(EClass eClass) {
        if (this.summaryMap.containsKey(eClass)) {
            return this.summaryMap.get(eClass);
        }
        return 0;
    }
}

