/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ServerSettingsSetter;
import org.bimserver.database.actions.SetServerSettingDatabaseAction;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.WebModulePluginConfiguration;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public class WebModuleManager {
    private BimServer bimServer;

    public WebModuleManager(BimServer bimServer) {
        this.bimServer = bimServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefault(Long oid) throws BimserverDatabaseException, UserException, ServerException {
        try (DatabaseSession session = this.bimServer.getDatabase().createSession();){
            final WebModulePluginConfiguration defaultWebModule = (WebModulePluginConfiguration)session.get(StorePackage.eINSTANCE.getWebModulePluginConfiguration(), (long)oid, (QueryInterface)OldQuery.getDefault());
            this.bimServer.setDefaultWebModule((WebModulePlugin)this.bimServer.getPluginManager().getPlugin(defaultWebModule.getPluginDescriptor().getPluginClassName(), true));
            SetServerSettingDatabaseAction action = new SetServerSettingDatabaseAction(this.bimServer, session, AccessMethod.INTERNAL, new ServerSettingsSetter(){

                @Override
                public void set(ServerSettings serverSettings) {
                    serverSettings.setWebModule(defaultWebModule);
                }
            });
            session.executeAndCommitAction(action);
        }
    }
}

