/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import org.bimserver.cache.GenericCache;
import org.bimserver.cache.GenericCacheKey;
import org.bimserver.cache.GenericCacheValue;
import org.bimserver.models.store.CompareResult;
import org.bimserver.models.store.CompareType;

public class CompareCache
extends GenericCache<CompareKey, CompareValue> {
    private static final int MAX_UNACCESSED_TIME_MS = 1800000;

    public CompareResult getCompareResults(long roid1, long roid2, CompareType sCompareType) {
        CompareValue compareValue = (CompareValue)this.getValue(new CompareKey(roid1, roid2, sCompareType));
        if (compareValue != null) {
            compareValue.access();
            return compareValue.getCompareResults();
        }
        return null;
    }

    public void storeResults(long roid1, long roid2, CompareType sCompareType, CompareResult compareResults) {
        this.store(new CompareKey(roid1, roid2, sCompareType), new CompareValue(compareResults));
    }

    public static class CompareValue
    extends GenericCacheValue {
        private final CompareResult compareResults;

        public CompareValue(CompareResult compareResults) {
            super(1800000);
            this.compareResults = compareResults;
        }

        public CompareResult getCompareResults() {
            return this.compareResults;
        }
    }

    public static class CompareKey
    extends GenericCacheKey {
        private final long roid1;
        private final long roid2;
        private final CompareType sCompareType;

        public CompareKey(long roid1, long roid2, CompareType sCompareType) {
            this.roid1 = roid1;
            this.roid2 = roid2;
            this.sCompareType = sCompareType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.roid1 ^ this.roid1 >>> 32);
            result = 31 * result + (int)(this.roid2 ^ this.roid2 >>> 32);
            result = 31 * result + (this.sCompareType == null ? 0 : this.sCompareType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompareKey other = (CompareKey)obj;
            if (this.roid1 != other.roid1) {
                return false;
            }
            if (this.roid2 != other.roid2) {
                return false;
            }
            return !(this.sCompareType == null ? other.sCompareType != null : !this.sCompareType.equals((Object)other.sCompareType));
        }
    }
}

