/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import org.bimserver.BimServer;
import org.bimserver.cache.DiskCacheOutputStream;
import org.bimserver.cache.FileInputStreamDataSource;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskCacheManager.class);
    private final Path cacheDir;
    private final BimServer bimServer;
    private final Set<String> cachedFileNames = new HashSet<String>();
    private final Map<DownloadParameters, DiskCacheOutputStream> busyCaching = new HashMap<DownloadParameters, DiskCacheOutputStream>();

    public DiskCacheManager(BimServer bimServer, Path cacheDir) {
        this.bimServer = bimServer;
        this.cacheDir = cacheDir;
        try {
            if (!Files.exists(cacheDir, new LinkOption[0])) {
                Files.createDirectory(cacheDir, new FileAttribute[0]);
            }
            for (Path file : PathUtils.list((Path)this.cacheDir)) {
                if (file.getFileName().toString().endsWith(".__tmp")) {
                    Files.delete(file);
                    continue;
                }
                this.cachedFileNames.add(file.getFileName().toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(DownloadParameters downloadParameters) {
        if (this.isEnabled()) {
            Object object = this.busyCaching;
            synchronized (object) {
                if (this.busyCaching.containsKey(downloadParameters)) {
                    return true;
                }
            }
            object = this.cachedFileNames;
            synchronized (object) {
                return this.cachedFileNames.contains(downloadParameters.getId());
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.bimServer.getServerSettingsCache().getServerSettings().getCacheOutputFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource get(DownloadParameters downloadParameters) {
        if (this.isEnabled()) {
            Path file;
            DiskCacheOutputStream diskCacheOutputStream = null;
            Map<DownloadParameters, DiskCacheOutputStream> map = this.busyCaching;
            synchronized (map) {
                diskCacheOutputStream = this.busyCaching.get(downloadParameters);
            }
            if (diskCacheOutputStream != null) {
                try {
                    LOGGER.info("Waiting for " + downloadParameters.getFileName());
                    diskCacheOutputStream.waitForFinish();
                }
                catch (InterruptedException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            if (!Files.exists(file = this.cacheDir.resolve(downloadParameters.getId()), new LinkOption[0])) {
                LOGGER.error("File " + file.getFileName().toString() + " not found in cache");
            } else {
                LOGGER.info("Reading from cache " + downloadParameters.getFileName());
                FileInputStreamDataSource fileInputStreamDataSource = new FileInputStreamDataSource(file);
                fileInputStreamDataSource.setName(downloadParameters.getFileNameWithoutExtension());
                return fileInputStreamDataSource;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskCacheOutputStream startCaching(DownloadParameters downloadParameters) {
        try {
            LOGGER.info("Start caching " + downloadParameters.getFileName());
            DiskCacheOutputStream out = new DiskCacheOutputStream(this, this.cacheDir.resolve(downloadParameters.getId()), downloadParameters);
            Map<DownloadParameters, DiskCacheOutputStream> map = this.busyCaching;
            synchronized (map) {
                this.busyCaching.put(downloadParameters, out);
            }
            return out;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public synchronized Integer cleanup() {
        int removed = 0;
        try {
            for (Path file : PathUtils.list((Path)this.cacheDir)) {
                try {
                    Files.delete(file);
                    ++removed;
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.cachedFileNames.clear();
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneGenerating(DiskCacheOutputStream diskCacheOutputStream) {
        Map<DownloadParameters, DiskCacheOutputStream> map = this.busyCaching;
        synchronized (map) {
            LOGGER.info("Done caching " + diskCacheOutputStream.getDownloadParameters().getFileName());
            this.busyCaching.remove(diskCacheOutputStream.getDownloadParameters());
            this.cachedFileNames.add(diskCacheOutputStream.getDownloadParameters().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DiskCacheOutputStream diskCacheOutputStream) {
        LOGGER.info("Removing cache " + diskCacheOutputStream.getDownloadParameters().getFileName());
        this.cachedFileNames.remove(diskCacheOutputStream.getDownloadParameters().getId());
        Map<DownloadParameters, DiskCacheOutputStream> map = this.busyCaching;
        synchronized (map) {
            this.busyCaching.remove(diskCacheOutputStream.getDownloadParameters());
        }
    }
}

