/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bimserver.cache.DiskCacheManager;
import org.bimserver.longaction.DownloadParameters;
import org.bimserver.plugins.serializers.RemovableFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCacheOutputStream
extends RemovableFileOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskCacheOutputStream.class);
    private DiskCacheManager diskCacheManager;
    private Path file;
    private Path tempFile;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final DownloadParameters downloadParameters;

    public DiskCacheOutputStream(DiskCacheManager diskCacheManager, Path file, DownloadParameters downloadParameters) throws FileNotFoundException {
        super(file.getParent().resolve(file.getFileName().toString() + ".__tmp"));
        this.tempFile = file.getParent().resolve(file.getFileName().toString() + ".__tmp");
        this.diskCacheManager = diskCacheManager;
        this.file = file;
        this.downloadParameters = downloadParameters;
    }

    public DownloadParameters getDownloadParameters() {
        return this.downloadParameters;
    }

    public void waitForFinish() throws InterruptedException {
        this.latch.await(30L, TimeUnit.MINUTES);
    }

    public void close() throws IOException {
        super.close();
        LOGGER.info("Renaming temp file " + this.tempFile.getFileName().toString() + " to " + this.file.getFileName().toString());
        Files.move(this.tempFile, this.file, new CopyOption[0]);
        this.diskCacheManager.doneGenerating(this);
        this.latch.countDown();
    }

    public void remove() throws IOException {
        super.remove();
        if (Files.exists(this.tempFile, new LinkOption[0])) {
            Files.delete(this.tempFile);
        }
        this.diskCacheManager.remove(this);
        this.latch.countDown();
    }

    public String getName() {
        return this.file.getFileName().toString();
    }
}

