/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.plugins.serializers.ExtendedDataSource;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;

public class FileInputStreamDataSource
extends ExtendedDataSource {
    private final Path file;
    private String name;
    private InputStream inputStream;

    public FileInputStreamDataSource(Path file) {
        this.file = file;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = Files.newInputStream(this.file, new OpenOption[0]);
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long size() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeToOutputStream(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException, IOException, BimserverDatabaseException {
        this.copy(this.getInputStream(), outputStream, progressReporter, Files.size(this.file));
    }

    private long copy(InputStream input, OutputStream output, ProgressReporter progressReporter, long totalSize) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            progressReporter.update(count += (long)n, totalSize);
        }
        return count;
    }
}

