/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.cache;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bimserver.cache.DownloadDescriptor;
import org.bimserver.cache.NewDiskCacheManager;
import org.bimserver.plugins.serializers.RemovableFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDiskCacheOutputStream
extends RemovableFileOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewDiskCacheOutputStream.class);
    private NewDiskCacheManager diskCacheManager;
    private Path file;
    private Path tempFile;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final DownloadDescriptor downloadDescriptor;

    public NewDiskCacheOutputStream(NewDiskCacheManager diskCacheManager, Path file, DownloadDescriptor downloadDescriptor) throws FileNotFoundException {
        super(file.getParent().resolve(file.getFileName().toString() + ".__tmp"));
        this.tempFile = file.getParent().resolve(file.getFileName().toString() + ".__tmp");
        this.diskCacheManager = diskCacheManager;
        this.file = file;
        this.downloadDescriptor = downloadDescriptor;
    }

    public DownloadDescriptor getDownloadDescriptor() {
        return this.downloadDescriptor;
    }

    public void waitForFinish() throws InterruptedException {
        this.latch.await(30L, TimeUnit.MINUTES);
    }

    public void close() throws IOException {
        super.close();
        LOGGER.info("Renaming temp file " + this.tempFile.getFileName().toString() + " to " + this.file.getFileName().toString());
        Files.move(this.tempFile, this.file, new CopyOption[0]);
        this.diskCacheManager.doneGenerating(this);
        this.latch.countDown();
    }

    public void remove() throws IOException {
        super.remove();
        if (Files.exists(this.tempFile, new LinkOption[0])) {
            Files.delete(this.tempFile);
        }
        this.diskCacheManager.remove(this);
        this.latch.countDown();
    }

    public String getName() {
        return this.file.getFileName().toString();
    }
}

