/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.ErrorCode;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AddReferenceChange
implements Change {
    private final long oid;
    private final String referenceName;
    private final long referenceOid;

    public AddReferenceChange(long oid, String referenceName, long referenceOid) {
        this.oid = oid;
        this.referenceName = referenceName;
        this.referenceOid = referenceOid;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        EClass eClass = databaseSession.getEClassForOid(this.oid);
        if (idEObject == null) {
            throw new UserException("No object of type " + eClass.getName() + " with oid " + this.oid + " found in project with pid " + project.getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.referenceName);
        if (eReference == null) {
            throw new UserException("No reference with the name " + this.referenceName + " found in class " + eClass.getName());
        }
        if (!eReference.isMany()) {
            throw new UserException("Reference is not of type 'many'");
        }
        Object referencedObject = databaseSession.get(this.referenceOid, new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        if (referencedObject == null) {
            referencedObject = created.get(this.oid);
        }
        if (referencedObject == null) {
            EClass referenceEClass = databaseSession.getEClassForOid(this.referenceOid);
            throw new UserException("Referenced object of type " + referenceEClass.getName() + " with oid " + this.referenceOid + " not found");
        }
        boolean added = false;
        if (eReference.getEOpposite() != null) {
            if (eReference.getEOpposite().isMany()) {
                List oppositeList = (List)referencedObject.eGet((EStructuralFeature)eReference.getEOpposite());
                oppositeList.add(idEObject);
                databaseSession.store((IdEObject)referencedObject, (int)project.getId(), (int)concreteRevision.getId());
                added = true;
            } else {
                IdEObject oldReferencing = (IdEObject)referencedObject.eGet((EStructuralFeature)eReference.getEOpposite());
                if (oldReferencing != null) {
                    throw new UserException("You cannot add a reference on " + idEObject.eClass().getName() + " (" + idEObject.getOid() + ")." + eReference.getName() + " to " + referencedObject.eClass().getName() + " (" + referencedObject.getOid() + ") because another object (" + oldReferencing.eClass().getName() + " (" + oldReferencing.getOid() + ")) is already and there is a singular inverse defined", ErrorCode.SET_REFERENCE_FAILED_OPPOSITE_ALREADY_SET);
                }
                referencedObject.eSet((EStructuralFeature)eReference.getEOpposite(), idEObject);
                databaseSession.store((IdEObject)referencedObject, (int)project.getId(), (int)concreteRevision.getId());
                added = true;
            }
        }
        if (!added) {
            List list = (List)idEObject.eGet((EStructuralFeature)eReference);
            list.add(referencedObject);
        }
        databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
    }
}

