/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.GuidCompressor;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CreateObjectChange
implements Change {
    private final long oid;
    private final String type;
    private IdEObjectImpl eObject;
    private EClass eClass;
    private Boolean generateGuid;

    public CreateObjectChange(String type, long oid, EClass eClass, Boolean generateGuid) {
        this.type = type;
        this.oid = oid;
        this.eClass = eClass;
        this.generateGuid = generateGuid;
    }

    public EClass geteClass() {
        return this.eClass;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        EClass eClass = databaseSession.getEClass(project.getSchema(), this.type);
        if (eClass == null) {
            throw new UserException("Type " + this.type + " does not exist");
        }
        this.eObject = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.eObject.setOid(this.oid);
        this.eObject.setPid(project.getId().intValue());
        this.eObject.setRid(concreteRevision.getId().intValue());
        this.eObject.setLoaded();
        try {
            model.add(this.oid, (IdEObject)this.eObject);
        }
        catch (IfcModelInterfaceException e) {
            throw new UserException((Throwable)e);
        }
        if (this.generateGuid.booleanValue()) {
            EStructuralFeature globalIdFeature = this.eObject.eClass().getEStructuralFeature("GlobalId");
            if (globalIdFeature != null) {
                this.eObject.eSet(globalIdFeature, (Object)GuidCompressor.getNewIfcGloballyUniqueId());
            } else {
                throw new UserException("Cannot generate GUID for " + this.eObject.eClass().getName() + ", no GlobalId property");
            }
        }
        databaseSession.store((IdEObject)this.eObject, (int)project.getId(), (int)concreteRevision.getId());
        created.put(this.oid, (IdEObject)this.eObject);
    }
}

