/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoveAllReferencesChange
implements Change {
    private Long oid;
    private String referenceName;

    public RemoveAllReferencesChange(Long oid, String referenceName) {
        this.oid = oid;
        this.referenceName = referenceName;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, (long)this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        EClass eClass = databaseSession.getEClassForOid(this.oid);
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        if (idEObject == null) {
            throw new UserException("No object of type " + eClass.getName() + " with oid " + this.oid + " found in project with pid " + project.getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.referenceName);
        if (eReference == null) {
            throw new UserException("No reference with the name " + this.referenceName + " found in class " + eClass.getName());
        }
        if (!eReference.isMany()) {
            throw new UserException("Reference is not of type 'many'");
        }
        List list = (List)idEObject.eGet((EStructuralFeature)eReference);
        list.clear();
        databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
    }
}

