/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoveAttributeChange
implements Change {
    private final long oid;
    private final String attributeName;
    private final int index;

    public RemoveAttributeChange(long oid, String attributeName, int index) {
        this.oid = oid;
        this.attributeName = attributeName;
        this.index = index;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        EClass eClass = databaseSession.getEClassForOid(this.oid);
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        if (idEObject == null) {
            throw new UserException("No object of type " + eClass.getName() + " with oid " + this.oid + " found in project with pid " + project.getId());
        }
        EAttribute eAttribute = packageMetaData.getEAttribute(eClass.getName(), this.attributeName);
        if (eAttribute == null) {
            throw new UserException("No attribute with the name " + this.attributeName + " found in class " + eClass.getName());
        }
        if (!eAttribute.isMany()) {
            throw new UserException("Attribute is not of type 'many'");
        }
        List list = (List)idEObject.eGet((EStructuralFeature)eAttribute);
        list.remove(this.index);
        databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
    }
}

