/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AbstractDownloadDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoveObjectChange
implements Change {
    private final long oid;
    private EClass eClass;

    public RemoveObjectChange(long oid, EClass eClass) {
        this.oid = oid;
        this.eClass = eClass;
    }

    public EClass geteClass() {
        return this.eClass;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId() - 1, -1L));
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        if (idEObject == null) {
            throw new UserException("Object with oid " + this.oid + " not found");
        }
        int highestStopId = AbstractDownloadDatabaseAction.findHighestStopRid(project, concreteRevision);
        OldQuery query = new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L, null, OldQuery.Deep.YES, highestStopId);
        BasicIfcModel subModel = new BasicIfcModel(packageMetaData, null);
        databaseSession.getMap((IfcModelInterface)subModel, query);
        for (IdEObject idEObject2 : subModel.getValues()) {
            if (idEObject2 == idEObject || deleted.containsKey(idEObject2.getOid())) continue;
            boolean changed = false;
            for (EReference eReference : idEObject2.eClass().getEAllReferences()) {
                Object val = idEObject2.eGet((EStructuralFeature)eReference);
                if (val == null) continue;
                if (eReference.isMany()) {
                    List list = (List)val;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        IdEObject item = (IdEObject)iterator.next();
                        if (item != idEObject) continue;
                        iterator.remove();
                        changed = true;
                    }
                    continue;
                }
                IdEObject ref = (IdEObject)val;
                if (ref != idEObject) continue;
                idEObject2.eSet((EStructuralFeature)eReference, null);
                changed = true;
            }
            if (!changed) continue;
            databaseSession.store(idEObject2, (int)project.getId(), (int)concreteRevision.getId());
        }
        deleted.put(idEObject.getOid(), (IdEObject)idEObject);
        databaseSession.delete((IdEObject)idEObject, concreteRevision.getId());
    }
}

