/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.List;
import java.util.Map;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.InverseAttribute;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoveReferenceChange
implements Change {
    private final long oid;
    private final String referenceName;
    private final int index;
    private final long referencedOid;

    public RemoveReferenceChange(long oid, String referenceName, int index) {
        this.oid = oid;
        this.referenceName = referenceName;
        this.index = index;
        this.referencedOid = -1L;
    }

    public RemoveReferenceChange(long oid, String referenceName, long referencedOid) {
        this.oid = oid;
        this.referenceName = referenceName;
        this.referencedOid = referencedOid;
        this.index = -1;
    }

    private IdEObject getReferencedObject(List<?> list) {
        if (this.index != -1) {
            return (IdEObject)list.get(this.index);
        }
        if (this.referencedOid != -1L) {
            for (Object ref : list) {
                if (((IdEObject)ref).getOid() != this.referencedOid) continue;
                return (IdEObject)ref;
            }
        }
        return null;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        EClass eClass = databaseSession.getEClassForOid(this.oid);
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        if (idEObject == null) {
            throw new UserException("No object of type " + eClass.getName() + " with oid " + this.oid + " found in project with pid " + project.getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.referenceName);
        if (eReference == null) {
            throw new UserException("No reference with the name " + this.referenceName + " found in class " + eClass.getName());
        }
        if (!eReference.isMany()) {
            throw new UserException("Reference is not of type 'many'");
        }
        List list = (List)idEObject.eGet((EStructuralFeature)eReference);
        EntityDefinition entityBN = packageMetaData.getSchemaDefinition().getEntityBN(idEObject.eClass().getName());
        Attribute attributeBNWithSuper = entityBN.getAttributeBNWithSuper(eReference.getName());
        EReference oppositeReference = eReference.getEOpposite();
        if (oppositeReference != null) {
            IdEObject referenced = this.getReferencedObject(list);
            if (oppositeReference.isMany()) {
                List oppositeList = (List)referenced.eGet((EStructuralFeature)oppositeReference);
                oppositeList.remove(idEObject);
                ((List)idEObject.eGet((EStructuralFeature)eReference)).remove(referenced);
                databaseSession.store(referenced, (int)project.getId(), (int)concreteRevision.getId());
            } else {
                referenced.eSet((EStructuralFeature)oppositeReference, null);
                databaseSession.store(referenced, (int)project.getId(), (int)concreteRevision.getId());
            }
        } else {
            IdEObject referenced = this.getReferencedObject(list);
            if (attributeBNWithSuper instanceof InverseAttribute) {
                InverseAttribute inverse = (InverseAttribute)attributeBNWithSuper;
                EReference inverseReference = (EReference)referenced.eClass().getEStructuralFeature(inverse.getInverted_attr().getName());
                if (referenced instanceof List) {
                    ((List)referenced).remove(idEObject);
                } else {
                    referenced.eUnset((EStructuralFeature)inverseReference);
                }
                databaseSession.store(referenced, (int)project.getId(), (int)concreteRevision.getId());
            }
            if (this.index != -1) {
                list.remove(this.index);
            } else if (this.referencedOid != -1L) {
                list.remove(referenced);
            }
        }
        databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
    }
}

