/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SetReferenceChange
implements Change {
    private final long oid;
    private final String referenceName;
    private final long referenceOid;

    public SetReferenceChange(long oid, String referenceName, long referenceOid) {
        this.oid = oid;
        this.referenceName = referenceName;
        this.referenceOid = referenceOid;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        EClass eClass = databaseSession.getEClassForOid(this.oid);
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        if (idEObject == null) {
            throw new UserException("No object of type " + eClass.getName() + " with oid " + this.oid + " found in project with pid " + project.getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.referenceName);
        if (eReference == null) {
            throw new UserException("No reference with the name " + this.referenceName + " found in class " + eClass.getName());
        }
        if (eReference.isMany()) {
            throw new UserException("Reference is not of type 'single'");
        }
        if (this.referenceOid == -1L) {
            if (eReference.getEOpposite() != null && idEObject.eGet((EStructuralFeature)eReference) != null) {
                if (eReference.getEOpposite().isMany()) {
                    IdEObject other = (IdEObject)idEObject.eGet((EStructuralFeature)eReference);
                    List list = (List)other.eGet((EStructuralFeature)eReference.getEOpposite());
                    list.remove(idEObject);
                    databaseSession.store(other, (int)project.getId(), (int)concreteRevision.getId());
                } else {
                    IdEObject other = (IdEObject)idEObject.eGet((EStructuralFeature)eReference);
                    other.eSet((EStructuralFeature)eReference.getEOpposite(), null);
                    databaseSession.store(other, (int)project.getId(), (int)concreteRevision.getId());
                }
            }
            idEObject.eSet((EStructuralFeature)eReference, null);
        } else {
            EClass referenceEClass = databaseSession.getEClassForOid(this.referenceOid);
            Object referencedObject = databaseSession.get(this.referenceOid, new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
            if (referencedObject == null) {
                throw new UserException("Referenced object of type " + referenceEClass.getName() + " with oid " + this.referenceOid + " not found");
            }
            if (eReference.getEOpposite() != null) {
                if (eReference.getEOpposite().isMany()) {
                    List list = (List)referencedObject.eGet((EStructuralFeature)eReference.getEOpposite());
                    list.add(idEObject);
                    databaseSession.store((IdEObject)referencedObject, (int)project.getId(), (int)concreteRevision.getId());
                } else {
                    referencedObject.eSet((EStructuralFeature)eReference.getEOpposite(), idEObject);
                    databaseSession.store((IdEObject)referencedObject, (int)project.getId(), (int)concreteRevision.getId());
                }
            }
            idEObject.eSet((EStructuralFeature)eReference, referencedObject);
        }
        databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
    }
}

