/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.changes;

import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.Change;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.models.ifc2x3tc1.IfcBoolean;
import org.bimserver.models.ifc2x3tc1.Tristate;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.Project;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class SetWrappedAttributeChange
implements Change {
    private Long oid;
    private String attributeName;
    private String type;
    private Object value;

    public SetWrappedAttributeChange(Long oid, String attributeName, String type, Object value) {
        this.oid = oid;
        this.attributeName = attributeName;
        this.type = type;
        this.value = value;
    }

    @Override
    public void execute(IfcModelInterface model, Project project, ConcreteRevision concreteRevision, DatabaseSession databaseSession, Map<Long, IdEObject> created, Map<Long, IdEObject> deleted) throws UserException, BimserverLockConflictException, BimserverDatabaseException {
        PackageMetaData packageMetaData = databaseSession.getMetaDataManager().getPackageMetaData(project.getSchema());
        Object idEObject = databaseSession.get(model, (long)this.oid, (QueryInterface)new OldQuery(packageMetaData, project.getId(), concreteRevision.getId(), -1L));
        EClass eClass = databaseSession.getEClassForOid(this.oid);
        if (idEObject == null) {
            idEObject = created.get(this.oid);
        }
        if (idEObject == null) {
            throw new UserException("No object of type \"" + eClass.getName() + "\" with oid " + this.oid + " found in project with pid " + project.getId());
        }
        EReference eReference = packageMetaData.getEReference(eClass.getName(), this.attributeName);
        if (eReference == null) {
            throw new UserException("No reference with the name \"" + this.attributeName + "\" found in class \"" + eClass.getName() + "\"");
        }
        if (this.value instanceof List && eReference.isMany()) {
            List sourceList = (List)this.value;
            if (!eReference.isMany()) {
                throw new UserException("Attribute is not of type 'many'");
            }
            List list = (List)idEObject.eGet((EStructuralFeature)eReference);
            for (Object o : sourceList) {
                if (eReference.getEType() == EcorePackage.eINSTANCE.getEDouble()) {
                    List asStringList = (List)idEObject.eGet(idEObject.eClass().getEStructuralFeature(this.attributeName + "AsString"));
                    asStringList.add(String.valueOf(o));
                }
                list.add(o);
            }
            databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
        } else {
            if (eReference.isMany()) {
                throw new UserException("Attribute is not of type 'single'");
            }
            if (eReference.getEType() instanceof EEnum) {
                EEnum eEnum = (EEnum)eReference.getEType();
                idEObject.eSet((EStructuralFeature)eReference, (Object)eEnum.getEEnumLiteral(((String)this.value).toUpperCase()).getInstance());
            } else {
                EClass typeEClass = (EClass)packageMetaData.getEClassifier(this.type);
                if (typeEClass.getEAnnotation("wrapped") == null) {
                    throw new UserException("Not a wrapped type");
                }
                EObject wrappedObject = databaseSession.create(typeEClass);
                if (wrappedObject instanceof IfcBoolean) {
                    this.value = (Boolean)this.value == true ? Tristate.TRUE : Tristate.FALSE;
                }
                wrappedObject.eSet(wrappedObject.eClass().getEStructuralFeature("wrappedValue"), this.value);
                idEObject.eSet((EStructuralFeature)eReference, (Object)wrappedObject);
            }
            databaseSession.store((IdEObject)idEObject, (int)project.getId(), (int)concreteRevision.getId());
        }
    }
}

