/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import com.sleepycat.je.DatabaseNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIterator;
import org.bimserver.database.Registry;
import org.bimserver.database.actions.AddUserDatabaseAction;
import org.bimserver.database.actions.CreateBaseProjectDatabaseAction;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.database.migrations.InconsistentModelsException;
import org.bimserver.database.migrations.MigrationException;
import org.bimserver.database.migrations.Migrator;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.DatabaseCreated;
import org.bimserver.models.log.LogPackage;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.SmtpProtocol;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserType;
import org.bimserver.utils.BinUtils;
import org.bimserver.utils.DoubleHashMap;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
implements BimDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(Database.class);
    private static final String CLASS_LOOKUP_TABLE = "INT-ClassLookup";
    public static final String STORE_PROJECT_NAME = "INT-Store";
    public static final int STORE_PROJECT_ID = 1;
    public static final String SCHEMA_VERSION = "SCHEMA_VERSION";
    private static final String DATE_CREATED = "DATE_CREATED";
    private final Map<String, EPackage> emfPackages = new LinkedHashMap<String, EPackage>();
    private final KeyValueStore keyValueStore;
    private final DoubleHashMap<Short, EClass> classifiers = new DoubleHashMap();
    private final List<String> realClasses = new ArrayList<String>();
    private final Map<EClass, AtomicLong> oidCounters = new HashMap<EClass, AtomicLong>();
    private final AtomicInteger pidCounter = new AtomicInteger(1);
    private final Registry registry;
    private Date created;
    private final Set<DatabaseSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private int databaseSchemaVersion;
    private short tableId;
    private Migrator migrator;
    private final MetaDataManager metaDataManager;
    private final BimServer bimServer;
    public static final int APPLICATION_SCHEMA_VERSION = 22;

    public Database(BimServer bimServer, Set<? extends EPackage> emfPackages, KeyValueStore keyValueStore, MetaDataManager metaDataManager) throws DatabaseInitException {
        this.bimServer = bimServer;
        this.keyValueStore = keyValueStore;
        this.metaDataManager = metaDataManager;
        this.emfPackages.put(StorePackage.eINSTANCE.getName(), (EPackage)StorePackage.eINSTANCE);
        this.emfPackages.put(LogPackage.eINSTANCE.getName(), (EPackage)LogPackage.eINSTANCE);
        this.emfPackages.put(GeometryPackage.eINSTANCE.getName(), (EPackage)GeometryPackage.eINSTANCE);
        for (EPackage ePackage : emfPackages) {
            this.emfPackages.put(ePackage.getName(), ePackage);
        }
        this.registry = new Registry(keyValueStore);
    }

    public int getApplicationSchemaVersion() {
        return 22;
    }

    public int getDatabaseSchemaVersion() {
        return this.databaseSchemaVersion;
    }

    public EClass getEClassForName(String packageName, String className) {
        EPackage ePackage = this.emfPackages.get(packageName);
        if (ePackage.getEClassifier(className) != null) {
            return (EClass)ePackage.getEClassifier(className);
        }
        return null;
    }

    @Override
    public void init() throws DatabaseInitException, DatabaseRestartRequiredException, InconsistentModelsException {
        try (DatabaseSession databaseSession = this.createSession();){
            if (this.getKeyValueStore().isNew()) {
                this.keyValueStore.createTable(CLASS_LOOKUP_TABLE, null, false);
                this.keyValueStore.createTable(STORE_PROJECT_NAME, null, false);
                this.keyValueStore.createTable("INT-Registry", null, false);
                this.setDatabaseVersion(-1, databaseSession);
                this.created = new Date();
                this.registry.save(DATE_CREATED, this.created, databaseSession);
            } else {
                this.keyValueStore.openTable(CLASS_LOOKUP_TABLE);
                this.keyValueStore.openTable(STORE_PROJECT_NAME);
                this.keyValueStore.openTable("INT-Registry");
                this.created = this.registry.readDate(DATE_CREATED, databaseSession);
                if (this.created == null) {
                    this.created = new Date();
                    this.registry.save(DATE_CREATED, this.created, databaseSession);
                }
            }
            this.databaseSchemaVersion = this.registry.readInt(SCHEMA_VERSION, databaseSession, -1);
            this.migrator = new Migrator(this);
            if (this.getKeyValueStore().isNew()) {
                try {
                    this.migrator.migrate(databaseSession);
                }
                catch (MigrationException e) {
                    LOGGER.error("", (Throwable)e);
                }
                this.registry.save("isnew", true, databaseSession);
                databaseSession.commit();
                databaseSession.close();
                throw new DatabaseRestartRequiredException();
            }
            if (this.registry.readBoolean("isnew", true, databaseSession)) {
                this.initInternalStructure(databaseSession);
                this.initCounters(databaseSession);
                ServerSettings settings = this.createDefaultSettings(databaseSession);
                databaseSession.store((IdEObject)settings);
                new CreateBaseProjectDatabaseAction(databaseSession, AccessMethod.INTERNAL).execute();
                AddUserDatabaseAction addUserDatabaseAction = new AddUserDatabaseAction(this.bimServer, databaseSession, AccessMethod.INTERNAL, "system", "system", "System", UserType.SYSTEM, new SystemAuthorization(1, TimeUnit.HOURS), false, null);
                addUserDatabaseAction.setCreateSystemUser();
                User systemUser = addUserDatabaseAction.execute();
                systemUser.setCreatedBy(systemUser);
                databaseSession.store((IdEObject)systemUser);
                DatabaseCreated databaseCreated = databaseSession.create(DatabaseCreated.class);
                databaseCreated.setAccessMethod(AccessMethod.INTERNAL);
                databaseCreated.setExecutor(systemUser);
                databaseCreated.setDate(new Date());
                databaseCreated.setPath(this.getKeyValueStore().getLocation());
                databaseCreated.setVersion(Integer.valueOf(this.databaseSchemaVersion));
                databaseSession.store((IdEObject)databaseCreated);
                this.registry.save("isnew", false, databaseSession);
            } else {
                this.initInternalStructure(databaseSession);
                this.initCounters(databaseSession);
            }
            for (EClass eClass : this.classifiers.keyBSet()) {
                if (eClass.getEPackage() != Ifc2x3tc1Package.eINSTANCE && eClass.getEPackage() != Ifc4Package.eINSTANCE) continue;
                this.realClasses.add(eClass.getName());
            }
            databaseSession.commit();
        }
    }

    public ServerSettings createDefaultSettings(DatabaseSession databaseSession) throws BimserverDatabaseException {
        ServerSettings settings = databaseSession.create(ServerSettings.class);
        settings.setEmailSenderAddress("no-reply@bimserver.org");
        settings.setEmailSenderName("Administrator");
        settings.setSiteAddress("");
        settings.setSmtpServer("");
        settings.setSmtpPort(25);
        settings.setSmtpProtocol(SmtpProtocol.SMTP);
        settings.setProtocolBuffersPort(Integer.valueOf(-1));
        settings.setAllowCreateValidatedUser(true);
        settings.setAllowSelfRegistration(Boolean.valueOf(false));
        settings.setAllowUsersToCreateTopLevelProjects(false);
        settings.setCheckinMergingEnabled(Boolean.valueOf(false));
        settings.setHideUserListForNonAdmin(Boolean.valueOf(true));
        settings.setCacheOutputFiles(Boolean.valueOf(true));
        settings.setServiceRepositoryUrl("https://raw.githubusercontent.com/opensourceBIM/BIMserver-Repository/master");
        settings.setAllowOnlyWhitelisted(false);
        settings.setGenerateGeometryOnCheckin(true);
        settings.setReuseGeometry(true);
        settings.setRenderEngineProcesses(1);
        settings.setSessionTimeOutSeconds(2592000);
        settings.getWhitelistedDomains().add((Object)"localhost");
        settings.getWhitelistedDomains().add((Object)"localhost:8080");
        settings.setPluginStrictVersionChecking(true);
        return settings;
    }

    @Override
    public long newOid(EClass eClass) {
        return this.oidCounters.get(eClass).addAndGet(65536L);
    }

    public long getCounter(EClass eClass) {
        return this.oidCounters.get(eClass).get();
    }

    public EClassifier getEClassifier(String packageName, String classifierName) throws BimserverDatabaseException {
        EPackage ePackage;
        if (packageName == null) {
            throw new BimserverDatabaseException("No package name given");
        }
        if (packageName.contains(".")) {
            packageName = packageName.substring(packageName.lastIndexOf(".") + 1);
        }
        if ((ePackage = this.emfPackages.get(packageName)) == null) {
            throw new BimserverDatabaseException("No package found with name " + packageName);
        }
        if (ePackage.getEClassifier(classifierName) != null) {
            return ePackage.getEClassifier(classifierName);
        }
        throw new BimserverDatabaseException("No classifier found with name " + classifierName + " in package " + packageName);
    }

    public EClass getEClass(String packageName, String classifierName) throws BimserverDatabaseException {
        EClassifier eClassifier = this.getEClassifier(packageName, classifierName);
        if (eClassifier instanceof EClass) {
            return (EClass)eClassifier;
        }
        throw new BimserverDatabaseException("Classifier " + packageName + "." + classifierName + " is not an EClass");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInternalStructure(DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        try (RecordIterator recordIterator = this.keyValueStore.getRecordIterator(CLASS_LOOKUP_TABLE, databaseSession);){
            Record record = recordIterator.next();
            while (record != null) {
                String packageAndClassName = BinUtils.byteArrayToString((byte[])record.getValue());
                String packageName = packageAndClassName.substring(0, packageAndClassName.indexOf("_"));
                String className = packageAndClassName.substring(packageAndClassName.indexOf("_") + 1);
                EClass eClass = (EClass)this.getEClassifier(packageName, className);
                this.keyValueStore.openTable(packageAndClassName);
                for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                    if (eStructuralFeature.getEAnnotation("singleindex") == null) continue;
                    String indexTableName = eClass.getEPackage().getName() + "_" + eClass.getName() + "_" + eStructuralFeature.getName();
                    try {
                        this.keyValueStore.openIndexTable(indexTableName);
                    }
                    catch (DatabaseNotFoundException databaseNotFoundException) {}
                }
                Short cid = BinUtils.byteArrayToShort((byte[])record.getKey());
                this.classifiers.put((Object)cid, (Object)eClass);
                record = recordIterator.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCounters(DatabaseSession databaseSession) throws BimserverLockConflictException, BimserverDatabaseException {
        for (EClass eClass : this.classifiers.keyBSet()) {
            try (RecordIterator iterator = this.keyValueStore.getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), databaseSession);){
                Record record = iterator.last();
                this.initCounter(eClass);
                if (record == null) continue;
                ByteBuffer buffer = ByteBuffer.wrap(record.getKey());
                int pid = buffer.getInt();
                long oid = buffer.getLong();
                if (oid > this.oidCounters.get(eClass).get()) {
                    this.oidCounters.put(eClass, new AtomicLong(oid));
                }
                if (pid <= this.pidCounter.get()) continue;
                this.pidCounter.set(pid);
            }
        }
    }

    private void initCounter(EClass eClass) {
        ByteBuffer cidBuffer = ByteBuffer.wrap(new byte[8]);
        cidBuffer.putShort(6, this.getCidOfEClass(eClass));
        long startOid = cidBuffer.getLong(0);
        this.oidCounters.put(eClass, new AtomicLong(startOid));
    }

    public int newPid() {
        return this.pidCounter.incrementAndGet();
    }

    @Override
    public void close() {
        this.keyValueStore.close();
    }

    public List<String> getAvailableClasses() {
        return this.realClasses;
    }

    @Override
    public DatabaseSession createSession() {
        DatabaseSession databaseSession = new DatabaseSession(this, this.keyValueStore.startTransaction());
        this.sessions.add(databaseSession);
        return databaseSession;
    }

    public KeyValueStore getKeyValueStore() {
        return this.keyValueStore;
    }

    public Set<EClass> getClasses() {
        return this.classifiers.keyBSet();
    }

    public EClass getEClassForCid(short cid) {
        return (EClass)this.classifiers.getB((Object)cid);
    }

    public Short getCidOfEClass(EClass eClass) {
        return (Short)this.classifiers.getA((Object)eClass);
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    public Date getCreated() {
        return this.created;
    }

    public void unregisterSession(DatabaseSession databaseSession) {
        this.sessions.remove(databaseSession);
    }

    public void setDatabaseVersion(int version, DatabaseSession databaseSession) throws BimserverLockConflictException {
        this.databaseSchemaVersion = version;
        this.registry.save(SCHEMA_VERSION, version, databaseSession);
    }

    @Override
    public Migrator getMigrator() {
        return this.migrator;
    }

    public boolean createTable(EClass eClass, DatabaseSession databaseSession, boolean transactional) throws BimserverDatabaseException {
        boolean createTable = this.keyValueStore.createTable(eClass.getEPackage().getName() + "_" + eClass.getName(), databaseSession, transactional);
        if (createTable) {
            this.tableId = (short)(this.tableId + 1);
            try {
                this.keyValueStore.store(CLASS_LOOKUP_TABLE, BinUtils.shortToByteArray((short)this.tableId), BinUtils.stringToByteArray((String)(eClass.getEPackage().getName() + "_" + eClass.getName())), null);
            }
            catch (BimserverDatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public boolean createIndexTable(EClass eClass, EStructuralFeature eStructuralFeature, DatabaseSession databaseSession, boolean transactional) throws BimserverDatabaseException {
        boolean createTable = this.keyValueStore.createIndexTable(eClass.getEPackage().getName() + "_" + eClass.getName() + "_" + eStructuralFeature.getName(), databaseSession, transactional);
        return createTable;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public DatabaseSession getDatabaseSession(long txnid) {
        for (DatabaseSession databaseSession : this.sessions) {
            if (databaseSession.getTransactionId() != txnid) continue;
            return databaseSession;
        }
        return null;
    }

    public void incrementCommittedWrites(long committedWrites) {
        this.keyValueStore.incrementCommittedWrites(committedWrites);
    }

    public void incrementReads(long reads) {
        this.keyValueStore.incrementReads(reads);
    }

    @Override
    public EClass getEClassForOid(long oid) throws BimserverDatabaseException {
        short cid = (short)oid;
        EClass eClass = this.getEClassForCid(cid);
        if (eClass == null) {
            throw new BimserverDatabaseException("No class for cid " + cid + " (cid came from oid: " + oid + ")");
        }
        return eClass;
    }
}

