/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import com.google.common.base.Charsets;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.ServerIfcModel;
import org.bimserver.database.BimTransaction;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.BimserverThreadInterruptedException;
import org.bimserver.database.Database;
import org.bimserver.database.KeyValueStore;
import org.bimserver.database.ObjectCache;
import org.bimserver.database.ObjectIdentifier;
import org.bimserver.database.ObjectsToCommit;
import org.bimserver.database.ObjectsToDelete;
import org.bimserver.database.OldQuery;
import org.bimserver.database.PostCommitAction;
import org.bimserver.database.ProgressHandler;
import org.bimserver.database.Record;
import org.bimserver.database.RecordIdentifierPlusType;
import org.bimserver.database.SearchingRecordIterator;
import org.bimserver.database.TodoList;
import org.bimserver.database.UncheckedBimserverDatabaseException;
import org.bimserver.database.UncheckedBimserverLockConflictException;
import org.bimserver.database.actions.BimDatabaseAction;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.database.query.conditions.Condition;
import org.bimserver.database.query.conditions.IsOfTypeCondition;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.LazyLoader;
import org.bimserver.emf.MetaDataException;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.models.store.Checkout;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DatabaseInformation;
import org.bimserver.models.store.DatabaseInformationCategory;
import org.bimserver.models.store.DatabaseInformationItem;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.VirtualObject;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.BinUtils;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSession
implements LazyLoader,
OidProvider,
DatabaseInterface,
AutoCloseable {
    public static final int DEFAULT_CONFLICT_RETRIES = 10;
    private static final boolean DEVELOPER_DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSession.class);
    private final Database database;
    private BimTransaction bimTransaction;
    private final Set<PostCommitAction> postCommitActions = new LinkedHashSet<PostCommitAction>();
    private final ObjectsToCommit objectsToCommit = new ObjectsToCommit();
    private final ObjectsToDelete objectsToDelete = new ObjectsToDelete();
    private StackTraceElement[] stackTrace;
    private final ObjectCache objectCache = new ObjectCache();
    private final Map<EClass, Long> startOids = new HashMap<EClass, Long>();
    private long reads;
    private SessionState state = SessionState.OPEN;
    private boolean overwriteEnabled;

    public DatabaseSession(Database database, BimTransaction bimTransaction) {
        this.database = database;
        this.bimTransaction = bimTransaction;
        for (EClass eClass : database.getClasses()) {
            this.startOids.put(eClass, this.getCounter(eClass));
        }
    }

    public void setOverwriteEnabled(boolean overwriteEnabled) {
        this.overwriteEnabled = overwriteEnabled;
    }

    public EClass getEClassForName(String packageName, String className) {
        return this.database.getEClassForName(packageName, className);
    }

    public void addPostCommitAction(PostCommitAction postCommitAction) {
        this.postCommitActions.add(postCommitAction);
    }

    public void addToObjectsToCommit(IdEObject idEObject) throws BimserverDatabaseException {
        if (idEObject.getOid() == -1L) {
            throw new BimserverDatabaseException("Cannot store object with oid -1");
        }
        this.objectsToCommit.put(idEObject);
    }

    @Override
    public void close() {
        this.state = SessionState.CLOSED;
        this.database.unregisterSession(this);
        this.database.incrementReads(this.reads);
        if (this.bimTransaction != null) {
            try {
                this.bimTransaction.close();
            }
            catch (IllegalStateException e) {
                this.database.getKeyValueStore().dumpOpenCursors();
            }
        }
    }

    public void commit(ProgressHandler progressHandler) throws BimserverDatabaseException, ServiceException {
        this.checkOpen();
        try {
            if (progressHandler != null) {
                progressHandler.progress(0, this.objectsToCommit.size());
            }
            int current = 0;
            long writes = 0L;
            ByteBuffer keyBuffer = ByteBuffer.wrap(new byte[16]);
            for (RecordIdentifierPlusType recordIdentifier : this.objectsToDelete) {
                this.fillKeyBuffer(keyBuffer, recordIdentifier);
                this.database.getKeyValueStore().storeNoOverwrite(recordIdentifier.getPackageName() + "_" + recordIdentifier.getClassName(), keyBuffer.array(), new byte[]{-1}, this);
                ++writes;
            }
            ByteBuffer reusableBuffer = ByteBuffer.allocate(32768);
            for (IdEObject object : this.objectsToCommit) {
                if (object.getOid() == -1L) {
                    throw new BimserverDatabaseException("Cannot store object with oid -1");
                }
                this.fillKeyBuffer(keyBuffer, object);
                ByteBuffer valueBuffer = this.convertObjectToByteArray(object, reusableBuffer, this.getMetaDataManager().getPackageMetaData(object.eClass().getEPackage().getName()));
                int valueBufferPosition = valueBuffer.position();
                boolean hasAtLeastOneIndex = false;
                for (EStructuralFeature eStructuralFeature : object.eClass().getEAllStructuralFeatures()) {
                    if (eStructuralFeature.getEAnnotation("singleindex") == null) continue;
                    hasAtLeastOneIndex = true;
                    break;
                }
                if (hasAtLeastOneIndex) {
                    ByteBuffer oldKeyBuffer = ByteBuffer.allocate(16);
                    oldKeyBuffer.putInt(object.getPid());
                    oldKeyBuffer.putLong(object.getOid());
                    oldKeyBuffer.putInt(-(object.getRid() - 1));
                    byte[] oldData = this.database.getKeyValueStore().get(object.eClass().getEPackage().getName() + "_" + object.eClass().getName(), oldKeyBuffer.array(), this);
                    for (EStructuralFeature eStructuralFeature : object.eClass().getEAllStructuralFeatures()) {
                        if (eStructuralFeature.getEAnnotation("singleindex") == null) continue;
                        String indexTableName = object.eClass().getEPackage().getName() + "_" + object.eClass().getName() + "_" + eStructuralFeature.getName();
                        byte[] featureBytes = this.extractFeatureBytes(this, valueBuffer, object.eClass(), eStructuralFeature);
                        if (oldData != null) {
                            ByteBuffer oldValue = ByteBuffer.wrap(oldData);
                            byte[] featureBytesOldIndex = this.extractFeatureBytes(this, oldValue, object.eClass(), eStructuralFeature);
                            this.database.getKeyValueStore().delete(indexTableName, featureBytesOldIndex, oldKeyBuffer.array(), this);
                        }
                        if (featureBytes == null) continue;
                        this.database.getKeyValueStore().store(indexTableName, featureBytes, keyBuffer.array(), this);
                    }
                }
                if (object.eClass().getEAnnotation("nolazyload") == null && !this.overwriteEnabled) {
                    this.database.getKeyValueStore().storeNoOverwrite(object.eClass().getEPackage().getName() + "_" + object.eClass().getName(), keyBuffer.array(), valueBuffer.array(), 0, valueBufferPosition, this);
                } else {
                    this.database.getKeyValueStore().store(object.eClass().getEPackage().getName() + "_" + object.eClass().getName(), keyBuffer.array(), valueBuffer.array(), 0, valueBuffer.position(), this);
                }
                if (progressHandler != null) {
                    progressHandler.progress(++current, this.objectsToCommit.size());
                }
                ++writes;
                reusableBuffer = valueBuffer;
                reusableBuffer.position(0);
            }
            if (this.bimTransaction != null) {
                this.bimTransaction.commit();
            }
            this.database.incrementCommittedWrites(writes);
            this.close();
            for (PostCommitAction postCommitAction : this.postCommitActions) {
                postCommitAction.execute();
            }
        }
        catch (BimserverDatabaseException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
    }

    private void fillKeyBuffer(ByteBuffer buffer, RecordIdentifierPlusType recordIdentifier) {
        this.fillKeyBuffer(buffer, recordIdentifier.getPid(), recordIdentifier.getOid(), recordIdentifier.getRid());
    }

    private IdEObjectImpl createInternal(EClass eClass, QueryInterface queryInterface) {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setQueryInterface(queryInterface);
        return object;
    }

    private IdEObject convertByteArrayToObject(IdEObject idEObject, EClass originalQueryClass, EClass eClass, long oid, ByteBuffer buffer, IfcModelInterface model, int rid, QueryInterface query, TodoList todoList) throws BimserverDatabaseException {
        try {
            if (idEObject == null) {
                idEObject = this.createInternal(eClass, query);
                ((IdEObjectImpl)idEObject).setOid(oid);
                ((IdEObjectImpl)idEObject).setPid(query.getPid());
                if (rid == Integer.MAX_VALUE) {
                    throw new BimserverDatabaseException("Database corrupt, rid cannot be 2147483647");
                }
            }
            if (idEObject.eClass().getEAnnotation("wrapped") == null) {
                try {
                    model.addAllowMultiModel(oid, idEObject);
                }
                catch (IfcModelInterfaceException e) {
                    throw new BimserverDatabaseException((Throwable)e);
                }
            }
            ((IdEObjectImpl)idEObject).setRid(rid);
            ((IdEObjectImpl)idEObject).useInverses(false);
            ((IdEObjectImpl)idEObject).setLoadingState(IdEObjectImpl.State.LOADING);
            this.objectCache.put(oid, idEObject);
            int unsettedLength = model.getPackageMetaData().getUnsettedLength(eClass);
            byte[] unsetted = new byte[unsettedLength];
            buffer.get(unsetted);
            int fieldCounter = 0;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                try {
                    boolean isUnsetted;
                    if (!model.getPackageMetaData().useForDatabaseStorage(eClass, feature)) continue;
                    boolean bl = isUnsetted = (unsetted[fieldCounter / 8] & 1 << fieldCounter % 8) != 0;
                    if (isUnsetted) {
                        if (feature.isUnsettable()) {
                            idEObject.eUnset(feature);
                        } else if (!feature.isMany() && feature.getDefaultValue() != null) {
                            idEObject.eSet(feature, feature.getDefaultValue());
                        }
                    } else if (!query.shouldFollowReference(originalQueryClass, eClass, feature)) {
                        this.fakeRead(buffer, feature);
                    } else {
                        Object newValue = null;
                        if (feature.isMany()) {
                            newValue = this.readList(idEObject, originalQueryClass, buffer, model, query, todoList, feature);
                        } else if (feature.getEType() instanceof EEnum) {
                            int enumOrdinal = buffer.getInt();
                            if (enumOrdinal == -1) {
                                newValue = null;
                            } else {
                                EClassifier eType = feature.getEType();
                                EEnumLiteral enumLiteral = ((EEnumImpl)eType).getEEnumLiteral(enumOrdinal);
                                if (enumLiteral != null) {
                                    newValue = enumLiteral.getInstance();
                                }
                            }
                        } else if (feature.getEType() instanceof EClass) {
                            short cid = buffer.getShort();
                            if (cid != -1) {
                                EClass referenceClass;
                                if (cid < 0) {
                                    referenceClass = this.database.getEClassForCid(-cid);
                                    newValue = feature.getEAnnotation("dbembed") != null ? this.readEmbeddedValue(feature, buffer, referenceClass, query) : this.readWrappedValue(feature, buffer, referenceClass, query);
                                } else if (cid > 0) {
                                    referenceClass = this.database.getEClassForCid(cid);
                                    if (referenceClass == null) {
                                        throw new BimserverDatabaseException("No eClass found for cid " + cid);
                                    }
                                    newValue = this.readReference(originalQueryClass, buffer, model, idEObject, feature, referenceClass, query, todoList);
                                }
                            }
                        } else if (feature.getEType() instanceof EDataType) {
                            newValue = this.readPrimitiveValue(feature.getEType(), buffer, query);
                        }
                        if (newValue != null) {
                            idEObject.eSet(feature, newValue);
                        }
                    }
                    ++fieldCounter;
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new BimserverDatabaseException("Reading " + eClass.getName() + "(" + oid + ")." + feature.getName(), (Throwable)e);
                }
                catch (BufferUnderflowException e) {
                    throw new BimserverDatabaseException("Reading " + eClass.getName() + "(" + oid + ")." + feature.getName(), (Throwable)e);
                }
                catch (BufferOverflowException e) {
                    throw new BimserverDatabaseException("Reading " + eClass.getName() + "(" + oid + ")." + feature.getName(), (Throwable)e);
                }
            }
            ((IdEObjectImpl)idEObject).setLoaded();
            ((IdEObjectImpl)idEObject).useInverses(true);
            if (idEObject.getRid() < -100000) {
                LOGGER.debug("Improbable rid " + idEObject.getRid() + " - " + idEObject);
            }
            return idEObject;
        }
        catch (BufferUnderflowException e) {
            throw new BimserverDatabaseException("Reading " + eClass.getName(), (Throwable)e);
        }
        catch (BufferOverflowException e) {
            throw new BimserverDatabaseException("Reading " + eClass.getName(), (Throwable)e);
        }
    }

    private Object readList(IdEObject idEObject, EClass originalQueryClass, ByteBuffer buffer, IfcModelInterface model, QueryInterface query, TodoList todoList, EStructuralFeature feature) throws BimserverDatabaseException {
        if (!(feature.getEType() instanceof EEnum)) {
            if (feature.getEType() instanceof EClass) {
                if (buffer.capacity() == 1 && buffer.get(0) == -1) {
                    buffer.position(buffer.position() + 1);
                } else {
                    int listSize = buffer.getInt();
                    AbstractEList list = (AbstractEList)idEObject.eGet(feature);
                    for (int i = 0; i < listSize; ++i) {
                        if (feature.getEAnnotation("twodimensionalarray") != null) {
                            IdEObjectImpl newObject = this.createInternal((EClass)feature.getEType(), query);
                            Object result = this.readList((IdEObject)newObject, originalQueryClass, buffer, model, query, todoList, newObject.eClass().getEStructuralFeature("List"));
                            if (result != null) {
                                newObject.eSet(newObject.eClass().getEStructuralFeature("List"), result);
                            }
                            list.addUnique((Object)newObject);
                            continue;
                        }
                        Object referencedObject = null;
                        short cid = buffer.getShort();
                        if (cid != -1) {
                            EClass referenceClass;
                            if (cid < 0) {
                                referenceClass = this.database.getEClassForCid(-cid);
                                if (referenceClass == null) {
                                    throw new BimserverDatabaseException("No class found for cid " + -cid);
                                }
                                referencedObject = this.readWrappedValue(feature, buffer, referenceClass, query);
                            } else if (cid > 0) {
                                referenceClass = this.database.getEClassForCid(cid);
                                if (referenceClass == null) {
                                    throw new BimserverDatabaseException("Cannot find class with cid " + cid);
                                }
                                referencedObject = this.readReference(originalQueryClass, buffer, model, idEObject, feature, referenceClass, query, todoList);
                            }
                        }
                        if (referencedObject == null) continue;
                        if (!feature.getEType().isInstance(referencedObject)) {
                            throw new BimserverDatabaseException(referencedObject.getClass().getSimpleName() + " cannot be stored in list of type " + feature.getEType().getName() + " for feature " + feature.getName());
                        }
                        if (feature.isUnique()) {
                            list.add(referencedObject);
                            continue;
                        }
                        list.addUnique(referencedObject);
                    }
                }
            } else if (feature.getEType() instanceof EDataType) {
                int listSize = buffer.getInt();
                BasicEList list = new BasicEList(listSize);
                for (int i = 0; i < listSize; ++i) {
                    Object reference = this.readPrimitiveValue(feature.getEType(), buffer, query);
                    if (reference == null) continue;
                    list.addUnique(reference);
                }
                return list;
            }
        }
        return null;
    }

    private boolean useUnsetBit(EStructuralFeature feature, IdEObject object) {
        Object value = object.eGet(feature);
        if (feature.isUnsettable()) {
            if (!object.eIsSet(feature)) {
                return true;
            }
            if (feature.isMany() && ((List)value).isEmpty()) {
                return true;
            }
        } else {
            if (feature.isMany() && ((List)value).isEmpty()) {
                return true;
            }
            if (feature.getDefaultValue() == value || feature.getDefaultValue() != null && feature.getDefaultValue().equals(value)) {
                return true;
            }
        }
        return false;
    }

    private ByteBuffer convertObjectToByteArray(IdEObject object, ByteBuffer buffer, PackageMetaData packageMetaData) throws BimserverDatabaseException {
        int bufferSize = this.getExactSize(object, packageMetaData, true);
        if (bufferSize > buffer.capacity()) {
            LOGGER.debug("Buffer too small (" + bufferSize + ")");
            buffer = ByteBuffer.allocate(bufferSize);
        }
        int unsettedLength = packageMetaData.getUnsettedLength(object.eClass());
        byte[] unsetted = new byte[unsettedLength];
        int fieldCounter = 0;
        for (EStructuralFeature feature : object.eClass().getEAllStructuralFeatures()) {
            if (!packageMetaData.useForDatabaseStorage(object.eClass(), feature)) continue;
            if (this.useUnsetBit(feature, object)) {
                int n = fieldCounter / 8;
                unsetted[n] = (byte)(unsetted[n] | 1 << fieldCounter % 8);
            }
            ++fieldCounter;
        }
        buffer.put(unsetted);
        EClass eClass = this.getEClassForOid(object.getOid());
        if (!eClass.isSuperTypeOf(object.eClass())) {
            throw new BimserverDatabaseException("Object with oid " + object.getOid() + " is a " + object.eClass().getName() + " but it's cid-part says it's a " + eClass.getName());
        }
        for (EStructuralFeature feature : object.eClass().getEAllStructuralFeatures()) {
            if (!packageMetaData.useForDatabaseStorage(object.eClass(), feature) || this.useUnsetBit(feature, object)) continue;
            if (feature.isMany()) {
                this.writeList(object, buffer, packageMetaData, feature);
                continue;
            }
            Object value = object.eGet(feature);
            if (feature.getEType() instanceof EEnum) {
                if (value == null) {
                    buffer.putInt(-1);
                    continue;
                }
                EEnum eEnum = (EEnum)feature.getEType();
                EEnumLiteral eEnumLiteral = eEnum.getEEnumLiteralByLiteral(((Enum)value).toString());
                if (eEnumLiteral != null) {
                    buffer.putInt(eEnumLiteral.getValue());
                    continue;
                }
                LOGGER.error(((Enum)value).toString() + " not found");
                buffer.putInt(-1);
                continue;
            }
            if (feature.getEType() instanceof EClass) {
                if (value == null) {
                    buffer.putShort((short)-1);
                    continue;
                }
                IdEObject referencedObject = (IdEObject)value;
                EClass referencedClass = referencedObject.eClass();
                if (feature.getEAnnotation("dbembed") != null) {
                    this.writeEmbeddedValue(object.getPid(), object.getRid(), value, buffer, packageMetaData);
                    continue;
                }
                if (referencedClass.getEAnnotation("wrapped") != null) {
                    this.writeWrappedValue(object.getPid(), object.getRid(), value, buffer, packageMetaData);
                    continue;
                }
                this.writeReference(object, value, buffer, feature);
                continue;
            }
            if (!(feature.getEType() instanceof EDataType)) continue;
            this.writePrimitiveValue(feature, value, buffer);
        }
        if (buffer.position() != bufferSize) {
            throw new BimserverDatabaseException("Value buffer sizes do not match for " + object.eClass().getName() + " " + buffer.position() + "/" + bufferSize);
        }
        return buffer;
    }

    private void writeList(IdEObject object, ByteBuffer buffer, PackageMetaData packageMetaData, EStructuralFeature feature) throws BimserverDatabaseException {
        block5: {
            block6: {
                if (feature.getEType() instanceof EEnum) break block5;
                if (!(feature.getEType() instanceof EClass)) break block6;
                EList list = (EList)object.eGet(feature);
                buffer.putInt(list.size());
                for (Object o : list) {
                    if (o == null) {
                        buffer.putShort((short)-1);
                        continue;
                    }
                    IdEObject listObject = (IdEObject)o;
                    if (listObject.eClass().getEAnnotation("wrapped") != null || listObject.eClass().getEStructuralFeature("wrappedValue") != null) {
                        this.writeWrappedValue(object.getPid(), object.getRid(), listObject, buffer, packageMetaData);
                        continue;
                    }
                    if (feature.getEAnnotation("twodimensionalarray") != null) {
                        EStructuralFeature lf = listObject.eClass().getEStructuralFeature("List");
                        this.writeList(listObject, buffer, packageMetaData, lf);
                        continue;
                    }
                    this.writeReference(object, listObject, buffer, feature);
                }
                break block5;
            }
            if (!(feature.getEType() instanceof EDataType)) break block5;
            EList list = (EList)object.eGet(feature);
            buffer.putInt(list.size());
            for (Object o : list) {
                this.writePrimitiveValue(feature, o, buffer);
            }
        }
    }

    private ByteBuffer fillKeyBuffer(ByteBuffer buffer, IdEObject object) {
        if (object.getRid() < -100000) {
            LOGGER.debug("Improbable rid: " + object.getRid() + " - " + object);
        }
        return this.fillKeyBuffer(buffer, object.getPid(), object.getOid(), object.getRid());
    }

    private ByteBuffer fillKeyBuffer(ByteBuffer buffer, int pid, long oid, int rid) {
        buffer.position(0);
        buffer.putInt(pid);
        buffer.putLong(oid);
        buffer.putInt(-rid);
        return buffer;
    }

    private ByteBuffer createKeyBuffer(int pid, long oid, int rid) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(16);
        this.fillKeyBuffer(keyBuffer, pid, oid, rid);
        return keyBuffer;
    }

    private ByteBuffer createKeyBuffer(int pid, long oid) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(12);
        this.fillKeyBuffer(keyBuffer, pid, oid);
        return keyBuffer;
    }

    private ByteBuffer fillKeyBuffer(ByteBuffer buffer, int pid, long oid) {
        buffer.position(0);
        buffer.putInt(pid);
        buffer.putLong(oid);
        return buffer;
    }

    public void delete(IdEObject object, Integer newRid) throws BimserverDatabaseException {
        this.checkOpen();
        this.objectsToDelete.put(object.eClass(), object.getPid(), newRid, object.getOid());
        if (this.objectsToCommit.containsObject(object)) {
            this.objectsToCommit.remove(object);
        }
    }

    public <T> T executeAndCommitAction(BimDatabaseAction<T> action, ProgressHandler progressHandler) throws BimserverDatabaseException, ServiceException {
        this.checkOpen();
        return this.executeAndCommitAction(action, 10, progressHandler);
    }

    public <T> T executeAndCommitAction(BimDatabaseAction<T> action) throws BimserverDatabaseException, UserException, ServerException {
        this.checkOpen();
        return this.executeAndCommitAction(action, 10, null);
    }

    public <T> T executeAndCommitAction(BimDatabaseAction<T> action, int retries, ProgressHandler progressHandler) throws BimserverDatabaseException, UserException, ServerException {
        this.checkOpen();
        for (int i = 0; i < retries; ++i) {
            try {
                T result = action.execute();
                if (this.objectsToCommit.size() > 0 || this.objectsToDelete.size() > 0) {
                    this.commit(progressHandler);
                }
                return result;
            }
            catch (BimserverConcurrentModificationDatabaseException e) {
                if (progressHandler != null) {
                    progressHandler.retry(i + 1);
                }
                this.bimTransaction.rollback();
                this.objectCache.clear();
                this.objectsToCommit.clear();
                this.bimTransaction = this.database.getKeyValueStore().startTransaction();
            }
            catch (BimserverLockConflictException e) {
                LOGGER.info("BimserverLockConflictException");
                this.bimTransaction.rollback();
                this.objectCache.clear();
                this.objectsToCommit.clear();
                this.bimTransaction = this.database.getKeyValueStore().startTransaction();
            }
            catch (UncheckedBimserverLockConflictException e) {
                LOGGER.info("UncheckedBimserverLockConflictException");
                this.bimTransaction.rollback();
                this.objectCache.clear();
                this.objectsToCommit.clear();
                this.bimTransaction = this.database.getKeyValueStore().startTransaction();
            }
            catch (BimserverDatabaseException e) {
                throw e;
            }
            catch (ServiceException e) {
                if (e instanceof UserException) {
                    throw (UserException)((Object)e);
                }
                if (e instanceof ServerException) {
                    throw (ServerException)((Object)e);
                }
                LOGGER.error("", (Throwable)e);
            }
            if (i >= retries - 1) continue;
            try {
                Thread.sleep(new Random().nextInt((i + 1) * 1000));
                continue;
            }
            catch (InterruptedException e1) {
                LOGGER.error("", (Throwable)e1);
            }
        }
        throw new BimserverDatabaseException("Too many conflicts, tried " + retries + " times");
    }

    public <T extends IdEObject> T get(EClass eClass, IfcModelInterface model, IdEObject idEObject, long oid, QueryInterface query, TodoList todoList) throws BimserverDatabaseException {
        this.checkOpen();
        return this.get(idEObject, oid, model, query, todoList);
    }

    public <T extends IdEObject> T get(long oid, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        TodoList todoList = new TodoList();
        IfcModelInterface model = this.createModel(query);
        T idEObject = this.get(null, oid, model, query, todoList);
        this.processTodoList(model, todoList, query);
        return idEObject;
    }

    public <T extends IdEObject> T get(IfcModelInterface model, long oid, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        TodoList todoList = new TodoList();
        T idEObject = this.get(null, oid, model, query, todoList);
        this.processTodoList(model, todoList, query);
        return idEObject;
    }

    public <T extends IdEObject> T get(EClass eClass, long oid, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        if (oid == -1L) {
            return null;
        }
        TodoList todoList = new TodoList();
        IfcModelInterface model = this.createModel(query);
        T t = this.get(null, oid, model, query, todoList);
        this.processTodoList(model, todoList, query);
        return t;
    }

    public <T extends IdEObject> T get(IfcModelInterface model, EClass eClass, long oid, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        if (oid == -1L) {
            return null;
        }
        TodoList todoList = new TodoList();
        T t = this.get(null, oid, model, query, todoList);
        this.processTodoList(model, todoList, query);
        return t;
    }

    private void checkOpen() throws BimserverDatabaseException {
        if (this.state == SessionState.CLOSED) {
            throw new BimserverDatabaseException("Database session is closed");
        }
    }

    public <T extends IdEObject> T get(IdEObject idEObject, long oid, IfcModelInterface model, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        TodoList todoList = new TodoList();
        T result = this.get(idEObject, oid, model, query, todoList);
        this.processTodoList(model, todoList, query);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IdEObject> T get(IdEObject idEObject, long oid, IfcModelInterface model, QueryInterface query, TodoList todoList) throws BimserverDatabaseException {
        this.checkOpen();
        if (oid == -1L) {
            throw new BimserverDatabaseException("Cannot get object for oid " + oid);
        }
        if (this.objectsToCommit.containsOid(oid)) {
            return (T)this.objectsToCommit.getByOid(oid);
        }
        EClass eClass = this.getEClassForOid(oid);
        if (idEObject != null && !eClass.isSuperTypeOf(idEObject.eClass())) {
            throw new BimserverDatabaseException("Object with oid " + oid + " is a " + idEObject.eClass().getName() + " but it's cid-part says it's a " + eClass.getName());
        }
        IdEObjectImpl cachedObject = (IdEObjectImpl)this.objectCache.get(oid);
        if (cachedObject != null) {
            idEObject = cachedObject;
            if (cachedObject.getLoadingState() == IdEObjectImpl.State.LOADED && cachedObject.getRid() != Integer.MAX_VALUE) {
                cachedObject.load();
                return (T)cachedObject;
            }
        }
        ByteBuffer mustStartWith = ByteBuffer.wrap(new byte[12]);
        mustStartWith.putInt(query.getPid());
        mustStartWith.putLong(oid);
        ByteBuffer startSearchWith = ByteBuffer.wrap(new byte[16]);
        startSearchWith.putInt(query.getPid());
        startSearchWith.putLong(oid);
        startSearchWith.putInt(-query.getRid());
        try (SearchingRecordIterator recordIterator = this.database.getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), mustStartWith.array(), startSearchWith.array(), this);){
            Record record = recordIterator.next();
            if (record == null) {
                T t = null;
                return t;
            }
            ++this.reads;
            ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
            ByteBuffer valueBuffer = ByteBuffer.wrap(record.getValue());
            keyBuffer.getInt();
            long keyOid = keyBuffer.getLong();
            int keyRid = -keyBuffer.getInt();
            if (keyRid <= query.getRid()) {
                if (idEObject != null && idEObject.getRid() == Integer.MAX_VALUE) {
                    ((IdEObjectImpl)idEObject).setRid(keyRid);
                }
                if (model.contains(keyOid) && ((IdEObjectImpl)model.get(keyOid)).getLoadingState() == IdEObjectImpl.State.LOADED) {
                    IdEObject idEObject2 = model.get(keyOid);
                    return (T)idEObject2;
                }
                if (valueBuffer.capacity() == 1 && valueBuffer.get(0) == -1) {
                    valueBuffer.position(valueBuffer.position() + 1);
                    T t = null;
                    return t;
                }
                IdEObject convertByteArrayToObject = this.convertByteArrayToObject(idEObject, eClass, eClass, keyOid, valueBuffer, model, keyRid, query, todoList);
                if (convertByteArrayToObject.getRid() == Integer.MAX_VALUE) {
                    ((IdEObjectImpl)convertByteArrayToObject).setRid(keyRid);
                }
                this.objectCache.put(oid, convertByteArrayToObject);
                IdEObject idEObject3 = convertByteArrayToObject;
                return (T)idEObject3;
            }
            T t = null;
            return t;
        }
    }

    public IfcModelInterface getAllOfType(EClass eClass, QueryInterface query) throws BimserverDatabaseException {
        IfcModelInterface model = this.createModel(query);
        return this.getAllOfType(model, eClass, query);
    }

    public IfcModelInterface getAllOfType(IfcModelInterface model, EClass eClass, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        TodoList todoList = new TodoList();
        this.getMap(eClass, model, query, todoList);
        this.processTodoList(model, todoList, query);
        return model;
    }

    public IfcModelInterface getAllOfTypes(Set<EClass> eClasses, QueryInterface query) throws BimserverDatabaseException {
        IfcModelInterface model = this.createModel(query);
        return this.getAllOfTypes(model, eClasses, query);
    }

    public IfcModelInterface getAllOfTypes(IfcModelInterface model, Set<EClass> eClasses, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        TodoList todoList = new TodoList();
        for (EClass eClass : eClasses) {
            this.getMap(eClass, model, query, todoList);
        }
        this.processTodoList(model, todoList, query);
        return model;
    }

    public IfcModelInterface getAllOfType(String packageName, String className, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        return this.getAllOfType(this.getEClass(packageName, className), query);
    }

    public IfcModelInterface getAllOfType(IfcModelInterface model, String packageName, String className, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        return this.getAllOfType(model, this.getEClass(packageName, className), query);
    }

    public BimTransaction getBimTransaction() {
        return this.bimTransaction;
    }

    public short getCid(EClass eClass) throws BimserverDatabaseException {
        Short cidOfEClass = this.database.getCidOfEClass(eClass);
        if (cidOfEClass == null) {
            throw new BimserverDatabaseException("EClass " + eClass.getName() + " not registered");
        }
        return cidOfEClass;
    }

    public short getCidForClassName(String packageName, String className) throws BimserverDatabaseException {
        return this.database.getCidOfEClass(this.getEClass(packageName, className));
    }

    public short getCidOfEClass(EClass eClass) {
        return this.database.getCidOfEClass(eClass);
    }

    public List<String> getClassList() {
        return this.database.getAvailableClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(EClass eClass, IfcModelInterface model, int pid, int rid) throws BimserverDatabaseException {
        this.checkOpen();
        int count = 0;
        try (SearchingRecordIterator recordIterator = this.database.getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), BinUtils.intToByteArray((int)pid), BinUtils.intToByteArray((int)pid), this);){
            Record record = recordIterator.next();
            ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
            byte[] nullReference = new byte[]{-1};
            while (record != null) {
                ++this.reads;
                ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
                int keyPid = keyBuffer.getInt();
                long oid = keyBuffer.getLong();
                int keyRid = -keyBuffer.getInt();
                int map = this.getCount(model, pid, rid, keyPid, keyRid);
                if (map == 1) {
                    if (!Arrays.equals(record.getValue(), nullReference)) {
                        ++count;
                    }
                    nextKeyStart.position(0);
                    nextKeyStart.putInt(pid);
                    nextKeyStart.putLong(oid + 1L);
                    record = recordIterator.next(nextKeyStart.array());
                    continue;
                }
                record = recordIterator.next();
            }
        }
        return count;
    }

    private int getCount(IfcModelInterface model, int pid, int rid, int keyPid, int keyRid) {
        if (keyPid == pid) {
            if (keyRid <= rid) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public Date getCreatedDate() {
        return this.database.getCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseInformation getDatabaseInformation() throws BimserverDatabaseException {
        DatabaseInformation databaseInformation = StoreFactory.eINSTANCE.createDatabaseInformation();
        databaseInformation.setNumberOfProjects(Integer.valueOf(this.getObjectCount(Project.class, OldQuery.getDefault())));
        databaseInformation.setNumberOfUsers(Integer.valueOf(this.getObjectCount(User.class, OldQuery.getDefault())));
        databaseInformation.setNumberOfCheckouts(Integer.valueOf(this.getObjectCount(Checkout.class, OldQuery.getDefault())));
        databaseInformation.setNumberOfRevisions(Integer.valueOf(this.getObjectCount(ConcreteRevision.class, OldQuery.getDefault())));
        databaseInformation.setType(this.database.getKeyValueStore().getType());
        databaseInformation.setCreated(this.database.getCreated());
        databaseInformation.setDatabaseSizeInBytes(Long.valueOf(this.database.getKeyValueStore().getDatabaseSizeInBytes()));
        databaseInformation.setSchemaVersion(Integer.valueOf(this.database.getRegistry().readInt("SCHEMA_VERSION", this)));
        String stats = this.database.getKeyValueStore().getStats();
        try (Scanner scanner = new Scanner(stats);){
            DatabaseInformationCategory category = StoreFactory.eINSTANCE.createDatabaseInformationCategory();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.contains("=")) {
                    DatabaseInformationItem item = StoreFactory.eINSTANCE.createDatabaseInformationItem();
                    category.getItems().add((Object)item);
                    item.setKey(line.substring(0, line.indexOf("=")));
                    item.setValue(line.substring(line.indexOf("=") + 1));
                    continue;
                }
                category = StoreFactory.eINSTANCE.createDatabaseInformationCategory();
                category.setTitle(line);
                databaseInformation.getCategories().add((Object)category);
            }
        }
        databaseInformation.setLocation(this.database.getKeyValueStore().getLocation());
        return databaseInformation;
    }

    public EClass getEClass(short cid) {
        return this.database.getEClassForCid(cid);
    }

    public EClass getEClass(String packageName, String className) throws BimserverDatabaseException {
        return this.database.getEClass(packageName, className);
    }

    private int getExactSize(IdEObject idEObject, PackageMetaData packageMetaData, boolean useUnsetBits) {
        int size = 0;
        int bits = 0;
        for (EStructuralFeature eStructuralFeature : idEObject.eClass().getEAllStructuralFeatures()) {
            if (!packageMetaData.useForDatabaseStorage(idEObject.eClass(), eStructuralFeature)) continue;
            ++bits;
            if (useUnsetBits && this.useUnsetBit(eStructuralFeature, idEObject)) continue;
            Object val = idEObject.eGet(eStructuralFeature);
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                if (eAttribute.isMany()) {
                    size += 4;
                    for (Object v : (List)val) {
                        size += this.getPrimitiveSize(eAttribute.getEAttributeType(), v);
                    }
                    continue;
                }
                size += this.getPrimitiveSize(eAttribute.getEAttributeType(), val);
                continue;
            }
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            if (eReference.isMany()) {
                size += 4;
                for (Object v : (List)val) {
                    size += this.getWrappedValueSize(v, eReference, packageMetaData);
                }
                continue;
            }
            if (val == null) {
                size += 2;
                continue;
            }
            size += this.getWrappedValueSize(val, eReference, packageMetaData);
        }
        if (useUnsetBits) {
            size += (int)Math.ceil((double)bits / 8.0);
        }
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GetResult getMap(EClass originalQueryClass, EClass eClass, IfcModelInterface model, ByteBuffer buffer, int keyPid, long keyOid, int keyRid, QueryInterface query, TodoList todoList) throws BimserverDatabaseException {
        this.checkOpen();
        if (keyPid != query.getPid()) return GetResult.STOP;
        if (keyRid > query.getRid() || keyRid < query.getStopRid()) return GetResult.CONTINUE_WITH_NEXT_RECORD;
        IdEObject cachedObject = this.objectCache.get(keyOid);
        if (cachedObject != null && ((IdEObjectImpl)cachedObject).getLoadingState() == IdEObjectImpl.State.LOADED) {
            if (model.contains(keyOid) || cachedObject.eClass().getEAnnotation("wrapped") != null) return GetResult.CONTINUE_WITH_NEXT_OID;
            try {
                model.addAllowMultiModel(keyOid, cachedObject);
                return GetResult.CONTINUE_WITH_NEXT_OID;
            }
            catch (IfcModelInterfaceException e) {
                throw new BimserverDatabaseException((Throwable)e);
            }
        }
        IdEObject object = null;
        if (model.contains(keyOid) && ((IdEObjectImpl)model.get(keyOid)).getLoadingState() == IdEObjectImpl.State.LOADED) {
            object = model.get(keyOid);
        } else {
            if (buffer.capacity() == 1 && buffer.get(0) == -1) {
                buffer.position(buffer.position() + 1);
                return GetResult.CONTINUE_WITH_NEXT_OID;
            }
            object = this.convertByteArrayToObject(cachedObject, originalQueryClass, eClass, keyOid, buffer, model, keyRid, query, todoList);
        }
        if (object == null) return GetResult.STOP;
        this.objectCache.put(keyOid, object);
        return GetResult.CONTINUE_WITH_NEXT_OID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMap(EClass eClass, IfcModelInterface ifcModel, QueryInterface query, TodoList todoList) throws BimserverDatabaseException {
        this.checkOpen();
        SearchingRecordIterator recordIterator = null;
        String tableName = eClass.getEPackage().getName() + "_" + eClass.getName();
        if (query.getOidCounters() != null) {
            if (!query.getOidCounters().containsKey(eClass)) {
                return;
            }
            long startOid = (Long)query.getOidCounters().get(eClass);
            ByteBuffer tmp = ByteBuffer.allocate(12);
            tmp.putInt(query.getPid());
            tmp.putLong(startOid + 1L);
            recordIterator = this.database.getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)query.getPid()), tmp.array(), this);
        } else {
            recordIterator = this.database.getKeyValueStore().getRecordIterator(tableName, BinUtils.intToByteArray((int)query.getPid()), BinUtils.intToByteArray((int)query.getPid()), this);
        }
        try {
            Record record = recordIterator.next();
            ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
            while (record != null) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new BimserverThreadInterruptedException("Thread interrupted");
                }
                ++this.reads;
                ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
                int keyPid = keyBuffer.getInt();
                long keyOid = keyBuffer.getLong();
                int keyRid = -keyBuffer.getInt();
                ByteBuffer valueBuffer = ByteBuffer.wrap(record.getValue());
                GetResult map = this.getMap(eClass, eClass, ifcModel, valueBuffer, keyPid, keyOid, keyRid, query, todoList);
                if (map == GetResult.CONTINUE_WITH_NEXT_OID) {
                    nextKeyStart.position(0);
                    nextKeyStart.putInt(query.getPid());
                    nextKeyStart.putLong(keyOid + 1L);
                    record = recordIterator.next(nextKeyStart.array());
                    continue;
                }
                record = recordIterator.next();
            }
        }
        finally {
            recordIterator.close();
        }
    }

    public void getMap(IfcModelInterface ifcModel, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        TodoList todoList = new TodoList();
        if (query.getOidCounters() != null) {
            for (EClass eClass : query.getOidCounters().keySet()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new BimserverDatabaseException("Thread interrupted");
                }
                if (eClass.getEAnnotation("nolazyload") != null || eClass.getEAnnotation("nodatabase") != null || !query.shouldIncludeClass(eClass)) continue;
                this.getMap(eClass, ifcModel, query, todoList);
            }
        } else {
            LOGGER.info("Inefficient getMap");
            for (EClass eClass : this.database.getClasses()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new BimserverDatabaseException("Thread interrupted");
                }
                if (eClass.getEAnnotation("nolazyload") != null || eClass.getEAnnotation("nodatabase") != null || !query.shouldIncludeClass(eClass)) continue;
                this.getMap(eClass, ifcModel, query, todoList);
            }
        }
        this.processTodoList(ifcModel, todoList, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IfcModelInterface getMapWithOid(QueryInterface query, short cid, long oid, IfcModelInterface model) throws BimserverDatabaseException {
        this.checkOpen();
        EClass eClass = this.database.getEClassForCid(cid);
        if (eClass == null) {
            return model;
        }
        TodoList todoList = new TodoList();
        ByteBuffer mustStartWith = this.createKeyBuffer(query.getPid(), oid);
        ByteBuffer key = this.createKeyBuffer(query.getPid(), oid, -query.getStopRid());
        this.checkOpen();
        try (SearchingRecordIterator recordIterator = this.database.getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), mustStartWith.array(), key.array(), this);){
            Record record = recordIterator.next();
            ByteBuffer nextKeyStart = ByteBuffer.allocate(12);
            while (record != null) {
                ++this.reads;
                ByteBuffer keyBuffer = ByteBuffer.wrap(record.getKey());
                int keyPid = keyBuffer.getInt();
                long keyOid = keyBuffer.getLong();
                int keyRid = -keyBuffer.getInt();
                ByteBuffer valueBuffer = ByteBuffer.wrap(record.getValue());
                GetResult map = this.getMap(eClass, eClass, model, valueBuffer, keyPid, keyOid, keyRid, query, todoList);
                if (map == GetResult.CONTINUE_WITH_NEXT_OID) {
                    nextKeyStart.position(0);
                    nextKeyStart.putInt(query.getPid());
                    nextKeyStart.putLong(keyOid + 1L);
                    record = recordIterator.next(nextKeyStart.array());
                    continue;
                }
                record = recordIterator.next();
            }
        }
        this.processTodoList(model, todoList, query);
        return model;
    }

    private void processTodoList(IfcModelInterface model, TodoList todoList, QueryInterface query) throws BimserverDatabaseException {
        IdEObject idEObject = (IdEObject)todoList.poll();
        while (idEObject != null) {
            Object result = this.get(idEObject, idEObject.getOid(), model, query, todoList);
            if (result == null) {
                throw new BimserverDatabaseException("Object not found: " + query.getPid() + " " + query.getRid() + " " + idEObject.getOid() + " " + idEObject.eClass().getName());
            }
            if (!model.contains(result.getOid())) {
                try {
                    model.addAllowMultiModel(result.getOid(), result);
                }
                catch (IfcModelInterfaceException e) {
                    throw new BimserverDatabaseException((Throwable)e);
                }
            }
            idEObject = (IdEObject)todoList.poll();
        }
    }

    public void getMapWithOids(IfcModelInterface model, Set<Long> oids, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        for (Long oid : oids) {
            EClass eClass = this.getEClassForOid(oid);
            if (eClass != null) {
                this.getMapWithOid(query, this.database.getCidOfEClass(eClass), oid, model);
                continue;
            }
            throw new BimserverDatabaseException("No class found for oid " + oid);
        }
    }

    public MetaDataManager getMetaDataManager() {
        return this.database.getMetaDataManager();
    }

    private int getObjectCount(Class<? extends IdEObject> clazz, QueryInterface query) throws BimserverDatabaseException {
        IsOfTypeCondition condition = new IsOfTypeCondition((EClass)StorePackage.eINSTANCE.getEClassifier(clazz.getSimpleName()));
        return this.query(condition, clazz, query).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectIdentifier getOidOfGuid(String schema, String guid, int pid, int rid) throws BimserverDatabaseException {
        PackageMetaData packageMetaData = this.getMetaDataManager().getPackageMetaData(schema);
        for (EClass eClass : packageMetaData.getAllSubClasses(packageMetaData.getEClass("IfcRoot"))) {
            try (SearchingRecordIterator recordIterator = this.database.getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), BinUtils.intToByteArray((int)pid), BinUtils.intToByteArray((int)pid), this);){
                Record record = recordIterator.next();
                while (record != null) {
                    ++this.reads;
                    ByteBuffer buffer = ByteBuffer.wrap(record.getKey());
                    int pidOfRecord = buffer.getInt();
                    long oid = buffer.getLong();
                    int ridOfRecord = -buffer.getInt();
                    if (ridOfRecord == rid && pid == pidOfRecord) {
                        ByteBuffer value = ByteBuffer.wrap(record.getValue());
                        value.position(value.position() + packageMetaData.getUnsettedLength(eClass));
                        if (value.capacity() > 1) {
                            int stringLength = value.getInt();
                            if (stringLength == -1) {
                                ObjectIdentifier objectIdentifier = null;
                                return objectIdentifier;
                            }
                            String s = BinUtils.readString((ByteBuffer)value, (int)stringLength);
                            if (s.equals(guid)) {
                                ObjectIdentifier objectIdentifier = new ObjectIdentifier(oid, this.getCid(eClass));
                                return objectIdentifier;
                            }
                        }
                    }
                    record = recordIterator.next();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectIdentifier> getOidsOfName(String schema, String name, int pid, int rid) throws BimserverDatabaseException, MetaDataException {
        HashSet<ObjectIdentifier> result = new HashSet<ObjectIdentifier>();
        for (EClass eClass : this.getMetaDataManager().getPackageMetaData(schema).getAllSubClasses(this.getMetaDataManager().getPackageMetaData(schema).getEClass("IfcRoot"))) {
            try (SearchingRecordIterator recordIterator = this.database.getKeyValueStore().getRecordIterator(eClass.getEPackage().getName() + "_" + eClass.getName(), BinUtils.intToByteArray((int)pid), BinUtils.intToByteArray((int)pid), this);){
                Record record = recordIterator.next();
                while (record != null) {
                    ++this.reads;
                    ByteBuffer buffer = ByteBuffer.wrap(record.getKey());
                    int pidOfRecord = buffer.getInt();
                    long oid = buffer.getLong();
                    int ridOfRecord = -buffer.getInt();
                    if (ridOfRecord == rid && pid == pidOfRecord) {
                        ByteBuffer value = ByteBuffer.wrap(record.getValue());
                        byte unsettablesSize = value.get();
                        value.position(value.position() + unsettablesSize);
                        if (value.capacity() > 1) {
                            String foundName;
                            int stringLength = value.getInt();
                            if (stringLength == -1) {
                                Set<ObjectIdentifier> set = null;
                                return set;
                            }
                            BinUtils.readString((ByteBuffer)value, (int)stringLength);
                            if (value.getShort() != -1) {
                                value.getLong();
                            }
                            if ((stringLength = value.getInt()) != -1 && name.equals(foundName = BinUtils.readString((ByteBuffer)value, (int)stringLength))) {
                                result.add(new ObjectIdentifier(oid, this.getCid(eClass)));
                            }
                        }
                    }
                    record = recordIterator.next();
                }
            }
        }
        return result;
    }

    private int getPrimitiveSize(EDataType eDataType, Object val) {
        if (eDataType == EcorePackage.eINSTANCE.getEInt() || eDataType == EcorePackage.eINSTANCE.getEIntegerObject()) {
            return 4;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEFloat() || eDataType == EcorePackage.eINSTANCE.getEFloatObject()) {
            return 4;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEBoolean() || eDataType == EcorePackage.eINSTANCE.getEBooleanObject()) {
            return 1;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEDate()) {
            return 8;
        }
        if (eDataType == EcorePackage.eINSTANCE.getELong() || eDataType == EcorePackage.eINSTANCE.getELongObject()) {
            return 8;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEDouble() || eDataType == EcorePackage.eINSTANCE.getEDoubleObject()) {
            return 8;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEString()) {
            if (val != null) {
                return 4 + ((String)val).getBytes(Charsets.UTF_8).length;
            }
            return 4;
        }
        if (eDataType == EcorePackage.eINSTANCE.getEByteArray()) {
            if (val != null) {
                return 4 + ((byte[])val).length;
            }
            return 4;
        }
        if (eDataType instanceof EEnum) {
            return 4;
        }
        throw new RuntimeException("Unimplemented: " + eDataType);
    }

    private int getWrappedValueSize(Object val, EReference eReference, PackageMetaData packageMetaData) {
        if (val == null) {
            return 2;
        }
        if (val instanceof EObject) {
            IdEObject eObject = (IdEObject)val;
            int refSize = 10;
            if (eReference.getEAnnotation("twodimensionalarray") != null) {
                refSize = 4;
                EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature("List");
                List l = (List)eObject.eGet(eStructuralFeature);
                for (Object o : l) {
                    if (o instanceof EObject) {
                        refSize += 10;
                        continue;
                    }
                    refSize += this.getPrimitiveSize((EDataType)eStructuralFeature.getEType(), o);
                }
            }
            if (eReference.getEAnnotation("dbembed") != null) {
                refSize = 2;
                refSize += this.getExactSize(eObject, packageMetaData, false);
            }
            if (eObject.eClass().getEAnnotation("wrapped") != null) {
                IdEObject wrappedValue = (IdEObject)val;
                EStructuralFeature wrappedValueFeature = wrappedValue.eClass().getEStructuralFeature("wrappedValue");
                Object wrappedVal = eObject.eGet(wrappedValueFeature);
                refSize = 2 + this.getPrimitiveSize((EDataType)wrappedValueFeature.getEType(), wrappedVal);
                if (wrappedValueFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || wrappedValueFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
                    EStructuralFeature wrappedStringFeature = wrappedValue.eClass().getEStructuralFeature("wrappedValueAsString");
                    String str = (String)eObject.eGet(wrappedStringFeature);
                    refSize += this.getPrimitiveSize(EcorePackage.eINSTANCE.getEString(), str);
                }
            }
            return refSize;
        }
        return 10;
    }

    public boolean perRecordVersioning(IdEObject idEObject) {
        return DatabaseSession.perRecordVersioning(idEObject.eClass());
    }

    public static boolean perRecordVersioning(EClass eClass) {
        return eClass.getEPackage() != Ifc2x3tc1Package.eINSTANCE && eClass.getEPackage() != Ifc4Package.eINSTANCE && eClass.getEPackage() != GeometryPackage.eINSTANCE;
    }

    public IfcModelInterface createModel(PackageMetaData packageMetaData, Map<Integer, Long> pidRoidMap) {
        return new BasicIfcModel(packageMetaData, pidRoidMap);
    }

    public IfcModelInterface createModel(QueryInterface queryInterface) {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        map.put(queryInterface.getPid(), queryInterface.getRoid());
        return new ServerIfcModel(queryInterface.getPackageMetaData(), map, this);
    }

    public IdEObject lazyLoad(IdEObject idEObject) throws BimserverDatabaseException {
        IfcModelInterface model = ((IdEObjectImpl)idEObject).getModel();
        if (model == null) {
            HashMap<Integer, Long> pidToRoid = new HashMap<Integer, Long>();
            model = this.createModel(this.getMetaDataManager().getPackageMetaData(idEObject.eClass().getEPackage().getName()), pidToRoid);
        }
        if ((idEObject = this.get((IdEObject)idEObject, idEObject.getOid(), model, ((IdEObjectImpl)idEObject).getQueryInterface(), new TodoList())) != null && idEObject.getRid() < -100000) {
            LOGGER.debug("Improbable rid " + idEObject.getRid() + " - " + idEObject);
        }
        return idEObject;
    }

    public void load(IdEObject idEObject) {
        try {
            this.lazyLoad(idEObject);
        }
        catch (BimserverLockConflictException e) {
            throw new UncheckedBimserverLockConflictException(e);
        }
        catch (BimserverDatabaseException e) {
            throw new UncheckedBimserverDatabaseException(e);
        }
    }

    public long newOid(EClass eClass) {
        long newOid = this.database.newOid(eClass);
        return newOid;
    }

    public Map<EClass, Long> getStartOids() {
        return this.startOids;
    }

    public int newPid() {
        return this.database.newPid();
    }

    public <T extends IdEObject> Map<Long, T> query(Condition condition, Class<T> clazz, QueryInterface query) throws BimserverDatabaseException {
        IfcModelInterface model = this.createModel(query);
        return this.query(model, condition, clazz, query);
    }

    public <T extends IdEObject> Map<Long, T> query(IfcModelInterface model, Condition condition, Class<T> clazz, QueryInterface query) throws BimserverDatabaseException {
        HashMap<Long, T> map = new HashMap<Long, T>();
        HashSet<EClass> eClasses = new HashSet<EClass>();
        condition.getEClassRequirements(eClasses);
        for (EClass eClass : eClasses) {
            TodoList todoList = new TodoList();
            this.getMap(eClass, model, query, todoList);
            this.processTodoList(model, todoList, query);
            ArrayList list = new ArrayList(model.getValues());
            for (IdEObject object : list) {
                if (!clazz.isInstance(object) || !condition.matches(object)) continue;
                map.put(object.getOid(), clazz.cast(object));
            }
        }
        return map;
    }

    public <T extends IdEObject> T querySingle(Condition condition, Class<T> clazz, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        Collection<T> values = this.query(condition, clazz, query).values();
        if (values.size() == 0) {
            return null;
        }
        return (T)((IdEObject)values.iterator().next());
    }

    public Object readPrimitiveValue(EClassifier classifier, ByteBuffer buffer, QueryInterface query) {
        if (classifier == EcorePackage.eINSTANCE.getEString()) {
            int length = buffer.getInt();
            if (length != -1) {
                return BinUtils.readString((ByteBuffer)buffer, (int)length);
            }
            return null;
        }
        if (classifier == EcorePackage.eINSTANCE.getEInt() || classifier == EcorePackage.eINSTANCE.getEIntegerObject()) {
            return buffer.getInt();
        }
        if (classifier == EcorePackage.eINSTANCE.getELong() || classifier == EcorePackage.eINSTANCE.getELongObject()) {
            return buffer.getLong();
        }
        if (classifier == EcorePackage.eINSTANCE.getEFloat() || classifier == EcorePackage.eINSTANCE.getEFloatObject()) {
            return Float.valueOf(buffer.getFloat());
        }
        if (classifier == EcorePackage.eINSTANCE.getEDouble() || classifier == EcorePackage.eINSTANCE.getEDoubleObject()) {
            return buffer.getDouble();
        }
        if (classifier == EcorePackage.eINSTANCE.getEBoolean() || classifier == EcorePackage.eINSTANCE.getEBooleanObject()) {
            return buffer.get() == 1;
        }
        if (classifier == EcorePackage.eINSTANCE.getEDate()) {
            long val = buffer.getLong();
            if (val == -1L) {
                return null;
            }
            return new Date(val);
        }
        if (classifier == EcorePackage.eINSTANCE.getEByteArray()) {
            int size = buffer.getInt();
            byte[] result = new byte[size];
            buffer.get(result);
            return result;
        }
        if (classifier.getName().equals("Tristate")) {
            int ordinal = buffer.getInt();
            EEnum tristateEnum = query.getPackageMetaData().getEEnum("Tristate");
            return tristateEnum.getEEnumLiteral(ordinal).getInstance();
        }
        if (classifier instanceof EEnum) {
            int ordinal = buffer.getInt();
            EEnum eEnum = (EEnum)classifier;
            return eEnum.getEEnumLiteral(ordinal).getInstance();
        }
        throw new RuntimeException("Unsupported type " + classifier.getName());
    }

    public byte[] readPrimitiveBytes(EClassifier classifier, ByteBuffer buffer, QueryInterface query) {
        if (classifier == EcorePackage.eINSTANCE.getEString()) {
            int length = buffer.getInt();
            if (length != -1) {
                byte[] result = new byte[length];
                buffer.get(result, 0, length);
                return result;
            }
            return null;
        }
        if (classifier == EcorePackage.eINSTANCE.getEInt() || classifier == EcorePackage.eINSTANCE.getEIntegerObject()) {
            byte[] result = new byte[4];
            buffer.get(result, 0, 4);
            return result;
        }
        if (classifier == EcorePackage.eINSTANCE.getELong() || classifier == EcorePackage.eINSTANCE.getELongObject()) {
            byte[] result = new byte[8];
            buffer.get(result, 0, 8);
            return result;
        }
        if (classifier == EcorePackage.eINSTANCE.getEFloat() || classifier == EcorePackage.eINSTANCE.getEFloatObject()) {
            byte[] result = new byte[4];
            buffer.get(result, 0, 4);
            return result;
        }
        if (classifier == EcorePackage.eINSTANCE.getEDouble() || classifier == EcorePackage.eINSTANCE.getEDoubleObject()) {
            byte[] result = new byte[8];
            buffer.get(result, 0, 8);
            return result;
        }
        if (classifier == EcorePackage.eINSTANCE.getEBoolean() || classifier == EcorePackage.eINSTANCE.getEBooleanObject()) {
            byte[] result = new byte[1];
            buffer.get(result, 0, 1);
            return result;
        }
        if (classifier == EcorePackage.eINSTANCE.getEDate()) {
            byte[] result = new byte[8];
            buffer.get(result, 0, 8);
            return result;
        }
        if (classifier == EcorePackage.eINSTANCE.getEByteArray()) {
            int size = buffer.getInt();
            byte[] result = new byte[size];
            buffer.get(result);
            return result;
        }
        throw new RuntimeException("Unsupported type " + classifier.getName());
    }

    public void fakeRead(ByteBuffer buffer, EStructuralFeature feature) throws BimserverDatabaseException {
        boolean wrappedValue;
        boolean bl = wrappedValue = feature.getEType().getEAnnotation("wrapped") != null;
        if (feature.isMany()) {
            if (!(feature.getEType() instanceof EEnum)) {
                if (feature.getEType() instanceof EClass) {
                    if (buffer.capacity() == 1 && buffer.get(0) == -1) {
                        buffer.position(buffer.position() + 1);
                    } else {
                        int listSize = buffer.getInt();
                        for (int i = 0; i < listSize; ++i) {
                            short cid = buffer.getShort();
                            if (cid == -1) continue;
                            if (wrappedValue) {
                                EClass eClass = (EClass)feature.getEType();
                                this.fakePrimitiveRead(eClass.getEStructuralFeature("wrappedValue").getEType(), buffer);
                                continue;
                            }
                            buffer.position(buffer.position() + 8);
                        }
                    }
                } else if (feature.getEType() instanceof EDataType) {
                    int listSize = buffer.getInt();
                    for (int i = 0; i < listSize; ++i) {
                        this.fakePrimitiveRead(feature.getEType(), buffer);
                    }
                }
            }
        } else if (feature.getEType() instanceof EEnum) {
            buffer.position(buffer.position() + 4);
        } else if (feature.getEType() instanceof EClass) {
            if (buffer.capacity() == 1 && buffer.get(0) == -1) {
                buffer.position(buffer.position() + 1);
            } else {
                short cid = buffer.getShort();
                if (wrappedValue) {
                    this.fakePrimitiveRead(feature.getEType(), buffer);
                } else if (cid != -1) {
                    buffer.position(buffer.position() + 8);
                }
            }
        } else if (feature.getEType() instanceof EDataType) {
            this.fakePrimitiveRead(feature.getEType(), buffer);
        }
    }

    private void fakePrimitiveRead(EClassifier classifier, ByteBuffer buffer) throws BimserverDatabaseException {
        if (classifier == EcorePackage.eINSTANCE.getEString()) {
            int length = buffer.getInt();
            if (length != -1) {
                buffer.position(buffer.position() + length);
            }
        } else if (classifier == EcorePackage.eINSTANCE.getEInt() || classifier == EcorePackage.eINSTANCE.getEIntegerObject()) {
            buffer.position(buffer.position() + 4);
        } else if (classifier == EcorePackage.eINSTANCE.getELong() || classifier == EcorePackage.eINSTANCE.getELongObject()) {
            buffer.position(buffer.position() + 8);
        } else if (classifier == EcorePackage.eINSTANCE.getEFloat() || classifier == EcorePackage.eINSTANCE.getEFloatObject()) {
            buffer.position(buffer.position() + 4);
        } else if (classifier == EcorePackage.eINSTANCE.getEDouble() || classifier == EcorePackage.eINSTANCE.getEDoubleObject()) {
            buffer.position(buffer.position() + 8);
        } else if (classifier == EcorePackage.eINSTANCE.getEBoolean() || classifier == EcorePackage.eINSTANCE.getEBooleanObject()) {
            buffer.position(buffer.position() + 1);
        } else if (classifier == EcorePackage.eINSTANCE.getEDate()) {
            buffer.position(buffer.position() + 8);
        } else if (classifier == EcorePackage.eINSTANCE.getEByteArray()) {
            int length = buffer.getInt();
            if (length != -1) {
                buffer.position(buffer.position() + length);
            }
        } else {
            throw new BimserverDatabaseException("Unimplemented " + classifier);
        }
    }

    private IdEObject readReference(EClass originalQueryClass, ByteBuffer buffer, IfcModelInterface model, IdEObject object, EStructuralFeature feature, EClass eClass, QueryInterface query, TodoList todoList) throws BimserverDatabaseException {
        if (buffer.capacity() == 1 && buffer.get(0) == -1) {
            buffer.position(buffer.position() + 1);
            return null;
        }
        long oid = buffer.getLong();
        IdEObject foundInCache = this.objectCache.get(oid);
        if (foundInCache != null) {
            return foundInCache;
        }
        if (model.contains(oid)) {
            return model.get(oid);
        }
        IdEObjectImpl newObject = this.createInternal(eClass, query);
        newObject.setOid(oid);
        if (this.perRecordVersioning((IdEObject)newObject)) {
            newObject.setPid(1);
        } else {
            newObject.setPid(query.getPid());
        }
        newObject.setRid(query.getRid());
        try {
            newObject.setModel(model);
        }
        catch (IfcModelInterfaceException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.objectCache.put(oid, (IdEObject)newObject);
        if (query.isDeep() && object.eClass().getEAnnotation("wrapped") == null) {
            if (feature.getEAnnotation("nolazyload") == null) {
                todoList.add(newObject);
            }
        } else if (object.eClass().getEAnnotation("wrapped") == null) {
            try {
                model.addAllowMultiModel(oid, (IdEObject)newObject);
            }
            catch (IfcModelInterfaceException e) {
                throw new BimserverDatabaseException((Throwable)e);
            }
        }
        return newObject;
    }

    private IdEObject readWrappedValue(EStructuralFeature feature, ByteBuffer buffer, EClass eClass, QueryInterface query) {
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("wrappedValue");
        Object primitiveValue = this.readPrimitiveValue(eStructuralFeature.getEType(), buffer, query);
        IdEObjectImpl eObject = this.createInternal(eClass, query);
        eObject.setLoaded();
        eObject.eSet(eStructuralFeature, primitiveValue);
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
            EStructuralFeature strFeature = eClass.getEStructuralFeature("wrappedValueAsString");
            Object stringVal = this.readPrimitiveValue((EClassifier)EcorePackage.eINSTANCE.getEString(), buffer, query);
            eObject.eSet(strFeature, stringVal);
        }
        return eObject;
    }

    private IdEObject readEmbeddedValue(EStructuralFeature feature, ByteBuffer buffer, EClass eClass, QueryInterface query) {
        IdEObjectImpl eObject = this.createInternal(eClass, query);
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (eStructuralFeature.isMany()) continue;
            Object primitiveValue = this.readPrimitiveValue(eStructuralFeature.getEType(), buffer, query);
            eObject.setLoaded();
            eObject.eSet(eStructuralFeature, primitiveValue);
        }
        return eObject;
    }

    public void store(Collection<? extends IdEObject> values, int pid, int rid) throws BimserverDatabaseException {
        this.checkOpen();
        for (IdEObject idEObject : values) {
            this.store(idEObject, pid, rid);
        }
    }

    public void store(IdEObject object, boolean deep) throws BimserverDatabaseException {
        this.checkOpen();
        HashSet<IdEObject> done = new HashSet<IdEObject>();
        this.storeDeep(object, done);
    }

    private void storeDeep(IdEObject object, Set<IdEObject> done) throws BimserverDatabaseException {
        if (object == null || done.contains(object)) {
            return;
        }
        done.add(object);
        this.store(object);
        for (EReference eReference : object.eClass().getEAllReferences()) {
            if (eReference.isMany()) {
                List list = (List)object.eGet((EStructuralFeature)eReference);
                for (Object v : list) {
                    this.storeDeep((IdEObject)v, done);
                }
                continue;
            }
            IdEObject reference = (IdEObject)object.eGet((EStructuralFeature)eReference);
            this.storeDeep(reference, done);
        }
    }

    public long store(IdEObject object) throws BimserverDatabaseException {
        this.checkOpen();
        return this.store(object, 1, Integer.MAX_VALUE);
    }

    public long store(IdEObject object, int pid, int rid) throws BimserverDatabaseException {
        this.checkOpen();
        if (!this.objectsToCommit.containsObject(object) && !this.objectsToDelete.contains(object)) {
            boolean wrappedValue;
            this.objectCache.put(object.getOid(), object);
            boolean bl = wrappedValue = object.eClass().getEAnnotation("wrapped") != null;
            if (!wrappedValue) {
                if (object.getOid() == -1L) {
                    long newOid = this.newOid(object.eClass());
                    ((IdEObjectImpl)object).setOid(newOid);
                }
                object.load();
                ((IdEObjectImpl)object).setPid(pid);
                if (rid == Integer.MAX_VALUE) {
                    ((IdEObjectImpl)object).setRid(object.getRid() + 1);
                } else {
                    ((IdEObjectImpl)object).setRid(rid);
                }
                this.addToObjectsToCommit(object);
            }
        }
        return object.getOid();
    }

    public void removeFromCommit(IdEObject idEObject) {
        this.objectsToCommit.remove(idEObject);
    }

    private void writePrimitiveValue(EStructuralFeature feature, Object value, ByteBuffer buffer) throws BimserverDatabaseException {
        EClassifier type = feature.getEType();
        if (type == EcorePackage.eINSTANCE.getEString()) {
            if (value == null) {
                buffer.putInt(-1);
            } else {
                String stringValue = (String)value;
                byte[] bytes = stringValue.getBytes(Charsets.UTF_8);
                if (bytes.length > Integer.MAX_VALUE) {
                    throw new BimserverDatabaseException("String value too long (max length is 2147483647)");
                }
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            }
        } else if (type == EcorePackage.eINSTANCE.getEInt() || type == EcorePackage.eINSTANCE.getEIntegerObject()) {
            if (value == null) {
                buffer.putInt(0);
            } else {
                buffer.putInt((Integer)value);
            }
        } else if (type == EcorePackage.eINSTANCE.getEDouble() || type == EcorePackage.eINSTANCE.getEDoubleObject()) {
            if (value == null) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble((Double)value);
            }
        } else if (type == EcorePackage.eINSTANCE.getEFloat() || type == EcorePackage.eINSTANCE.getEFloatObject()) {
            if (value == null) {
                buffer.putFloat(0.0f);
            } else {
                buffer.putFloat(((Float)value).floatValue());
            }
        } else if (type == EcorePackage.eINSTANCE.getELong() || type == EcorePackage.eINSTANCE.getELongObject()) {
            if (value == null) {
                buffer.putLong(0L);
            } else {
                buffer.putLong((Long)value);
            }
        } else if (type == EcorePackage.eINSTANCE.getEBoolean() || type == EcorePackage.eINSTANCE.getEBooleanObject()) {
            if (value == null) {
                buffer.put((byte)0);
            } else {
                buffer.put((Boolean)value != false ? (byte)1 : 0);
            }
        } else if (type == EcorePackage.eINSTANCE.getEDate()) {
            if (value == null) {
                buffer.putLong(-1L);
            } else {
                buffer.putLong(((Date)value).getTime());
            }
        } else if (type.getName().equals("Tristate")) {
            Enumerator eEnumLiteral = (Enumerator)value;
            buffer.putInt(eEnumLiteral.getValue());
        } else if (value instanceof Enumerator) {
            Enumerator eEnumLiteral = (Enumerator)value;
            buffer.putInt(eEnumLiteral.getValue());
        } else if (type == EcorePackage.eINSTANCE.getEByteArray()) {
            if (value == null) {
                buffer.putInt(0);
            } else {
                byte[] bytes = (byte[])value;
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            }
        } else {
            throw new RuntimeException("Unsupported type " + type.getName());
        }
    }

    private void writeReference(IdEObject object, Object value, ByteBuffer buffer, EStructuralFeature feature) throws BimserverDatabaseException {
        Short cid = this.database.getCidOfEClass(((EObject)value).eClass());
        buffer.putShort(cid);
        IdEObject idEObject = (IdEObject)value;
        if (idEObject.getOid() < 0L) {
            throw new BimserverDatabaseException("Writing a reference with oid " + idEObject.getOid() + ", this is not supposed to happen, referenced: " + idEObject.getOid() + " " + value + " from " + object.getOid() + " " + object);
        }
        buffer.putLong(idEObject.getOid());
    }

    private void writeEmbeddedValue(int pid, int rid, Object value, ByteBuffer buffer, PackageMetaData packageMetaData) throws BimserverDatabaseException {
        IdEObject wrappedValue = (IdEObject)value;
        Short cid = this.database.getCidOfEClass(wrappedValue.eClass());
        buffer.putShort(-cid.shortValue());
        for (EStructuralFeature eStructuralFeature : wrappedValue.eClass().getEAllStructuralFeatures()) {
            if (eStructuralFeature.isMany()) {
                this.writeList(wrappedValue, buffer, packageMetaData, eStructuralFeature);
                continue;
            }
            this.writePrimitiveValue(eStructuralFeature, wrappedValue.eGet(eStructuralFeature), buffer);
        }
    }

    private void writeWrappedValue(int pid, int rid, Object value, ByteBuffer buffer, PackageMetaData packageMetaData) throws BimserverDatabaseException {
        IdEObject wrappedValue = (IdEObject)value;
        EStructuralFeature eStructuralFeature = wrappedValue.eClass().getEStructuralFeature("wrappedValue");
        Short cid = this.database.getCidOfEClass(wrappedValue.eClass());
        buffer.putShort(-cid.shortValue());
        this.writePrimitiveValue(eStructuralFeature, wrappedValue.eGet(eStructuralFeature), buffer);
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
            EStructuralFeature fe = wrappedValue.eClass().getEStructuralFeature("wrappedValueAsString");
            this.writePrimitiveValue(fe, wrappedValue.eGet(fe), buffer);
        }
        if (wrappedValue.eClass().getName().equals("IfcGloballyUniqueId")) {
            EClass eClass = packageMetaData.getEClass("IfcGloballyUniqueId");
            if (wrappedValue.getOid() == -1L) {
                ((IdEObjectImpl)wrappedValue).setOid(this.newOid(eClass));
            }
            ByteBuffer valueBuffer = this.convertObjectToByteArray(wrappedValue, ByteBuffer.allocate(this.getExactSize(wrappedValue, packageMetaData, true)), packageMetaData);
            ByteBuffer keyBuffer = this.createKeyBuffer(pid, wrappedValue.getOid(), rid);
            try {
                this.database.getKeyValueStore().storeNoOverwrite(eClass.getEPackage().getName() + "_" + eClass.getName(), keyBuffer.array(), valueBuffer.array(), this);
                this.database.incrementCommittedWrites(1L);
            }
            catch (BimserverLockConflictException e) {
                LOGGER.error("", (Throwable)((Object)e));
            }
        }
    }

    public Set<String> getAvailableClassesInRevision(QueryInterface query) throws BimserverDatabaseException {
        IfcModelInterface model = this.createModel(query);
        return this.getAvailableClassesInRevision(model, query);
    }

    public Set<String> getAvailableClassesInRevision(IfcModelInterface ifcModel, QueryInterface query) throws BimserverDatabaseException {
        this.checkOpen();
        try {
            this.getMap(ifcModel, query);
            HashSet<String> classes = new HashSet<String>();
            for (IdEObject idEObject : ifcModel.getValues()) {
                classes.add(idEObject.eClass().getName());
            }
            return classes;
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public long getTransactionId() {
        return this.bimTransaction.getId();
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public <T> T create(EClass eClass, int pid, int rid) throws BimserverDatabaseException {
        this.checkOpen();
        IdEObjectImpl idEObject = this.createInternal(eClass, null);
        this.store((IdEObject)idEObject, pid, rid);
        return (T)idEObject;
    }

    public <T extends IdEObject> T getSingle(EClass eClass, QueryInterface query) throws BimserverDatabaseException {
        IfcModelInterface model = this.createModel(query);
        List all = this.getAllOfType(model, eClass, query).getAll(eClass.getInstanceClass());
        if (all.size() > 0) {
            return (T)((IdEObject)all.get(0));
        }
        return null;
    }

    public void commit() throws BimserverDatabaseException, ServiceException {
        this.commit(null);
    }

    public <T extends IdEObject> T create(Class<T> clazz) throws BimserverDatabaseException {
        return (T)((IdEObject)this.create(this.database.getEClass(clazz.getPackage().getName(), clazz.getSimpleName())));
    }

    public EObject create(EClass eClass) {
        IdEObjectImpl idEObject = this.createInternal(eClass, null);
        try {
            this.store((IdEObject)idEObject, 1, Integer.MAX_VALUE);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        return idEObject;
    }

    public <T extends IdEObject> List<T> getAllOfType(EClass eClass, Class<T> clazz, QueryInterface query) throws BimserverDatabaseException {
        IfcModelInterface allOfType = this.getAllOfType(eClass.getEPackage().getName(), eClass.getName(), query);
        return allOfType.getAllWithSubTypes(clazz);
    }

    public EClass getEClassForOid(long oid) throws BimserverDatabaseException {
        return this.database.getEClassForOid(oid);
    }

    public long getCounter(EClass eClass) {
        return this.database.getCounter(eClass);
    }

    public <T extends IdEObject> T querySingle(EAttribute attribute, Object value) throws BimserverLockConflictException, BimserverDatabaseException {
        if (attribute.getEAnnotation("singleindex") != null) {
            String indexTableName = attribute.getEContainingClass().getEPackage().getName() + "_" + attribute.getEContainingClass().getName() + "_" + attribute.getName();
            byte[] queryBytes = null;
            if (value instanceof String) {
                queryBytes = ((String)value).getBytes(Charsets.UTF_8);
            } else if (value instanceof Integer) {
                queryBytes = BinUtils.intToByteArray((int)((Integer)value));
            } else {
                throw new BimserverDatabaseException("Unsupported type " + value);
            }
            byte[] firstDuplicate = this.database.getKeyValueStore().get(indexTableName, queryBytes, this);
            if (firstDuplicate != null) {
                ByteBuffer buffer = ByteBuffer.wrap(firstDuplicate);
                buffer.getInt();
                long oid = buffer.getLong();
                return this.get(oid, OldQuery.getDefault());
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public <T extends IdEObject> List<T> query(EAttribute attribute, Object value) throws BimserverLockConflictException, BimserverDatabaseException {
        ArrayList<T> result = new ArrayList<T>();
        if (attribute.getEAnnotation("singleindex") != null) {
            String indexTableName = attribute.getEContainingClass().getEPackage().getName() + "_" + attribute.getEContainingClass().getName() + "_" + attribute.getName();
            byte[] queryBytes = null;
            if (value instanceof String) {
                queryBytes = ((String)value).getBytes(Charsets.UTF_8);
            } else if (value instanceof Integer) {
                queryBytes = BinUtils.intToByteArray((int)((Integer)value));
            } else {
                throw new BimserverDatabaseException("Unsupported type " + value);
            }
            List<byte[]> duplicates = this.database.getKeyValueStore().getDuplicates(indexTableName, queryBytes, this);
            for (byte[] indexValue : duplicates) {
                ByteBuffer buffer = ByteBuffer.wrap(indexValue);
                buffer.getInt();
                long oid = buffer.getLong();
                result.add(this.get(oid, OldQuery.getDefault()));
            }
        }
        return result;
    }

    public byte[] extractFeatureBytes(DatabaseSession databaseSession, ByteBuffer buffer, EClass eClass, EStructuralFeature eStructuralFeature) throws BimserverDatabaseException {
        PackageMetaData packageMetaData = this.getMetaDataManager().getPackageMetaData(eClass.getEPackage().getName());
        buffer.position(0);
        int fieldCounter = 0;
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!packageMetaData.useForDatabaseStorage(eClass, feature)) continue;
            ++fieldCounter;
        }
        int unsettedLength = (int)Math.ceil((double)fieldCounter / 8.0);
        byte[] unsetted = new byte[unsettedLength];
        buffer.get(unsetted);
        fieldCounter = 0;
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            boolean isUnsetted;
            boolean bl = isUnsetted = (unsetted[fieldCounter / 8] & 1 << fieldCounter % 8) != 0;
            if (!isUnsetted) {
                if (eStructuralFeature == feature) {
                    return databaseSession.readPrimitiveBytes(feature.getEType(), buffer, OldQuery.getDefault());
                }
                databaseSession.fakeRead(buffer, feature);
            }
            ++fieldCounter;
        }
        return null;
    }

    public SessionState getState() {
        return this.state;
    }

    public int save(VirtualObject object) throws BimserverLockConflictException, BimserverConcurrentModificationDatabaseException, BimserverDatabaseException {
        ByteBuffer valueBuffer = object.write();
        EClass eClass = object.eClass();
        ByteBuffer keyBuffer = this.createKeyBuffer(object.getPid(), object.getOid(), object.getRid());
        this.database.getKeyValueStore().storeNoOverwrite(eClass.getEPackage().getName() + "_" + eClass.getName(), keyBuffer.array(), valueBuffer.array(), 0, valueBuffer.position(), this);
        this.database.incrementCommittedWrites(1L);
        return valueBuffer.position();
    }

    public int saveOverwrite(VirtualObject object) throws BimserverLockConflictException, BimserverConcurrentModificationDatabaseException, BimserverDatabaseException {
        ByteBuffer valueBuffer = object.write();
        EClass eClass = object.eClass();
        ByteBuffer keyBuffer = this.createKeyBuffer(object.getPid(), object.getOid(), object.getRid());
        this.database.getKeyValueStore().store(eClass.getEPackage().getName() + "_" + eClass.getName(), keyBuffer.array(), valueBuffer.array(), 0, valueBuffer.position(), this);
        this.database.incrementCommittedWrites(1L);
        return valueBuffer.position();
    }

    public KeyValueStore getKeyValueStore() {
        return this.database.getKeyValueStore();
    }

    public static enum GetResult {
        STOP,
        CONTINUE_WITH_NEXT_RECORD,
        CONTINUE_WITH_NEXT_OID;

    }

    public static enum SessionState {
        OPEN,
        CLOSED;

    }
}

