/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;

public class ObjectCache {
    private final BiMap<Long, IdEObjectImpl> oidCache = HashBiMap.create();

    public void put(long oid, IdEObject object) {
        if (!this.oidCache.containsValue((Object)object)) {
            this.oidCache.put((Object)oid, (Object)((IdEObjectImpl)object));
        }
    }

    public IdEObject get(long oid) {
        return (IdEObject)this.oidCache.get((Object)oid);
    }

    public long get(IdEObject object) {
        return (Long)this.oidCache.inverse().get((Object)object);
    }

    public boolean contains(IdEObject object) {
        return this.oidCache.inverse().containsKey((Object)object);
    }

    public boolean contains(long oid) {
        return this.oidCache.containsKey((Object)oid);
    }

    public void clear() {
        this.oidCache.clear();
    }
}

