/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.database;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;

public class ObjectsToCommit
implements Iterable<IdEObject> {
    private final BiMap<IdEObject, Long> objectsToCommitFirst = HashBiMap.create();
    private final BiMap<IdEObject, Long> objectsToCommitSecond = HashBiMap.create();

    public void put(IdEObject idEObject) {
        this.getMap(idEObject).forcePut((Object)idEObject, (Object)idEObject.getOid());
    }

    public int size() {
        return this.objectsToCommitFirst.size() + this.objectsToCommitSecond.size();
    }

    public BiMap<IdEObject, Long> getMap(IdEObject idEObject) {
        if (idEObject.eClass().getEPackage() == Ifc2x3tc1Package.eINSTANCE || idEObject.eClass().getEPackage() == Ifc4Package.eINSTANCE) {
            return this.objectsToCommitFirst;
        }
        return this.objectsToCommitSecond;
    }

    public boolean containsObject(IdEObject object) {
        return this.getMap(object).containsKey((Object)object);
    }

    public boolean containsOid(long oid) {
        return this.objectsToCommitFirst.containsValue((Object)oid) || this.objectsToCommitSecond.containsValue((Object)oid);
    }

    public IdEObject getByOid(long oid) {
        IdEObject result = (IdEObject)this.objectsToCommitFirst.inverse().get((Object)oid);
        if (result == null) {
            return (IdEObject)this.objectsToCommitSecond.inverse().get((Object)oid);
        }
        return result;
    }

    @Override
    public Iterator<IdEObject> iterator() {
        return Iterators.concat(this.objectsToCommitFirst.keySet().iterator(), this.objectsToCommitSecond.keySet().iterator());
    }

    public void clear() {
        this.objectsToCommitFirst.clear();
        this.objectsToCommitSecond.clear();
    }

    public void remove(IdEObject object) {
        this.objectsToCommitFirst.remove((Object)object);
        this.objectsToCommitSecond.remove((Object)object);
    }
}

